/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.TaskConfigurator;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.ui.panels.PIDSelectPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProfilingSupport {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilingSupport.class, (String)"CAPTION_Question");
    private static final String STOP_START_PROFILE_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartProfileSessionMessage");
    private static final String STOP_START_ATTACH_SESSION_MESSAGE = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_StopStartAttachSessionMessage");
    private static final String FAILED_LOAD_SETTINGS_MSG = NbBundle.getMessage(ProfilingSupport.class, (String)"ProfilingSupport_FailedLoadSettingsMsg");
    private static ProfilingSupport defaultInstance;
    private boolean profilingActionInvoked = false;

    private ProfilingSupport() {
    }

    public static ProfilingSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingSupport();
        }
        return defaultInstance;
    }

    public static boolean checkProfilingInProgress() {
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)STOP_START_PROFILE_SESSION_MESSAGE, (String)QUESTION_DIALOG_CAPTION)) {
                    return true;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)STOP_START_ATTACH_SESSION_MESSAGE, (String)QUESTION_DIALOG_CAPTION)) {
                    return true;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        return false;
    }

    public AttachSTPData selectTaskForAttach(Lookup.Provider provider, SessionSettings sessionSettings) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureAttachProfilerTask(provider);
        if (configuration == null) {
            return null;
        }
        return new AttachSTPData(configuration.getProfilingSettings(), configuration.getProject());
    }

    public ProfilingSettings selectTaskForProfiling(Lookup.Provider provider, SessionSettings sessionSettings, FileObject fileObject, boolean bl) {
        TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureProfileProjectTask(provider, fileObject, bl);
        if (configuration == null) {
            return null;
        }
        return configuration.getProfilingSettings();
    }

    public void setProfilingActionInvoked(boolean bl) {
        this.profilingActionInvoked = bl;
    }

    public boolean isProfilingActionInvoked() {
        return this.profilingActionInvoked;
    }

    void doAttach() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AttachSTPData attachSTPData;
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    Lookup.Provider provider = null;
                    GlobalProfilingSettings globalProfilingSettings = Profiler.getDefault().getGlobalProfilingSettings();
                    SessionSettings sessionSettings = new SessionSettings();
                    sessionSettings.setPortNo(globalProfilingSettings.getPortNo());
                    ProjectProfilingSupport projectProfilingSupport = ProjectProfilingSupport.get(provider);
                    projectProfilingSupport.setupProjectSessionSettings(sessionSettings);
                    boolean bl = false;
                    ProfilingSettings profilingSettings = null;
                    while (!bl) {
                        attachSTPData = ProfilingSupport.this.selectTaskForAttach(provider, sessionSettings);
                        if (attachSTPData == null) {
                            return;
                        }
                        provider = attachSTPData.getProject();
                        profilingSettings = attachSTPData.getSettings();
                        ProfilerLogger.log((String)(">>> Project: " + provider));
                        ProfilerLogger.log((String)(">>> Profiling settings: " + profilingSettings));
                        bl = true;
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(provider, null);
                    attachSTPData = null;
                    try {
                        attachSTPData = ProjectStorage.loadAttachSettings(provider);
                    }
                    catch (IOException iOException) {
                        ProfilerDialogs.displayWarning((String)MessageFormat.format(FAILED_LOAD_SETTINGS_MSG, iOException.getMessage()));
                        ProfilerLogger.log((Exception)iOException);
                    }
                    ProfilerLogger.log((String)(">>> Attach settings: " + attachSTPData));
                    if (attachSTPData == null) {
                        attachSTPData = AttachWizard.getDefault().configure((AttachSettings)attachSTPData);
                        if (attachSTPData == null) {
                            return;
                        }
                        ProjectStorage.saveAttachSettings((Lookup.Provider)provider, (AttachSettings)attachSTPData);
                    }
                    if (!attachSTPData.isRemote() && attachSTPData.isDynamic16()) {
                        int n = PIDSelectPanel.selectPID();
                        if (n == -1) {
                            return;
                        }
                        attachSTPData.setPid(n);
                    }
                    Profiler.getDefault().attachToApp(profilingSettings, (AttachSettings)attachSTPData);
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                }
            }
        });
    }

    void modifyProfiling() {
        if (this.isProfilingActionInvoked()) {
            return;
        }
        this.setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Profiler.getDefault().getTargetAppRunner().getAppStatusHandler().pauseLiveUpdates();
                    boolean bl = Profiler.getDefault().getProfilingMode() == 0;
                    TaskConfigurator.Configuration configuration = TaskConfigurator.getDefault().configureModifyProfilingTask(NetBeansProfiler.getDefaultNB().getProfiledProject(), NetBeansProfiler.getDefaultNB().getProfiledSingleFile(), Profiler.getDefault().getProfilingMode() == 0);
                    if (configuration == null) {
                        return;
                    }
                    Profiler.getDefault().modifyCurrentProfiling(configuration.getProfilingSettings());
                }
                finally {
                    ProfilingSupport.this.setProfilingActionInvoked(false);
                    Profiler.getDefault().getTargetAppRunner().getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public static class AttachSTPData {
        private ProfilingSettings ps;
        private Lookup.Provider p;

        private AttachSTPData(ProfilingSettings profilingSettings, Lookup.Provider provider) {
            this.ps = profilingSettings;
            this.p = provider;
        }

        public Lookup.Provider getProject() {
            return this.p;
        }

        public ProfilingSettings getSettings() {
            return this.ps;
        }
    }
}

