/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsUserPrincipals;

class WindowsSecurityDescriptor {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final short SIZEOF_ACL = 8;
    private static final short SIZEOF_ACCESS_ALLOWED_ACE = 12;
    private static final short SIZEOF_ACCESS_DENIED_ACE = 12;
    private static final short SIZEOF_SECURITY_DESCRIPTOR = 20;
    private static final short OFFSETOF_TYPE = 0;
    private static final short OFFSETOF_FLAGS = 1;
    private static final short OFFSETOF_ACCESS_MASK = 4;
    private static final short OFFSETOF_SID = 8;
    private static final WindowsSecurityDescriptor NULL_DESCRIPTOR = new WindowsSecurityDescriptor();
    private final List<Long> sidList;
    private final NativeBuffer aclBuffer;
    private final NativeBuffer sdBuffer;

    private WindowsSecurityDescriptor() {
        this.sidList = null;
        this.aclBuffer = null;
        this.sdBuffer = null;
    }

    private WindowsSecurityDescriptor(List<AclEntry> list) throws IOException {
        boolean bl = false;
        list = new ArrayList<AclEntry>(list);
        this.sidList = new ArrayList<Long>(list.size());
        try {
            int n = 8;
            for (AclEntry aclEntry : list) {
                UserPrincipal userPrincipal = aclEntry.principal();
                if (!(userPrincipal instanceof WindowsUserPrincipals.User)) {
                    throw new ProviderMismatchException();
                }
                String string = ((WindowsUserPrincipals.User)userPrincipal).sidString();
                try {
                    long l = WindowsNativeDispatcher.ConvertStringSidToSid(string);
                    this.sidList.add(l);
                    n += WindowsNativeDispatcher.GetLengthSid(l) + Math.max(12, 12);
                }
                catch (WindowsException windowsException) {
                    throw new IOException("Failed to get SID for " + userPrincipal.getName() + ": " + windowsException.errorString());
                }
            }
            this.aclBuffer = NativeBuffers.getNativeBuffer(n);
            this.sdBuffer = NativeBuffers.getNativeBuffer(20);
            WindowsNativeDispatcher.InitializeAcl(this.aclBuffer.address(), n);
            for (int i = 0; i < list.size(); ++i) {
                AclEntry aclEntry;
                aclEntry = list.get(i);
                long l = this.sidList.get(i);
                try {
                    WindowsSecurityDescriptor.encode(aclEntry, l, this.aclBuffer.address());
                    continue;
                }
                catch (WindowsException windowsException) {
                    throw new IOException("Failed to encode ACE: " + windowsException.errorString());
                }
            }
            WindowsNativeDispatcher.InitializeSecurityDescriptor(this.sdBuffer.address());
            WindowsNativeDispatcher.SetSecurityDescriptorDacl(this.sdBuffer.address(), this.aclBuffer.address());
            bl = true;
        }
        catch (WindowsException windowsException) {
            throw new IOException(windowsException.getMessage());
        }
        finally {
            if (!bl) {
                this.release();
            }
        }
    }

    void release() {
        if (this.sdBuffer != null) {
            this.sdBuffer.release();
        }
        if (this.aclBuffer != null) {
            this.aclBuffer.release();
        }
        if (this.sidList != null) {
            for (Long l : this.sidList) {
                WindowsNativeDispatcher.LocalFree(l);
            }
        }
    }

    long address() {
        return this.sdBuffer == null ? 0L : this.sdBuffer.address();
    }

    private static AclEntry decode(long l) throws IOException {
        byte by = unsafe.getByte(l + 0L);
        if (by != 0 && by != 1) {
            return null;
        }
        AclEntryType aclEntryType = by == 0 ? AclEntryType.ALLOW : AclEntryType.DENY;
        byte by2 = unsafe.getByte(l + 1L);
        EnumSet<AclEntryFlag> enumSet = EnumSet.noneOf(AclEntryFlag.class);
        if ((by2 & 1) != 0) {
            enumSet.add(AclEntryFlag.FILE_INHERIT);
        }
        if ((by2 & 2) != 0) {
            enumSet.add(AclEntryFlag.DIRECTORY_INHERIT);
        }
        if ((by2 & 4) != 0) {
            enumSet.add(AclEntryFlag.NO_PROPAGATE_INHERIT);
        }
        if ((by2 & 8) != 0) {
            enumSet.add(AclEntryFlag.INHERIT_ONLY);
        }
        int n = unsafe.getInt(l + 4L);
        EnumSet<AclEntryPermission> enumSet2 = EnumSet.noneOf(AclEntryPermission.class);
        if ((n & 1) > 0) {
            enumSet2.add(AclEntryPermission.READ_DATA);
        }
        if ((n & 2) > 0) {
            enumSet2.add(AclEntryPermission.WRITE_DATA);
        }
        if ((n & 4) > 0) {
            enumSet2.add(AclEntryPermission.APPEND_DATA);
        }
        if ((n & 8) > 0) {
            enumSet2.add(AclEntryPermission.READ_NAMED_ATTRS);
        }
        if ((n & 0x10) > 0) {
            enumSet2.add(AclEntryPermission.WRITE_NAMED_ATTRS);
        }
        if ((n & 0x20) > 0) {
            enumSet2.add(AclEntryPermission.EXECUTE);
        }
        if ((n & 0x40) > 0) {
            enumSet2.add(AclEntryPermission.DELETE_CHILD);
        }
        if ((n & 0x80) > 0) {
            enumSet2.add(AclEntryPermission.READ_ATTRIBUTES);
        }
        if ((n & 0x100) > 0) {
            enumSet2.add(AclEntryPermission.WRITE_ATTRIBUTES);
        }
        if ((n & 0x10000) > 0) {
            enumSet2.add(AclEntryPermission.DELETE);
        }
        if ((n & 0x20000) > 0) {
            enumSet2.add(AclEntryPermission.READ_ACL);
        }
        if ((n & 0x40000) > 0) {
            enumSet2.add(AclEntryPermission.WRITE_ACL);
        }
        if ((n & 0x80000) > 0) {
            enumSet2.add(AclEntryPermission.WRITE_OWNER);
        }
        if ((n & 0x100000) > 0) {
            enumSet2.add(AclEntryPermission.SYNCHRONIZE);
        }
        long l2 = l + 8L;
        UserPrincipal userPrincipal = WindowsUserPrincipals.fromSid((long)l2);
        return AclEntry.newBuilder().setType(aclEntryType).setPrincipal(userPrincipal).setFlags(enumSet).setPermissions(enumSet2).build();
    }

    private static void encode(AclEntry aclEntry, long l, long l2) throws WindowsException {
        if (aclEntry.type() != AclEntryType.ALLOW && aclEntry.type() != AclEntryType.DENY) {
            return;
        }
        boolean bl = aclEntry.type() == AclEntryType.ALLOW;
        Set<AclEntryPermission> set = aclEntry.permissions();
        int n = 0;
        if (set.contains((Object)AclEntryPermission.READ_DATA)) {
            n |= 1;
        }
        if (set.contains((Object)AclEntryPermission.WRITE_DATA)) {
            n |= 2;
        }
        if (set.contains((Object)AclEntryPermission.APPEND_DATA)) {
            n |= 4;
        }
        if (set.contains((Object)AclEntryPermission.READ_NAMED_ATTRS)) {
            n |= 8;
        }
        if (set.contains((Object)AclEntryPermission.WRITE_NAMED_ATTRS)) {
            n |= 0x10;
        }
        if (set.contains((Object)AclEntryPermission.EXECUTE)) {
            n |= 0x20;
        }
        if (set.contains((Object)AclEntryPermission.DELETE_CHILD)) {
            n |= 0x40;
        }
        if (set.contains((Object)AclEntryPermission.READ_ATTRIBUTES)) {
            n |= 0x80;
        }
        if (set.contains((Object)AclEntryPermission.WRITE_ATTRIBUTES)) {
            n |= 0x100;
        }
        if (set.contains((Object)AclEntryPermission.DELETE)) {
            n |= 0x10000;
        }
        if (set.contains((Object)AclEntryPermission.READ_ACL)) {
            n |= 0x20000;
        }
        if (set.contains((Object)AclEntryPermission.WRITE_ACL)) {
            n |= 0x40000;
        }
        if (set.contains((Object)AclEntryPermission.WRITE_OWNER)) {
            n |= 0x80000;
        }
        if (set.contains((Object)AclEntryPermission.SYNCHRONIZE)) {
            n |= 0x100000;
        }
        Set<AclEntryFlag> set2 = aclEntry.flags();
        byte by = 0;
        if (set2.contains((Object)AclEntryFlag.FILE_INHERIT)) {
            by = (byte)(by | 1);
        }
        if (set2.contains((Object)AclEntryFlag.DIRECTORY_INHERIT)) {
            by = (byte)(by | 2);
        }
        if (set2.contains((Object)AclEntryFlag.NO_PROPAGATE_INHERIT)) {
            by = (byte)(by | 4);
        }
        if (set2.contains((Object)AclEntryFlag.INHERIT_ONLY)) {
            by = (byte)(by | 8);
        }
        if (bl) {
            WindowsNativeDispatcher.AddAccessAllowedAceEx(l2, by, n, l);
        } else {
            WindowsNativeDispatcher.AddAccessDeniedAceEx(l2, by, n, l);
        }
    }

    static WindowsSecurityDescriptor create(List<AclEntry> list) throws IOException {
        return new WindowsSecurityDescriptor(list);
    }

    static WindowsSecurityDescriptor fromAttribute(FileAttribute<?> ... fileAttributeArray) throws IOException {
        WindowsSecurityDescriptor windowsSecurityDescriptor = NULL_DESCRIPTOR;
        for (FileAttribute<?> fileAttribute : fileAttributeArray) {
            if (windowsSecurityDescriptor != NULL_DESCRIPTOR) {
                windowsSecurityDescriptor.release();
            }
            if (fileAttribute == null) {
                throw new NullPointerException();
            }
            if (!fileAttribute.name().equals("acl:acl")) {
                throw new UnsupportedOperationException("'" + fileAttribute.name() + "' not supported as initial attribute");
            }
            List list = (List)fileAttribute.value();
            windowsSecurityDescriptor = new WindowsSecurityDescriptor(list);
        }
        return windowsSecurityDescriptor;
    }

    static List<AclEntry> getAcl(long l) throws IOException {
        Object object;
        long l2 = WindowsNativeDispatcher.GetSecurityDescriptorDacl(l);
        int n = 0;
        if (l2 == 0L) {
            n = 0;
        } else {
            object = WindowsNativeDispatcher.GetAclInformation(l2);
            n = ((WindowsNativeDispatcher.AclInformation)object).aceCount();
        }
        object = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            long l3 = WindowsNativeDispatcher.GetAce(l2, i);
            AclEntry aclEntry = WindowsSecurityDescriptor.decode(l3);
            if (aclEntry == null) continue;
            ((ArrayList)object).add(aclEntry);
        }
        return object;
    }
}

