/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public class Surrogate {
    public static final char MIN_HIGH = '\ud800';
    public static final char MAX_HIGH = '\udbff';
    public static final char MIN_LOW = '\udc00';
    public static final char MAX_LOW = '\udfff';
    public static final char MIN = '\ud800';
    public static final char MAX = '\udfff';
    public static final int UCS4_MIN = 65536;
    public static final int UCS4_MAX = 0x10FFFF;

    private Surrogate() {
    }

    public static boolean isHigh(int n) {
        return 55296 <= n && n <= 56319;
    }

    public static boolean isLow(int n) {
        return 56320 <= n && n <= 57343;
    }

    public static boolean is(int n) {
        return 55296 <= n && n <= 57343;
    }

    public static boolean neededFor(int n) {
        return Character.isSupplementaryCodePoint(n);
    }

    public static char high(int n) {
        assert (Character.isSupplementaryCodePoint(n));
        return Character.highSurrogate(n);
    }

    public static char low(int n) {
        assert (Character.isSupplementaryCodePoint(n));
        return Character.lowSurrogate(n);
    }

    public static int toUCS4(char c, char c2) {
        assert (Character.isHighSurrogate(c) && Character.isLowSurrogate(c2));
        return Character.toCodePoint(c, c2);
    }

    public static class Generator {
        private CoderResult error = CoderResult.OVERFLOW;

        public CoderResult error() {
            assert (this.error != null);
            return this.error;
        }

        public int generate(int uc, int len, CharBuffer dst) {
            if (Character.isBmpCodePoint(uc)) {
                char c = (char)uc;
                if (Character.isSurrogate(c)) {
                    this.error = CoderResult.malformedForLength(len);
                    return -1;
                }
                if (dst.remaining() < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                dst.put(c);
                this.error = null;
                return 1;
            }
            if (Character.isValidCodePoint(uc)) {
                if (dst.remaining() < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                dst.put(Character.highSurrogate(uc));
                dst.put(Character.lowSurrogate(uc));
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(len);
            return -1;
        }

        public int generate(int uc, int len, char[] da, int dp, int dl) {
            if (Character.isBmpCodePoint(uc)) {
                char c = (char)uc;
                if (Character.isSurrogate(c)) {
                    this.error = CoderResult.malformedForLength(len);
                    return -1;
                }
                if (dl - dp < 1) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                da[dp] = c;
                this.error = null;
                return 1;
            }
            if (Character.isValidCodePoint(uc)) {
                if (dl - dp < 2) {
                    this.error = CoderResult.OVERFLOW;
                    return -1;
                }
                da[dp] = Character.highSurrogate(uc);
                da[dp + 1] = Character.lowSurrogate(uc);
                this.error = null;
                return 2;
            }
            this.error = CoderResult.unmappableForLength(len);
            return -1;
        }
    }

    public static class Parser {
        private int character;
        private CoderResult error = CoderResult.UNDERFLOW;
        private boolean isPair;

        public int character() {
            assert (this.error == null);
            return this.character;
        }

        public boolean isPair() {
            assert (this.error == null);
            return this.isPair;
        }

        public int increment() {
            assert (this.error == null);
            return this.isPair ? 2 : 1;
        }

        public CoderResult error() {
            assert (this.error != null);
            return this.error;
        }

        public CoderResult unmappableResult() {
            assert (this.error == null);
            return CoderResult.unmappableForLength(this.isPair ? 2 : 1);
        }

        public int parse(char c, CharBuffer charBuffer) {
            if (Character.isHighSurrogate(c)) {
                if (!charBuffer.hasRemaining()) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c2 = charBuffer.get();
                if (Character.isLowSurrogate(c2)) {
                    this.character = Character.toCodePoint(c, c2);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public int parse(char c, char[] cArray, int n, int n2) {
            assert (cArray[n] == c);
            if (Character.isHighSurrogate(c)) {
                if (n2 - n < 2) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char c2 = cArray[n + 1];
                if (Character.isLowSurrogate(c2)) {
                    this.character = Character.toCodePoint(c, c2);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }
    }
}

