/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.security.action.GetPropertyAction;

public abstract class RenderingEngine {
    private static RenderingEngine reImpl;

    public static synchronized RenderingEngine getInstance() {
        if (reImpl != null) {
            return reImpl;
        }
        reImpl = (RenderingEngine)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.java2d.renderer", "sun.dc.DuctusRenderingEngine");
                if (string.equals("sun.dc.DuctusRenderingEngine")) {
                    try {
                        Class<?> clazz = Class.forName("sun.dc.DuctusRenderingEngine");
                        return clazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                }
                ServiceLoader<RenderingEngine> serviceLoader = ServiceLoader.loadInstalled(RenderingEngine.class);
                RenderingEngine renderingEngine = null;
                Iterator<RenderingEngine> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    RenderingEngine renderingEngine2;
                    renderingEngine = renderingEngine2 = iterator.next();
                    if (!renderingEngine2.getClass().getName().equals(string)) continue;
                    break;
                }
                return renderingEngine;
            }
        });
        if (reImpl == null) {
            throw new InternalError("No RenderingEngine module found");
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.java2d.renderer.trace");
        String string = AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            reImpl = new Tracer(reImpl);
        }
        return reImpl;
    }

    public abstract Shape createStrokedShape(Shape var1, float var2, int var3, int var4, float var5, float[] var6, float var7);

    public abstract void strokeTo(Shape var1, AffineTransform var2, BasicStroke var3, boolean var4, boolean var5, boolean var6, PathConsumer2D var7);

    public abstract AATileGenerator getAATileGenerator(Shape var1, AffineTransform var2, Region var3, BasicStroke var4, boolean var5, boolean var6, int[] var7);

    public abstract AATileGenerator getAATileGenerator(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, Region var17, int[] var18);

    public abstract float getMinimumAAPenSize();

    public static void feedConsumer(PathIterator pathIterator, PathConsumer2D pathConsumer2D) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    pathConsumer2D.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pathConsumer2D.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    pathConsumer2D.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pathConsumer2D.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pathConsumer2D.closePath();
                }
            }
            pathIterator.next();
        }
    }

    static class Tracer
    extends RenderingEngine {
        RenderingEngine target;
        String name;

        public Tracer(RenderingEngine target) {
            this.target = target;
            this.name = target.getClass().getName();
        }

        @Override
        public Shape createStrokedShape(Shape src, float width, int caps, int join, float miterlimit, float[] dashes, float dashphase) {
            System.out.println(this.name + ".createStrokedShape(" + src.getClass().getName() + ", width = " + width + ", caps = " + caps + ", join = " + join + ", miter = " + miterlimit + ", dashes = " + String.valueOf(dashes) + ", dashphase = " + dashphase + ")");
            return this.target.createStrokedShape(src, width, caps, join, miterlimit, dashes, dashphase);
        }

        @Override
        public void strokeTo(Shape src, AffineTransform at, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, PathConsumer2D consumer) {
            System.out.println(this.name + ".strokeTo(" + src.getClass().getName() + ", " + String.valueOf(at) + ", " + String.valueOf(bs) + ", " + (thin ? "thin" : "wide") + ", " + (normalize ? "normalized" : "pure") + ", " + (antialias ? "AA" : "non-AA") + ", " + consumer.getClass().getName() + ")");
            this.target.strokeTo(src, at, bs, thin, normalize, antialias, consumer);
        }

        public void strokeTo(Shape src, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, PathConsumer2D consumer) {
            System.out.println(this.name + ".strokeTo(" + src.getClass().getName() + ", " + String.valueOf(at) + ", " + String.valueOf(clip) + ", " + String.valueOf(bs) + ", " + (thin ? "thin" : "wide") + ", " + (normalize ? "normalized" : "pure") + ", " + (antialias ? "AA" : "non-AA") + ", " + consumer.getClass().getName() + ")");
            this.target.strokeTo(src, at, clip, bs, thin, normalize, antialias, consumer);
        }

        @Override
        public float getMinimumAAPenSize() {
            System.out.println(this.name + ".getMinimumAAPenSize()");
            return this.target.getMinimumAAPenSize();
        }

        @Override
        public AATileGenerator getAATileGenerator(Shape s, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, int[] bbox) {
            System.out.println(this.name + ".getAATileGenerator(" + s.getClass().getName() + ", " + String.valueOf(at) + ", " + String.valueOf(clip) + ", " + String.valueOf(bs) + ", " + (thin ? "thin" : "wide") + ", " + (normalize ? "normalized" : "pure") + ")");
            return this.target.getAATileGenerator(s, at, clip, bs, thin, normalize, bbox);
        }

        @Override
        public AATileGenerator getAATileGenerator(double x, double y, double dx1, double dy1, double dx2, double dy2, double lw1, double lw2, Region clip, int[] bbox) {
            System.out.println(this.name + ".getAATileGenerator(" + x + ", " + y + ", " + dx1 + ", " + dy1 + ", " + dx2 + ", " + dy2 + ", " + lw1 + ", " + lw2 + ", " + String.valueOf(clip) + ")");
            return this.target.getAATileGenerator(x, y, dx1, dy1, dx2, dy2, lw1, lw2, clip, bbox);
        }
    }
}

