/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarVerifier;
import java.util.jar.JavaUtilJarAccessImpl;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.misc.IOUtils;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.util.ManifestEntryVerifier;

public class JarFile
extends ZipFile {
    private SoftReference<Manifest> manRef;
    private JarEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean computedHasClassPathAttribute;
    private boolean hasClassPathAttribute;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static int[] lastOcc;
    private static int[] optoSft;
    private static char[] src;
    private static String javaHome;
    private static String[] jarNames;

    public JarFile(String string) throws IOException {
        this(new File(string), true, 1);
    }

    public JarFile(String string, boolean bl) throws IOException {
        this(new File(string), bl, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl) throws IOException {
        this(file, bl, 1);
    }

    public JarFile(File file, boolean bl, int n) throws IOException {
        super(file, n);
        this.verify = bl;
    }

    public Manifest getManifest() throws IOException {
        return this.getManifestFromReference();
    }

    private Manifest getManifestFromReference() throws IOException {
        JarEntry jarEntry;
        Manifest manifest;
        Manifest manifest2 = manifest = this.manRef != null ? this.manRef.get() : null;
        if (manifest == null && (jarEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] byArray = this.getBytes(jarEntry);
                manifest = new Manifest(new ByteArrayInputStream(byArray));
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(byArray);
                }
            } else {
                manifest = new Manifest(super.getInputStream(jarEntry));
            }
            this.manRef = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    @Override
    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        Enumeration<? extends ZipEntry> enumeration = super.entries();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] stringArray = this.getMetaInfEntryNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].toUpperCase(Locale.ENGLISH);
                    if (!string.endsWith(".DSA") && !string.endsWith(".RSA") && !string.endsWith(".EC") && !string.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block10: {
            ManifestEntryVerifier manifestEntryVerifier = null;
            try {
                String[] stringArray = this.getMetaInfEntryNames();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        byte[] byArray;
                        JarEntry jarEntry = this.getJarEntry(stringArray[i]);
                        if (jarEntry == null) {
                            throw new JarException("corrupted jar file");
                        }
                        if (jarEntry.isDirectory()) continue;
                        if (manifestEntryVerifier == null) {
                            manifestEntryVerifier = new ManifestEntryVerifier(this.getManifestFromReference());
                        }
                        if ((byArray = this.getBytes(jarEntry)) == null || byArray.length <= 0) continue;
                        this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                        this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                        this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                    }
                }
            }
            catch (IOException iOException) {
                this.jv = null;
                this.verify = false;
                if (JarVerifier.debug == null) break block10;
                JarVerifier.debug.println("jarfile parsing error!");
                iOException.printStackTrace();
            }
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        try (InputStream inputStream = super.getInputStream(zipEntry);){
            byte[] byArray = IOUtils.readFully(inputStream, (int)zipEntry.getSize(), true);
            return byArray;
        }
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        this.maybeInstantiateVerifier();
        if (this.jv == null) {
            return super.getInputStream(zipEntry);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(zipEntry);
            }
        }
        return new JarVerifier.VerifierStream(this.getManifestFromReference(), zipEntry instanceof JarFileEntry ? (JarEntry)zipEntry : this.getJarEntry(zipEntry.getName()), super.getInputStream(zipEntry), this.jv);
    }

    private JarEntry getManEntry() {
        if (this.manEntry == null) {
            String[] stringArray;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (stringArray = this.getMetaInfEntryNames()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!MANIFEST_NAME.equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry(stringArray[i]);
                    break;
                }
            }
        }
        return this.manEntry;
    }

    boolean hasClassPathAttribute() throws IOException {
        JarEntry jarEntry;
        if (this.computedHasClassPathAttribute) {
            return this.hasClassPathAttribute;
        }
        this.hasClassPathAttribute = false;
        if (!this.isKnownToNotHaveClassPathAttribute() && (jarEntry = this.getManEntry()) != null) {
            char c;
            int n;
            byte[] byArray = this.getBytes(jarEntry);
            int n2 = byArray.length - src.length;
            block0: for (int i = 0; i <= n2; i += Math.max(n + 1 - lastOcc[c & 0x7F], optoSft[n])) {
                for (n = 9; n >= 0; --n) {
                    c = (char)byArray[i + n];
                    char c2 = c = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : c;
                    if (c == src[n]) continue;
                    continue block0;
                }
                this.hasClassPathAttribute = true;
                break;
            }
        }
        this.computedHasClassPathAttribute = true;
        return this.hasClassPathAttribute;
    }

    private boolean isKnownToNotHaveClassPathAttribute() {
        String string;
        Object object;
        if (javaHome == null) {
            javaHome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        }
        if (jarNames == null) {
            object = new String[10];
            string = File.separator;
            int n = 0;
            object[n++] = string + "rt.jar";
            object[n++] = string + "sunrsasign.jar";
            object[n++] = string + "jsse.jar";
            object[n++] = string + "jce.jar";
            object[n++] = string + "charsets.jar";
            object[n++] = string + "dnsns.jar";
            object[n++] = string + "ldapsec.jar";
            object[n++] = string + "localedata.jar";
            object[n++] = string + "sunjce_provider.jar";
            object[n++] = string + "sunpkcs11.jar";
            jarNames = object;
        }
        if (((String)(object = this.getName())).startsWith(string = javaHome)) {
            String[] stringArray = jarNames;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!((String)object).endsWith(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void ensureInitialization() {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.jv != null && !this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
        }
    }

    JarEntry newEntry(ZipEntry zipEntry) {
        return new JarFileEntry(zipEntry);
    }

    Enumeration<String> entryNames(CodeSource[] codeSourceArray) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entryNames(this, codeSourceArray);
        }
        boolean bl = false;
        for (int i = 0; i < codeSourceArray.length; ++i) {
            if (codeSourceArray[i].getCodeSigners() != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            return this.unsignedEntryNames();
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Enumeration<JarEntry> entries2() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entries2(this, super.entries());
        }
        Enumeration<? extends ZipEntry> enumeration = super.entries();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    CodeSource[] getCodeSources(URL uRL) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getCodeSources(this, uRL);
        }
        Enumeration<String> enumeration = this.unsignedEntryNames();
        if (enumeration.hasMoreElements()) {
            return new CodeSource[]{JarVerifier.getUnsignedCS(uRL)};
        }
        return null;
    }

    private Enumeration<String> unsignedEntryNames() {
        Enumeration<JarEntry> enumeration = this.entries();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    CodeSource getCodeSource(URL uRL, String string) {
        this.ensureInitialization();
        if (this.jv != null) {
            if (this.jv.eagerValidation) {
                CodeSource codeSource = null;
                JarEntry jarEntry = this.getJarEntry(string);
                codeSource = jarEntry != null ? this.jv.getCodeSource(uRL, this, jarEntry) : this.jv.getCodeSource(uRL, string);
                return codeSource;
            }
            return this.jv.getCodeSource(uRL, string);
        }
        return JarVerifier.getUnsignedCS(uRL);
    }

    void setEagerValidation(boolean bl) {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.jv != null) {
            this.jv.setEagerValidation(bl);
        }
    }

    List getManifestDigests() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getManifestDigests();
        }
        return new ArrayList();
    }

    static {
        SharedSecrets.setJavaUtilJarAccess(new JavaUtilJarAccessImpl());
        src = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        lastOcc = new int[128];
        optoSft = new int[10];
        JarFile.lastOcc[99] = 1;
        JarFile.lastOcc[108] = 2;
        JarFile.lastOcc[115] = 5;
        JarFile.lastOcc[45] = 6;
        JarFile.lastOcc[112] = 7;
        JarFile.lastOcc[97] = 8;
        JarFile.lastOcc[116] = 9;
        JarFile.lastOcc[104] = 10;
        for (int i = 0; i < 9; ++i) {
            JarFile.optoSft[i] = 10;
        }
        JarFile.optoSft[9] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest manifest = JarFile.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.certs == null && JarFile.this.jv != null) {
                this.certs = JarFile.this.jv.getCerts(JarFile.this, this);
            }
            return this.certs == null ? null : (Certificate[])this.certs.clone();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (this.signers == null && JarFile.this.jv != null) {
                this.signers = JarFile.this.jv.getCodeSigners(JarFile.this, this);
            }
            return this.signers == null ? null : (CodeSigner[])this.signers.clone();
        }
    }
}

