/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.List;
import sun.invoke.util.ValueConversions;

public abstract class MethodHandle {
    private byte vmentry;
    Object vmtarget;
    static final int INT_FIELD = 0;
    static final long LONG_FIELD = 0L;
    private MethodType type;

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType methodType) {
        methodType.getClass();
        this.type = methodType;
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    public Object invokeWithArguments(Object ... objectArray) throws Throwable {
        int n = objectArray == null ? 0 : objectArray.length;
        MethodType methodType = this.type();
        if (methodType.parameterCount() != n || this.isVarargsCollector()) {
            return this.asType(MethodType.genericMethodType(n)).invokeWithArguments(objectArray);
        }
        MethodHandle methodHandle = methodType.invokers().varargsInvoker();
        return methodHandle.invokeExact(this, objectArray);
    }

    public Object invokeWithArguments(List<?> list) throws Throwable {
        return this.invokeWithArguments(list.toArray());
    }

    public MethodHandle asType(MethodType methodType) {
        if (!this.type.isConvertibleTo(methodType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + methodType);
        }
        return MethodHandleImpl.convertArguments((MethodHandle)this, (MethodType)methodType, (int)1);
    }

    public MethodHandle asSpreader(Class<?> clazz, int n) {
        this.asSpreaderChecks(clazz, n);
        return MethodHandleImpl.spreadArguments((MethodHandle)this, clazz, (int)n);
    }

    private void asSpreaderChecks(Class<?> clazz, int n) {
        this.spreadArrayChecks(clazz, n);
        int n2 = this.type().parameterCount();
        if (n2 < n || n < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        if (clazz != Object[].class && n != 0) {
            boolean bl = false;
            Class<?> clazz2 = clazz.getComponentType();
            for (int i = n2 - n; i < n2; ++i) {
                if (MethodType.canConvert(clazz2, this.type().parameterType(i))) continue;
                bl = true;
                break;
            }
            if (bl) {
                ArrayList arrayList = new ArrayList(this.type().parameterList());
                for (int i = n2 - n; i < n2; ++i) {
                    arrayList.set(i, clazz2);
                }
                this.asType(MethodType.methodType(this.type().returnType(), arrayList));
            }
        }
    }

    private void spreadArrayChecks(Class<?> clazz, int n) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", clazz);
        }
        if ((n & 0x7F) != n) {
            if ((n & 0xFF) != n) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", n);
            }
            assert (n >= 128);
            if (clazz2 == Long.TYPE || clazz2 == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", n);
            }
        }
    }

    public MethodHandle asCollector(Class<?> clazz, int n) {
        this.asCollectorChecks(clazz, n);
        MethodHandle methodHandle = ValueConversions.varargsArray(clazz, (int)n);
        return MethodHandleImpl.collectArguments((MethodHandle)this, (int)(this.type.parameterCount() - 1), (MethodHandle)methodHandle);
    }

    private boolean asCollectorChecks(Class<?> clazz, int n) {
        this.spreadArrayChecks(clazz, n);
        int n2 = this.type().parameterCount();
        if (n2 != 0) {
            Class<?> clazz2 = this.type().parameterType(n2 - 1);
            if (clazz2 == clazz) {
                return true;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, clazz);
    }

    public MethodHandle asVarargsCollector(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        boolean bl = this.asCollectorChecks(clazz, 0);
        if (this.isVarargsCollector() && bl) {
            return this;
        }
        return AdapterMethodHandle.makeVarargsCollector(this, clazz);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object object) {
        Class<?> clazz;
        if (this.type().parameterCount() == 0 || (clazz = this.type().parameterType(0)).isPrimitive()) {
            throw MethodHandleStatics.newIllegalArgumentException("no leading reference parameter", object);
        }
        MethodHandle methodHandle = MethodHandleImpl.bindReceiver((MethodHandle)this, (Object)(object = MethodHandles.checkValue(clazz, (Object)object)));
        if (methodHandle != null) {
            return methodHandle;
        }
        return MethodHandleImpl.bindArgument((MethodHandle)this, (int)0, (Object)object);
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return this.debugString();
        }
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return MethodHandleStatics.getNameString((MethodHandle)this);
    }

    static {
        MethodHandleImpl.initStatics();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

