/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.invoke.util.BytecodeDescriptor;

final class MemberName
implements Member,
Cloneable {
    private Class<?> clazz;
    private String name;
    private Object type;
    private int flags;
    private Object vmtarget;
    private int vmindex = -99;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    static final String CONSTRUCTOR_NAME = "<init>";
    static final int RECOGNIZED_MODIFIERS = 65535;
    static final int IS_METHOD = 65536;
    static final int IS_CONSTRUCTOR = 131072;
    static final int IS_FIELD = 262144;
    static final int IS_TYPE = 524288;
    static final int IS_CALLER_SENSITIVE = 0x100000;
    static final int SEARCH_SUPERCLASSES = 0x100000;
    static final int SEARCH_INTERFACES = 0x200000;
    static final int ALL_ACCESS = 7;
    static final int ALL_KINDS = 983040;
    static final int IS_INVOCABLE = 196608;
    static final int IS_FIELD_OR_METHOD = 327680;
    static final int SEARCH_ALL_SUPERS = 0x300000;

    @Override
    public Class<?> getDeclaringClass() {
        if (this.clazz == null && this.isResolved()) {
            this.expandFromVM();
        }
        return this.clazz;
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.expandFromVM();
            if (this.name == null) {
                return null;
            }
        }
        return this.name;
    }

    public MethodType getMethodType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (!this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not invocable, no method type");
        }
        if (this.type instanceof MethodType) {
            return (MethodType)this.type;
        }
        if (this.type instanceof String) {
            String string = (String)this.type;
            MethodType methodType = MethodType.fromMethodDescriptorString(string, this.getClassLoader());
            this.type = methodType;
            return methodType;
        }
        if (this.type instanceof Object[]) {
            Object[] objectArray = (Object[])this.type;
            Class[] classArray = (Class[])objectArray[1];
            Class clazz = (Class)objectArray[0];
            MethodType methodType = MethodType.methodType(clazz, classArray);
            this.type = methodType;
            return methodType;
        }
        throw new InternalError("bad method type " + this.type);
    }

    public MethodType getInvocationType() {
        MethodType methodType = this.getMethodType();
        if (!this.isStatic()) {
            methodType = methodType.insertParameterTypes(0, this.clazz);
        }
        return methodType;
    }

    public Class<?>[] getParameterTypes() {
        return this.getMethodType().parameterArray();
    }

    public Class<?> getReturnType() {
        return this.getMethodType().returnType();
    }

    public Class<?> getFieldType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not a field or nested class, no simple type");
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof String) {
            Class<?> clazz;
            String string = (String)this.type;
            MethodType methodType = MethodType.fromMethodDescriptorString("()" + string, this.getClassLoader());
            this.type = clazz = methodType.returnType();
            return clazz;
        }
        throw new InternalError("bad field type " + this.type);
    }

    public Object getType() {
        return this.isInvocable() ? this.getMethodType() : this.getFieldType();
    }

    public String getSignature() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.type instanceof String) {
            return (String)this.type;
        }
        if (this.isInvocable()) {
            return BytecodeDescriptor.unparse((MethodType)this.getMethodType());
        }
        return BytecodeDescriptor.unparse(this.getFieldType());
    }

    @Override
    public int getModifiers() {
        return this.flags & 0xFFFF;
    }

    private void setFlags(int n) {
        this.flags = n;
        assert (this.testAnyFlags(983040));
    }

    private boolean testFlags(int n, int n2) {
        return (this.flags & n) == n2;
    }

    private boolean testAllFlags(int n) {
        return this.testFlags(n, n);
    }

    private boolean testAnyFlags(int n) {
        return !this.testFlags(n, 0);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.flags);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.flags);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.flags);
    }

    public boolean isBridge() {
        return this.testAllFlags(65600);
    }

    public boolean isVarargs() {
        return this.testAllFlags(128) && this.isInvocable();
    }

    @Override
    public boolean isSynthetic() {
        return this.testAllFlags(4096);
    }

    public boolean isInvocable() {
        return this.testAnyFlags(196608);
    }

    public boolean isFieldOrMethod() {
        return this.testAnyFlags(327680);
    }

    public boolean isMethod() {
        return this.testAllFlags(65536);
    }

    public boolean isConstructor() {
        return this.testAllFlags(131072);
    }

    public boolean isField() {
        return this.testAllFlags(262144);
    }

    public boolean isType() {
        return this.testAllFlags(524288);
    }

    public boolean isPackage() {
        return !this.testAnyFlags(7);
    }

    public boolean isCallerSensitive() {
        return this.testAllFlags(0x100000);
    }

    private void init(Class<?> clazz, String string, Object object, int n) {
        this.clazz = clazz;
        this.name = string;
        this.type = object;
        this.setFlags(n);
        assert (!this.isResolved());
    }

    private void expandFromVM() {
        if (!this.isResolved()) {
            return;
        }
        if (this.type instanceof Object[]) {
            this.type = null;
        }
        MethodHandleNatives.expand(this);
    }

    private static int flagsMods(int n, int n2) {
        assert ((n & 0xFFFF) == 0);
        assert ((n2 & 0xFFFF0000) == 0);
        return n | n2;
    }

    public MemberName(Method method) {
        Object[] objectArray = new Object[]{method.getReturnType(), method.getParameterTypes()};
        this.init(method.getDeclaringClass(), method.getName(), objectArray, MemberName.flagsMods(65536, method.getModifiers()));
        MethodHandleNatives.init(this, method);
        assert (this.isResolved());
    }

    public MemberName(Constructor constructor) {
        Object[] objectArray = new Object[]{Void.TYPE, constructor.getParameterTypes()};
        this.init(constructor.getDeclaringClass(), CONSTRUCTOR_NAME, objectArray, MemberName.flagsMods(131072, constructor.getModifiers()));
        MethodHandleNatives.init(this, constructor);
        assert (this.isResolved());
    }

    public MemberName(Field field) {
        this.init(field.getDeclaringClass(), field.getName(), field.getType(), MemberName.flagsMods(262144, field.getModifiers()));
        MethodHandleNatives.init(this, field);
        assert (this.isResolved());
    }

    public MemberName(Class<?> clazz) {
        this.init(clazz.getDeclaringClass(), clazz.getSimpleName(), clazz, MemberName.flagsMods(524288, clazz.getModifiers()));
        this.vmindex = 0;
        assert (this.isResolved());
    }

    MemberName() {
    }

    protected MemberName clone() {
        try {
            return (MemberName)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public MemberName(Class<?> clazz, String string, Class<?> clazz2, int n) {
        this.init(clazz, string, clazz2, 0x40000 | n & 0xFFFF);
    }

    public MemberName(Class<?> clazz, String string, Class<?> clazz2) {
        this(clazz, string, clazz2, 0);
    }

    public MemberName(Class<?> clazz, String string, MethodType methodType, int n) {
        int n2 = string.equals(CONSTRUCTOR_NAME) ? 131072 : 65536;
        this.init(clazz, string, methodType, n2 | n & 0xFFFF);
    }

    public MemberName(Class<?> clazz, String string, MethodType methodType) {
        this(clazz, string, methodType, 0);
    }

    public boolean isResolved() {
        return this.vmindex != -99;
    }

    public boolean hasReceiverTypeDispatch() {
        return this.isMethod() && this.getVMIndex() >= 0;
    }

    public String toString() {
        String string;
        if (this.isType()) {
            return this.type.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getDeclaringClass() != null) {
            stringBuilder.append(MemberName.getName(this.clazz));
            stringBuilder.append('.');
        }
        stringBuilder.append((string = this.getName()) == null ? "*" : string);
        Object object = this.getType();
        if (!this.isInvocable()) {
            stringBuilder.append('/');
            stringBuilder.append(object == null ? "*" : MemberName.getName(object));
        } else {
            stringBuilder.append(object == null ? "(*)*" : MemberName.getName(object));
        }
        return stringBuilder.toString();
    }

    private static String getName(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    int getVMIndex() {
        if (!this.isResolved()) {
            throw MethodHandleStatics.newIllegalStateException("not resolved", this);
        }
        return this.vmindex;
    }

    public IllegalAccessException makeAccessException(String string, Object object) {
        string = string + ": " + this.toString();
        if (object != null) {
            string = string + ", from " + object;
        }
        return new IllegalAccessException(string);
    }

    private String message() {
        if (this.isResolved()) {
            return "no access";
        }
        if (this.isConstructor()) {
            return "no such constructor";
        }
        if (this.isMethod()) {
            return "no such method";
        }
        return "no such field";
    }

    public ReflectiveOperationException makeAccessException() {
        String string = this.message() + ": " + this.toString();
        if (this.isResolved()) {
            return new IllegalAccessException(string);
        }
        if (this.isConstructor()) {
            return new NoSuchMethodException(string);
        }
        if (this.isMethod()) {
            return new NoSuchMethodException(string);
        }
        return new NoSuchFieldException(string);
    }

    static Factory getFactory() {
        return Factory.INSTANCE;
    }

    static /* synthetic */ String access$000(MemberName memberName) {
        return memberName.name;
    }

    static /* synthetic */ Object access$100(MemberName memberName) {
        return memberName.type;
    }

    static /* synthetic */ String access$002(MemberName memberName, String string) {
        memberName.name = string;
        return memberName.name;
    }

    static /* synthetic */ Object access$102(MemberName memberName, Object object) {
        memberName.type = object;
        return memberName.type;
    }

    static /* synthetic */ int access$200(MemberName memberName) {
        return memberName.flags;
    }

    static class Factory {
        static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        private MemberName resolve(byte refKind, MemberName ref, Class<?> lookupClass, int allowedModes, boolean speculativeResolve) {
            MemberName m = ref.clone();
            assert (refKind == m.getReferenceKind());
            try {
                m = MethodHandleNatives.resolve((MemberName)m, lookupClass, (int)allowedModes, (boolean)speculativeResolve);
                if (m == null && speculativeResolve) {
                    return null;
                }
                m.checkForTypeAlias(m.getDeclaringClass());
                m.resolution = null;
            }
            catch (ClassNotFoundException | LinkageError ex) {
                assert (!m.isResolved());
                m.resolution = ex;
                return m;
            }
            assert (m.referenceKindIsConsistent());
            m.initResolved(true);
            assert (m.vminfoIsConsistent());
            return m;
        }

        public <NoSuchMemberException extends ReflectiveOperationException> MemberName resolveOrFail(byte refKind, MemberName m, Class<?> lookupClass, int allowedModes, Class<NoSuchMemberException> nsmClass) throws IllegalAccessException, NoSuchMemberException {
            assert (lookupClass != null || allowedModes == -1);
            MemberName result = this.resolve(refKind, m, lookupClass, allowedModes, false);
            if (result.isResolved()) {
                return result;
            }
            ReflectiveOperationException ex = result.makeAccessException();
            if (ex instanceof IllegalAccessException) {
                throw (IllegalAccessException)ex;
            }
            throw (ReflectiveOperationException)nsmClass.cast(ex);
        }

        public MemberName resolveOrNull(byte refKind, MemberName m, Class<?> lookupClass, int allowedModes) {
            assert (lookupClass != null || allowedModes == -1);
            MemberName result = this.resolve(refKind, m, lookupClass, allowedModes, true);
            if (result != null && result.isResolved()) {
                return result;
            }
            return null;
        }
    }
}

