/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventFilter;
import java.awt.Window;
import sun.awt.AppContext;
import sun.awt.ModalExclude;

abstract class ModalEventFilter
implements EventFilter {
    protected Dialog modalDialog;
    protected boolean disabled;

    protected ModalEventFilter(Dialog dialog) {
        this.modalDialog = dialog;
        this.disabled = false;
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    @Override
    public EventFilter.FilterAction acceptEvent(AWTEvent aWTEvent) {
        Object object;
        if (this.disabled || !this.modalDialog.isVisible()) {
            return EventFilter.FilterAction.ACCEPT;
        }
        int n = aWTEvent.getID();
        if ((n >= 500 && n <= 507 || n >= 1001 && n <= 1001 || n == 201) && !((object = aWTEvent.getSource()) instanceof ModalExclude) && object instanceof Component) {
            Component component;
            for (component = (Component)object; component != null && !(component instanceof Window); component = component.getParent_NoClientCode()) {
            }
            if (component != null) {
                return this.acceptWindow((Window)component);
            }
        }
        return EventFilter.FilterAction.ACCEPT;
    }

    protected abstract EventFilter.FilterAction acceptWindow(Window var1);

    void disable() {
        this.disabled = true;
    }

    int compareTo(ModalEventFilter modalEventFilter) {
        Dialog dialog;
        Container container;
        Dialog dialog2 = modalEventFilter.getModalDialog();
        for (container = this.modalDialog; container != null; container = container.getParent_NoClientCode()) {
            if (container != dialog2) continue;
            return 1;
        }
        for (container = dialog2; container != null; container = container.getParent_NoClientCode()) {
            if (container != this.modalDialog) continue;
            return -1;
        }
        for (dialog = this.modalDialog.getModalBlocker(); dialog != null; dialog = dialog.getModalBlocker()) {
            if (dialog != dialog2) continue;
            return -1;
        }
        for (dialog = dialog2.getModalBlocker(); dialog != null; dialog = dialog.getModalBlocker()) {
            if (dialog != this.modalDialog) continue;
            return 1;
        }
        return this.modalDialog.getModalityType().compareTo(dialog2.getModalityType());
    }

    static ModalEventFilter createFilterForDialog(Dialog dialog) {
        switch (dialog.getModalityType()) {
            case DOCUMENT_MODAL: {
                return new DocumentModalEventFilter(dialog);
            }
            case APPLICATION_MODAL: {
                return new ApplicationModalEventFilter(dialog);
            }
            case TOOLKIT_MODAL: {
                return new ToolkitModalEventFilter(dialog);
            }
        }
        return null;
    }

    private static class ApplicationModalEventFilter
    extends ModalEventFilter {
        private AppContext appContext;

        ApplicationModalEventFilter(Dialog modalDialog) {
            super(modalDialog);
            this.appContext = modalDialog.appContext;
        }

        @Override
        protected EventFilter.FilterAction acceptWindow(Window w) {
            if (w.isModalExcluded(Dialog.ModalExclusionType.APPLICATION_EXCLUDE)) {
                return EventFilter.FilterAction.ACCEPT;
            }
            if (w.appContext == this.appContext) {
                while (w != null) {
                    if (w == this.modalDialog) {
                        return EventFilter.FilterAction.ACCEPT_IMMEDIATELY;
                    }
                    w = w.getOwner();
                }
                return EventFilter.FilterAction.REJECT;
            }
            return EventFilter.FilterAction.ACCEPT;
        }
    }

    private static class DocumentModalEventFilter
    extends ModalEventFilter {
        private Window documentRoot;

        DocumentModalEventFilter(Dialog modalDialog) {
            super(modalDialog);
            this.documentRoot = modalDialog.getDocumentRoot();
        }

        @Override
        protected EventFilter.FilterAction acceptWindow(Window w) {
            if (w.isModalExcluded(Dialog.ModalExclusionType.APPLICATION_EXCLUDE)) {
                for (Window w1 = this.modalDialog.getOwner(); w1 != null; w1 = w1.getOwner()) {
                    if (w1 != w) continue;
                    return EventFilter.FilterAction.REJECT;
                }
                return EventFilter.FilterAction.ACCEPT;
            }
            while (w != null) {
                if (w == this.modalDialog) {
                    return EventFilter.FilterAction.ACCEPT_IMMEDIATELY;
                }
                if (w == this.documentRoot) {
                    return EventFilter.FilterAction.REJECT;
                }
                w = w.getOwner();
            }
            return EventFilter.FilterAction.ACCEPT;
        }
    }

    private static class ToolkitModalEventFilter
    extends ModalEventFilter {
        private AppContext appContext;

        ToolkitModalEventFilter(Dialog modalDialog) {
            super(modalDialog);
            this.appContext = modalDialog.appContext;
        }

        @Override
        protected EventFilter.FilterAction acceptWindow(Window w) {
            if (w.isModalExcluded(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE)) {
                return EventFilter.FilterAction.ACCEPT;
            }
            if (w.appContext != this.appContext) {
                return EventFilter.FilterAction.REJECT;
            }
            while (w != null) {
                if (w == this.modalDialog) {
                    return EventFilter.FilterAction.ACCEPT_IMMEDIATELY;
                }
                w = w.getOwner();
            }
            return EventFilter.FilterAction.REJECT;
        }
    }
}

