/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tauth;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.tencent.b.a.g;
import com.tencent.connect.a.a;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.BaseApi;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.LbsAgent;
import com.tencent.tauth.UiError;
import com.tencent.utils.HttpUtils;
import com.tencent.utils.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationApi
extends BaseApi
implements LbsAgent.OnGetLocationListener {
    private static final String CGI_SEARCH_NEARBY = "http://fusion.qq.com/cgi-bin/qzapps/mapp_lbs_getnear.cgi";
    private static final String CGI_DELETE_LOCATION = "http://fusion.qq.com/cgi-bin/qzapps/mapp_lbs_delete.cgi";
    private static final int MSG_GET_LOCATION_TIMEOUT = 101;
    private static final int MSG_VERIFY_SOSOCODE_SUCCESS = 103;
    private static final int MSG_VERIFY_SOSOCODE_FAILED = 104;
    private static final String ACTION_SEARCH = "search_nearby";
    private static final String ACTION_DELETE = "delete_location";
    private static final String EVENT_ID_SEARCH = "id_search_nearby";
    private static final String EVENT_ID_DELETE = "id_delete_location";
    private static final int PAGE_DEFAULT = 1;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private Handler mMainHandler;
    private LbsAgent mLbsAgent;
    private Bundle mParams;
    private IUiListener mSearchListener;

    public LocationApi(Context context, QQToken qQToken) {
        super(context, qQToken);
        this.init();
    }

    public LocationApi(Context context, QQAuth qQAuth, QQToken qQToken) {
        super(context, qQAuth, qQToken);
        this.init();
    }

    private void init() {
        this.mLbsAgent = new LbsAgent();
        this.mHandlerThread = new HandlerThread("get_location");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mMainHandler = new Handler(this.mContext.getMainLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 103: {
                        g.b("openSDK_LOG", "location: verify sosocode success.");
                        LocationApi.this.mLbsAgent.requestLocationUpdate(LocationApi.this.mContext, LocationApi.this);
                        LocationApi.this.mMainHandler.sendEmptyMessageDelayed(101, 10000L);
                        break;
                    }
                    case 104: {
                        g.b("openSDK_LOG", "location: verify sosocode failed.");
                        LocationApi.this.locationFailed(-14, "\u5b9a\u4f4d\u5931\u8d25\uff0c\u9a8c\u8bc1\u5b9a\u4f4d\u7801\u9519\u8bef\uff01");
                        break;
                    }
                    case 101: {
                        g.b("openSDK_LOG", "location: get location timeout.");
                        LocationApi.this.locationFailed(-13, "\u5b9a\u4f4d\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u68c0\u67e5\u7f51\u7edc\u72b6\u51b5\uff01");
                        break;
                    }
                }
                super.handleMessage(message);
            }
        };
    }

    public void searchNearby(Activity activity, Bundle bundle, IUiListener iUiListener) {
        if (!this.checkNetworkAvailable()) {
            if (iUiListener != null) {
                iUiListener.onComplete(this.unavailableNetworkJson());
            }
            return;
        }
        this.mParams = bundle;
        this.mSearchListener = iUiListener;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (LocationApi.this.mLbsAgent.verifyRegCode()) {
                    Message.obtain((Handler)LocationApi.this.mMainHandler, (int)103).sendToTarget();
                } else {
                    Message.obtain((Handler)LocationApi.this.mMainHandler, (int)104).sendToTarget();
                }
            }
        });
    }

    public void deleteLocation(Activity activity, Bundle bundle, IUiListener iUiListener) {
        if (!this.checkNetworkAvailable()) {
            if (iUiListener != null) {
                iUiListener.onComplete(this.unavailableNetworkJson());
            }
            return;
        }
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            bundle2.putAll(this.composeCGIParams());
        } else {
            bundle2 = this.composeCGIParams();
        }
        bundle2.putString("appid", this.mToken.getAppId());
        bundle2.putString("timestamp", String.valueOf(System.currentTimeMillis()));
        String string = "tencent&sdk&qazxc***14969%%";
        String string2 = "qzone3.4";
        String string3 = Util.encrypt(string + this.mToken.getAccessToken() + this.mToken.getAppId() + this.mToken.getOpenId() + string2);
        bundle2.putString("encrytoken", string3);
        g.b("openSDK_LOG", "location: delete params: " + bundle2);
        TaskRequestListener taskRequestListener = new TaskRequestListener(iUiListener);
        HttpUtils.requestAsync(this.mToken, this.mContext, CGI_DELETE_LOCATION, bundle2, "GET", taskRequestListener);
        this.report(ACTION_DELETE, "success");
    }

    private void doSearchNearby(Location location) {
        Bundle bundle = null;
        g.b("openSDK_LOG", "location: search mParams: " + this.mParams);
        if (this.mParams != null) {
            bundle = new Bundle(this.mParams);
            bundle.putAll(this.composeCGIParams());
        } else {
            bundle = this.composeCGIParams();
        }
        String string = String.valueOf(location.getLatitude());
        String string2 = String.valueOf(location.getLongitude());
        bundle.putString("appid", this.mToken.getAppId());
        if (!bundle.containsKey("latitude")) {
            bundle.putString("latitude", string);
        }
        if (!bundle.containsKey("longitude")) {
            bundle.putString("longitude", string2);
        }
        if (!bundle.containsKey("page")) {
            bundle.putString("page", String.valueOf(1));
        }
        String string3 = "tencent&sdk&qazxc***14969%%";
        String string4 = "qzone3.4";
        String string5 = Util.encrypt(string3 + this.mToken.getAccessToken() + this.mToken.getAppId() + this.mToken.getOpenId() + string4);
        bundle.putString("encrytoken", string5);
        g.b("openSDK_LOG", "location: search params: " + bundle);
        TaskRequestListener taskRequestListener = new TaskRequestListener(this.mSearchListener);
        HttpUtils.requestAsync(this.mToken, this.mContext, CGI_SEARCH_NEARBY, bundle, "GET", taskRequestListener);
    }

    private void locationFailed(int n2, String string) {
        this.mLbsAgent.removeUpdate();
        if (this.mSearchListener == null) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("ret", n2);
            jSONObject.put("errMsg", (Object)string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.mSearchListener.onComplete(jSONObject);
    }

    private void locationSuccess() {
        this.mLbsAgent.removeUpdate();
    }

    private boolean checkNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isAvailable();
        }
        return false;
    }

    private JSONObject unavailableNetworkJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("ret", -9);
            jSONObject.put("errMsg", (Object)"\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5!");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    private void report(final String string, final String ... stringArray) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (stringArray == null || stringArray.length == 0) {
                    return;
                }
                String string2 = LocationApi.ACTION_SEARCH.equals(string) ? LocationApi.EVENT_ID_SEARCH : LocationApi.EVENT_ID_DELETE;
                a.a(LocationApi.this.mContext, LocationApi.this.mToken, string2, stringArray);
            }
        });
    }

    @Override
    public void onLocationUpdate(Location location) {
        this.doSearchNearby(location);
        this.locationSuccess();
        this.mMainHandler.removeMessages(101);
    }

    private abstract class BaseRequestListener
    implements IRequestListener {
        private BaseRequestListener() {
        }

        protected abstract void handleException(Exception var1);

        @Override
        public void onIOException(IOException iOException) {
            this.handleException(iOException);
        }

        @Override
        public void onMalformedURLException(MalformedURLException malformedURLException) {
            this.handleException(malformedURLException);
        }

        @Override
        public void onJSONException(JSONException jSONException) {
            this.handleException((Exception)((Object)jSONException));
        }

        @Override
        public void onConnectTimeoutException(ConnectTimeoutException connectTimeoutException) {
            this.handleException((Exception)((Object)connectTimeoutException));
        }

        @Override
        public void onSocketTimeoutException(SocketTimeoutException socketTimeoutException) {
            this.handleException(socketTimeoutException);
        }

        @Override
        public void onNetworkUnavailableException(HttpUtils.NetworkUnavailableException networkUnavailableException) {
            this.handleException(networkUnavailableException);
        }

        @Override
        public void onHttpStatusException(HttpUtils.HttpStatusException httpStatusException) {
            this.handleException(httpStatusException);
        }

        @Override
        public void onUnknowException(Exception exception) {
            this.handleException(exception);
        }
    }

    private class TaskRequestListener
    extends BaseRequestListener {
        private IUiListener lis;

        public TaskRequestListener(IUiListener iUiListener) {
            this.lis = iUiListener;
        }

        @Override
        public void onComplete(JSONObject jSONObject) {
            if (this.lis != null) {
                this.lis.onComplete(jSONObject);
            }
        }

        @Override
        protected void handleException(Exception exception) {
            if (this.lis != null) {
                this.lis.onError(new UiError(100, exception.getMessage(), null));
            }
        }
    }
}

