/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.connect.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.b.a.g;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.common.AssistActivity;
import com.tencent.connect.common.Constants;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;
import com.tencent.utils.HttpUtils;
import com.tencent.utils.OpenConfig;
import com.tencent.utils.SystemUtils;
import com.tencent.utils.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseApi {
    private static final String KEY_REQUEST_CODE = "key_request_code";
    protected static final String DEFAULT_PF = "openmobile_android";
    protected static final String PREFERENCE_PF = "pfStore";
    protected static final String ACTIVITY_ENCRY_TOKEN = "com.tencent.open.agent.EncryTokenActivity";
    protected static final String ACTIVITY_AGENT = "com.tencent.open.agent.AgentActivity";
    protected static final String ACTION_CHECK_TOKEN = "action_check_token";
    protected static final String PARAM_ENCRY_EOKEN = "encry_token";
    private static final int MSG_COMPLETE = 0;
    protected QQAuth mQQAuth;
    protected QQToken mToken;
    protected Context mContext;
    protected List<ApiTask> mTaskList = null;
    protected Intent mActivityIntent = null;
    protected static int sRequestCode = 1000;
    protected IUiListener mUiListener = null;
    public static String registerChannel = null;
    public static String installChannel = null;
    public static String businessId = null;
    public static boolean isOEM = false;
    protected static final String VERSION = "android";
    protected static final String PLATFORM = "desktop_m_qq";

    public BaseApi(Context context, QQAuth qQAuth, QQToken qQToken) {
        this.mContext = context;
        this.mQQAuth = qQAuth;
        this.mToken = qQToken;
        this.mTaskList = new ArrayList<ApiTask>();
    }

    public BaseApi(Context context, QQToken qQToken) {
        this(context, null, qQToken);
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        IUiListener iUiListener = null;
        for (ApiTask object : this.mTaskList) {
            if (object.mRequestCode != n2) continue;
            iUiListener = object.mListener;
            this.mTaskList.remove(object);
            break;
        }
        if (iUiListener == null) {
            return;
        }
        if (n3 == -1) {
            int n4 = intent.getIntExtra("key_error_code", 0);
            if (n4 == 0) {
                String string = intent.getStringExtra("key_response");
                if (string != null) {
                    try {
                        JSONObject string2 = Util.parseJson(string);
                        iUiListener.onComplete(string2);
                    }
                    catch (JSONException jSONException) {
                        iUiListener.onError(new UiError(-4, "\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u6709\u8bef!", string));
                        g.a("openSDK_LOG", "OpenUi, onActivityResult, json error", jSONException);
                    }
                } else {
                    g.b("openSDK_LOG", "OpenUi, onActivityResult, onComplete");
                    iUiListener.onComplete(new JSONObject());
                }
            } else {
                g.d("openSDK_LOG", "OpenUi, onActivityResult, onError = " + n4 + "");
                String string = intent.getStringExtra("key_error_msg");
                String string3 = intent.getStringExtra("key_error_detail");
                iUiListener.onError(new UiError(n4, string, string3));
            }
        } else {
            g.b("openSDK_LOG", "OpenUi, onActivityResult, Constants.ACTIVITY_CANCEL");
            iUiListener.onCancel();
        }
        g.a().b();
    }

    Intent getActivityIntent() {
        return this.mActivityIntent;
    }

    protected Bundle composeCGIParams() {
        Bundle bundle = new Bundle();
        bundle.putString("format", "json");
        bundle.putString("status_os", Build.VERSION.RELEASE);
        bundle.putString("status_machine", Build.MODEL);
        bundle.putString("status_version", Build.VERSION.SDK);
        bundle.putString("sdkv", "2.2.1");
        bundle.putString("sdkp", "a");
        if (this.mToken != null && this.mToken.isSessionValid()) {
            bundle.putString("access_token", this.mToken.getAccessToken());
            bundle.putString("oauth_consumer_key", this.mToken.getAppId());
            bundle.putString("openid", this.mToken.getOpenId());
        }
        bundle.putString("appid_for_getting_config", this.mToken.getAppId());
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREFERENCE_PF, 0);
        if (isOEM) {
            bundle.putString("pf", "desktop_m_qq-" + installChannel + "-" + VERSION + "-" + registerChannel + "-" + businessId);
        } else {
            String string = sharedPreferences.getString("pf", DEFAULT_PF);
            bundle.putString("pf", string);
        }
        return bundle;
    }

    protected Bundle composeActivityParams() {
        String string;
        Bundle bundle = new Bundle();
        bundle.putString("appid", this.mToken.getAppId());
        if (this.mToken.isSessionValid()) {
            bundle.putString("keystr", this.mToken.getAccessToken());
            bundle.putString("keytype", "0x80");
        }
        if ((string = this.mToken.getOpenId()) != null) {
            bundle.putString("hopenid", string);
        }
        bundle.putString("platform", "androidqz");
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(PREFERENCE_PF, 0);
        if (isOEM) {
            bundle.putString("pf", "desktop_m_qq-" + installChannel + "-" + VERSION + "-" + registerChannel + "-" + businessId);
        } else {
            String string2 = sharedPreferences.getString("pf", DEFAULT_PF);
            bundle.putString("pf", string2);
            bundle.putString("pf", DEFAULT_PF);
        }
        bundle.putString("sdkv", "2.2.1");
        bundle.putString("sdkp", "a");
        return bundle;
    }

    private Intent getAssitIntent() {
        Intent intent = new Intent(this.mContext, AssistActivity.class);
        return intent;
    }

    protected void startAssitActivity(Activity activity, IUiListener iUiListener) {
        AssistActivity.setApiObject(this);
        int n2 = sRequestCode++;
        this.mActivityIntent.putExtra(KEY_REQUEST_CODE, n2);
        this.mTaskList.add(new ApiTask(n2, iUiListener));
        activity.startActivity(this.getAssitIntent());
    }

    protected boolean hasActivityForIntent() {
        if (this.mActivityIntent != null) {
            return SystemUtils.isActivityExist(this.mContext, this.mActivityIntent);
        }
        return false;
    }

    protected Intent getTargetActivityIntent(String string) {
        Intent intent = new Intent();
        intent.setClassName(Constants.PACKAGE_QZONE, string);
        Intent intent2 = new Intent();
        intent2.setClassName(Constants.PACKAGE_QQ, string);
        String string2 = SystemUtils.getAppVersionName(this.mContext, Constants.PACKAGE_QZONE);
        if (string2 == null) {
            return SystemUtils.isActivityExist(this.mContext, intent2) ? intent2 : null;
        }
        OpenConfig openConfig = OpenConfig.getInstance(this.mContext, this.mToken.getAppId());
        String string3 = openConfig.getString("Common_SSO_QzoneVersion");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = "4.0";
        }
        if (SystemUtils.compareVersion(string2, "3.4") >= 0 && SystemUtils.compareVersion(string2, string3) < 0) {
            return SystemUtils.isActivityExist(this.mContext, intent) && SystemUtils.isAppSignatureValid(this.mContext, intent.getComponent().getPackageName(), Constants.SIGNATRUE_QZONE) ? intent : null;
        }
        if (SystemUtils.isActivityExist(this.mContext, intent2)) {
            return intent2;
        }
        return SystemUtils.isActivityExist(this.mContext, intent) && SystemUtils.isAppSignatureValid(this.mContext, intent.getComponent().getPackageName(), Constants.SIGNATRUE_QZONE) ? intent : null;
    }

    protected Intent getAgentIntent() {
        return this.getTargetActivityIntent(ACTIVITY_AGENT);
    }

    protected Intent getAgentIntentWithTarget(String string) {
        Intent intent = new Intent();
        Intent intent2 = this.getTargetActivityIntent(string);
        if (intent2 == null) {
            intent = null;
        } else if (intent2.getComponent() != null) {
            intent.setClassName(intent2.getComponent().getPackageName(), ACTIVITY_AGENT);
        } else {
            intent = null;
        }
        return intent;
    }

    public class TempRequestListener
    implements IRequestListener {
        private IUiListener mListener;
        private Handler mHandler;

        public TempRequestListener(IUiListener iUiListener) {
            this.mListener = iUiListener;
            this.mHandler = new Handler(BaseApi.this.mContext.getMainLooper()){

                public void handleMessage(Message message) {
                    if (message.what == 0) {
                        TempRequestListener.this.mListener.onComplete((JSONObject)message.obj);
                    } else {
                        TempRequestListener.this.mListener.onError(new UiError(message.what, (String)message.obj, null));
                    }
                }
            };
        }

        @Override
        public void onComplete(JSONObject jSONObject) {
            Message message = this.mHandler.obtainMessage();
            message.obj = jSONObject;
            message.what = 0;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onIOException(IOException iOException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = iOException.getMessage();
            message.what = -2;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onMalformedURLException(MalformedURLException malformedURLException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = malformedURLException.getMessage();
            message.what = -3;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onJSONException(JSONException jSONException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = jSONException.getMessage();
            message.what = -4;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onConnectTimeoutException(ConnectTimeoutException connectTimeoutException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = connectTimeoutException.getMessage();
            message.what = -7;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onSocketTimeoutException(SocketTimeoutException socketTimeoutException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = socketTimeoutException.getMessage();
            message.what = -8;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onNetworkUnavailableException(HttpUtils.NetworkUnavailableException networkUnavailableException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = networkUnavailableException.getMessage();
            message.what = -10;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onHttpStatusException(HttpUtils.HttpStatusException httpStatusException) {
            Message message = this.mHandler.obtainMessage();
            message.obj = httpStatusException.getMessage();
            message.what = -9;
            this.mHandler.sendMessage(message);
        }

        @Override
        public void onUnknowException(Exception exception) {
            Message message = this.mHandler.obtainMessage();
            message.obj = exception.getMessage();
            message.what = -6;
            this.mHandler.sendMessage(message);
        }
    }

    public class ApiTask {
        public int mRequestCode;
        public IUiListener mListener;

        public ApiTask(int n2, IUiListener iUiListener) {
            this.mRequestCode = n2;
            this.mListener = iUiListener;
        }
    }
}

