/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.NameRef;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static NameRef[] names = new NameRef[2];
    private static int namesCount;

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
        }
        FileNaming fileNaming = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            File file3 = (File)linkedList.get(i);
            if ("\\\\".equals(file3.getPath())) {
                ++i;
                continue;
            }
            FileType fileType = i == linkedList.size() - 1 ? FileType.unknown : FileType.directory;
            fileNaming = NamingFactory.registerInstanceOfFileNaming(fileNaming, file3, fileType);
        }
        return fileNaming;
    }

    public static synchronized int getSize() {
        return namesCount;
    }

    public static synchronized FileNaming fromFile(FileNaming fileNaming, File file, boolean bl) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, null, bl, FileType.unknown);
    }

    public static synchronized FileNaming checkCaseSensitivity(FileNaming fileNaming, File file) throws IOException {
        if (!fileNaming.getFile().getName().equals(file.getName())) {
            boolean bl;
            boolean bl2 = bl = !Utils.equals(new File(file, "a"), new File(file, "A"));
            if (!bl) {
                FileName fileName = (FileName)fileNaming;
                fileName.updateCase(file.getName());
            }
        }
        return fileNaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fileNaming, String string, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        LinkedHashSet<FileNaming> linkedHashSet = new LinkedHashSet<FileNaming>();
        FileNaming fileNaming2 = fileNaming.rename(string, iOHandler);
        boolean bl = fileNaming2 != fileNaming;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            linkedHashSet.add(fileNaming2);
            NamingFactory.renameChildren(fileNaming, linkedHashSet);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return bl ? linkedHashSet.toArray(new FileNaming[linkedHashSet.size()]) : null;
        }
    }

    private static void renameChildren(FileNaming fileNaming, Collection<FileNaming> collection) {
        assert (Thread.holdsLock(NamingFactory.class));
        HashSet hashSet = new HashSet(names.length);
        for (int i = 0; i < names.length; ++i) {
            block1: for (NameRef nameRef = names[i]; nameRef != null; nameRef = nameRef.next()) {
                FileNaming fileNaming2 = (FileNaming)nameRef.get();
                LinkedList<FileNaming> linkedList = new LinkedList<FileNaming>();
                FileNaming fileNaming3 = fileNaming2;
                while (true) {
                    if (fileNaming3 == null || hashSet.contains(fileNaming3)) {
                        hashSet.addAll(linkedList);
                        continue block1;
                    }
                    linkedList.addFirst(fileNaming3);
                    if (fileNaming.equals(fileNaming3) || collection.contains(fileNaming3)) {
                        collection.addAll(linkedList);
                        continue block1;
                    }
                    fileNaming3 = fileNaming3.getParent();
                }
            }
        }
    }

    public static Integer createID(File file) {
        return Utils.hashCode(file);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileType fileType) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, null, false, fileType);
    }

    private static void rehash(int n) {
        int n2;
        assert (Thread.holdsLock(NamingFactory.class));
        NameRef[] nameRefArray = new NameRef[n];
        for (n2 = 0; n2 < names.length; ++n2) {
            NameRef nameRef = names[n2];
            if (nameRef == null) continue;
            for (NameRef nameRef2 : names[n2].disconnectAll()) {
                FileNaming fileNaming = (FileNaming)nameRef2.get();
                if (fileNaming == null) continue;
                Integer n3 = NamingFactory.createID(fileNaming.getFile());
                int n4 = Math.abs(n3) % nameRefArray.length;
                NameRef nameRef3 = nameRefArray[n4];
                nameRefArray[n4] = nameRef2;
                if (nameRef3 == null) {
                    nameRef2.setIndex(n4);
                    continue;
                }
                nameRef2.setNext(nameRef3);
            }
        }
        for (n2 = 0; n2 < nameRefArray.length; ++n2) {
            assert (NamingFactory.checkIndex(nameRefArray, n2));
        }
        names = nameRefArray;
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileNaming fileNaming2, boolean bl, FileType fileType) {
        FileNaming fileNaming3;
        assert (Thread.holdsLock(NamingFactory.class));
        NamingFactory.cleanQueue();
        Integer n = NamingFactory.createID(file);
        int n2 = Math.abs(n) % names.length;
        NameRef nameRef = NamingFactory.getReference(names[n2], file);
        FileNaming fileNaming4 = nameRef != null ? (FileNaming)nameRef.get() : null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        if (bl) {
            if (fileNaming4 != null && (bl2 = Boolean.valueOf(fileNaming4.isDirectory())) != (bl3 = Boolean.valueOf(file.isDirectory()))) {
                fileNaming4 = null;
            }
            if (fileNaming4 != null) {
                try {
                    NamingFactory.checkCaseSensitivity(fileNaming4, file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Boolean bl4 = null;
        if (fileNaming4 != null && (bl4 = Boolean.valueOf(Utils.equals(fileNaming4.getFile(), file))).booleanValue()) {
            fileNaming3 = fileNaming4;
        } else {
            block18: {
                fileNaming3 = fileNaming2 == null ? NamingFactory.createFileNaming(file, n, fileNaming, fileType) : fileNaming2;
                NameRef nameRef2 = new NameRef(fileNaming3);
                NameRef nameRef3 = names[n2];
                NamingFactory.names[n2] = nameRef2;
                if (nameRef3 == null) {
                    nameRef2.setIndex(n2);
                } else {
                    nameRef2.setNext(nameRef3);
                }
                assert (NamingFactory.checkIndex(names, n2));
                if (nameRef != null) {
                    NameRef nameRef4 = nameRef2;
                    while (true) {
                        if (nameRef4.next() == nameRef) {
                            FileNaming fileNaming5 = (FileNaming)nameRef.get();
                            if (fileNaming5 instanceof FileName) {
                                ((FileName)fileNaming5).recordCleanup("cachedElement: " + fileNaming4 + " ref: " + fileNaming5 + " file: " + file + " filesEqual: " + bl4 + " cachedIsDirectory: " + bl2 + " fileIsDirectory: " + bl3);
                            }
                            nameRef.clear();
                            nameRef4.skip(nameRef);
                            break block18;
                        }
                        nameRef4 = nameRef4.next();
                    }
                }
                ++namesCount;
            }
            assert (NamingFactory.checkIndex(names, n2));
            if (namesCount * 4 > names.length * 3) {
                NamingFactory.rehash(names.length * 2);
            }
        }
        assert (fileNaming3 != null);
        return fileNaming3;
    }

    private static NameRef getReference(NameRef nameRef, File file) {
        while (nameRef != null) {
            FileNaming fileNaming = (FileNaming)nameRef.get();
            if (fileNaming != null && Utils.equals(fileNaming.getFile(), file)) {
                return nameRef;
            }
            nameRef = nameRef.next();
        }
        return null;
    }

    private static FileNaming createFileNaming(File file, Integer n, FileNaming fileNaming, FileType fileType) {
        FileName fileName = null;
        if (fileType.equals((Object)FileType.unknown)) {
            fileType = file.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (fileType) {
            case file: {
                fileName = new FileName(fileNaming, file, n);
                break;
            }
            case directory: {
                fileName = new FolderName(fileNaming, file, n);
            }
        }
        return fileName;
    }

    public static String dumpId(Integer n) {
        return NamingFactory.dump(n, null);
    }

    public static synchronized boolean isValid(FileNaming fileNaming) {
        int n = Math.abs(fileNaming.getId()) % names.length;
        for (NameRef nameRef = names[n]; nameRef != null; nameRef = nameRef.next()) {
            if (nameRef.get() != fileNaming) continue;
            return true;
        }
        return false;
    }

    static synchronized String dump(Integer n, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toHexString(n);
        stringBuilder.append("Showing references to ").append(string).append("\n");
        int n2 = 0;
        int n3 = Math.abs(n) % names.length;
        for (NameRef nameRef = names[n3]; nameRef != null; nameRef = nameRef.next()) {
            if (file != null && !file.equals(nameRef.getFile())) continue;
            ++n2;
            NamingFactory.dumpFileNaming(stringBuilder, nameRef.get());
        }
        stringBuilder.append("References: ").append(n2);
        return stringBuilder.toString();
    }

    private static void dumpFileNaming(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (object instanceof FolderName) {
            stringBuilder.append("FolderName: ");
        } else {
            stringBuilder.append("FileName: ");
        }
        stringBuilder.append(object).append("#").append(Integer.toHexString(object.hashCode())).append("@").append(Integer.toHexString(System.identityHashCode(object))).append("\n");
        if (object instanceof FileName) {
            ((FileName)object).dumpCreation(stringBuilder);
        }
    }

    private static void cleanQueue() {
        assert (Thread.holdsLock(NamingFactory.class));
        while (true) {
            NameRef nameRef;
            if ((nameRef = (NameRef)NameRef.QUEUE.poll()) == null) {
                return;
            }
            int n = nameRef.getIndex();
            if (n == -1) continue;
            if (names[n] != null) {
                NamingFactory.names[n] = names[n].remove(nameRef);
                --namesCount;
            }
            if (!$assertionsDisabled && !NamingFactory.checkIndex(names, n)) break;
        }
        throw new AssertionError();
    }

    private static boolean checkIndex(NameRef[] nameRefArray, int n) {
        if (nameRefArray[n] == null) {
            return true;
        }
        return n == nameRefArray[n].getIndex();
    }

    static enum FileType {
        file,
        directory,
        unknown;

    }
}

