/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.Bundle;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.LockForFile;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.MutualExclusionSupport;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.filebasedfs.utils.Utils;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class FileObj
extends BaseFileObj {
    static final long serialVersionUID = -1133540210876356809L;
    private static final MutualExclusionSupport<FileObj> MUT_EXCL_SUPPORT = new MutualExclusionSupport();
    private long lastModified = -1L;
    private boolean realLastModifiedCached;
    private static final Logger LOGGER = Logger.getLogger(FileObj.class.getName());

    FileObj(File file, FileNaming fileNaming) {
        super(file, fileNaming);
        this.setLastModified(System.currentTimeMillis(), null, false);
    }

    @Override
    protected boolean noFolderListeners() {
        FolderObj folderObj = this.getExistingParent();
        return folderObj == null ? true : folderObj.noFolderListeners();
    }

    public OutputStream getOutputStream(FileLock fileLock) throws IOException {
        ProvidedExtensions providedExtensions = this.getProvidedExtensions();
        File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            throw new IOException(file.getAbsolutePath());
        }
        return this.getOutputStream(fileLock, providedExtensions, this);
    }

    public OutputStream getOutputStream(FileLock fileLock, ProvidedExtensions providedExtensions, FileObject fileObject) throws IOException {
        if (!this.isValid()) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException("FileObject " + (Object)((Object)this) + " is not valid.");
            Exceptions.attachLocalizedMessage((Throwable)fileNotFoundException, (String)Bundle.EXC_INVALID_FILE((Object)this));
            throw fileNotFoundException;
        }
        final File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            throw new IOException(file.getAbsolutePath());
        }
        final MutualExclusionSupport.Closeable closeable = MUT_EXCL_SUPPORT.addResource(this, false);
        if (providedExtensions != null) {
            providedExtensions.beforeChange(fileObject);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file){

                @Override
                public void close() throws IOException {
                    if (!closeable.isClosed()) {
                        super.close();
                        LOGGER.log(Level.FINEST, "getOutputStream-close");
                        FileObj.this.setLastModified(file.lastModified(), file, false);
                        closeable.close();
                        FileObj.this.fireFileChangedEvent(false);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (closeable != null) {
                closeable.close();
            }
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!FileChangedManager.getInstance().exists(file)) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!FileChangedManager.getInstance().exists(file.getParentFile())) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            FSException.annotateException(fileNotFoundException2);
            throw fileNotFoundException2;
        }
        return fileOutputStream;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        FileInputStream fileInputStream;
        if (!this.isValid()) {
            throw new FileNotFoundException("FileObject " + (Object)((Object)this) + " is not valid.");
        }
        LOGGER.log(Level.FINEST, "FileObj.getInputStream_after_is_valid");
        File file = this.getFileName().getFile();
        if (!file.exists()) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException("Can't read " + file);
            FileObj.dumpFileInfo(file, fileNotFoundException);
            throw fileNotFoundException;
        }
        MutualExclusionSupport.Closeable closeable = null;
        try {
            MutualExclusionSupport.Closeable closeable2;
            if (Utilities.isWindows() ? this.getNameExt().toLowerCase().startsWith("ntuser.dat") : !file.isFile()) {
                return new ByteArrayInputStream(new byte[0]);
            }
            closeable = closeable2 = MUT_EXCL_SUPPORT.addResource(this, true);
            fileInputStream = new FileInputStream(file){

                @Override
                public void close() throws IOException {
                    super.close();
                    closeable2.close();
                }
            };
        }
        catch (IOException iOException) {
            if (closeable != null) {
                closeable.close();
            }
            FileNotFoundException fileNotFoundException = null;
            fileNotFoundException = !FileChangedManager.getInstance().exists(file) ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (!file.canRead() ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (file.getParentFile() == null ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (!FileChangedManager.getInstance().exists(file.getParentFile()) ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (new FileInfo(file).isUnixSpecialFile() ? (FileNotFoundException)new FileNotFoundException(iOException.toString()).initCause(iOException) : (FileNotFoundException)new FileNotFoundException(iOException.toString()).initCause(iOException)))));
            FSException.annotateException(fileNotFoundException);
            throw fileNotFoundException;
        }
        assert (fileInputStream != null);
        return fileInputStream;
    }

    @Override
    public boolean isReadOnly() {
        File file = this.getFileName().getFile();
        boolean bl = !Utilities.isWindows() && !file.isFile() ? true : super.isReadOnly();
        this.markReadOnly(bl);
        return bl;
    }

    @Override
    public boolean canWrite() {
        File file = this.getFileName().getFile();
        if (!Utilities.isWindows() && !file.isFile()) {
            return false;
        }
        return super.canWrite();
    }

    final void setLastModified(long l, File file, boolean bl) {
        if (this.getLastModified() != 0L) {
            if (this.getLastModified() != -1L && !this.realLastModifiedCached) {
                this.realLastModifiedCached = true;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                Exception exception = LOGGER.isLoggable(Level.FINEST) ? new Exception("StackTrace") : null;
                LOGGER.log(Level.FINER, "setLastModified: " + this.getLastModified() + " -> " + l + " (" + (Object)((Object)this) + ") on " + file, exception);
            }
            this.setLastModified(l, bl);
        }
    }

    public final FileObject createFolder(String string) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject createData(String string, String string2) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject[] getChildren() {
        return new FileObject[0];
    }

    public final FileObject getFileObject(String string, String string2) {
        return null;
    }

    @Override
    public boolean isValid() {
        boolean bl = this.getLastModified() != 0L;
        return bl && super.isValid();
    }

    @Override
    protected void setValid(boolean bl) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "setValid: " + bl + " (" + (Object)((Object)this) + ")", new Exception("Stack trace"));
        }
        if (bl) {
            assert (this.isValid()) : this.toString();
        } else {
            this.setLastModified(0L, true);
        }
    }

    public final boolean isFolder() {
        return false;
    }

    @Override
    public void refreshImpl(boolean bl, boolean bl2) {
        boolean bl3;
        long l = this.getLastModified();
        boolean bl4 = this.thinksReadOnly();
        boolean bl5 = this.realLastModifiedCached;
        File file = this.getFileName().getFile();
        this.setLastModified(file.lastModified(), file, !file.canWrite());
        boolean bl6 = bl5 ? l != this.getLastModified() : (bl3 = l < this.getLastModified());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "refreshImpl for {0} isReal: {1} isModified: {2} oldLastModified: {3} lastModified: {4}", new Object[]{this, bl5, bl3, l, this.getLastModified()});
        }
        if (bl2 && l != -1L && this.getLastModified() != -1L && this.getLastModified() != 0L && bl3 && !MUT_EXCL_SUPPORT.isBeingWritten(this)) {
            this.fireFileChangedEvent(bl);
        }
        if (bl2 && bl5 && bl4 != this.thinksReadOnly() && this.getLastModified() != 0L) {
            this.fireFileAttributeChangedEvent("DataEditorSupport.read-only.refresh", null, null);
        }
    }

    public final void refresh(boolean bl) {
        this.refresh(bl, true);
    }

    public final Enumeration<FileObject> getChildren(boolean bl) {
        return Enumerations.empty();
    }

    public final Enumeration<FileObject> getFolders(boolean bl) {
        return Enumerations.empty();
    }

    public final Enumeration<FileObject> getData(boolean bl) {
        return Enumerations.empty();
    }

    public final FileLock lock() throws IOException {
        File file = this.getFileName().getFile();
        if (!this.getProvidedExtensions().canWrite(file)) {
            FSException.io("EXC_CannotLock", file);
        }
        try {
            LockForFile lockForFile = LockForFile.tryLock(file);
            this.getProvidedExtensions().fileLocked(this);
            return lockForFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!FileChangedManager.getInstance().exists(file)) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canRead()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!FileChangedManager.getInstance().exists(file.getParentFile())) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            FSException.annotateException(fileNotFoundException2);
            throw fileNotFoundException2;
        }
    }

    @Override
    final boolean checkLock(FileLock fileLock) throws IOException {
        File file = this.getFileName().getFile();
        return fileLock instanceof LockForFile && Utils.equals(((LockForFile)fileLock).getFile(), file);
    }

    @Override
    public void rename(FileLock fileLock, String string, String string2, ProvidedExtensions.IOHandler iOHandler) throws IOException {
        super.rename(fileLock, string, string2, iOHandler);
        File file = this.getFileName().getFile();
        this.setLastModified(file.lastModified(), file, !file.canWrite());
    }

    private long getLastModified() {
        long l = this.lastModified;
        if (l < -10L) {
            return -l;
        }
        return l;
    }

    private void setLastModified(long l, boolean bl) {
        if (l >= -10L && l < 10L) {
            this.lastModified = l;
            return;
        }
        this.lastModified = bl ? -l : l;
    }

    private boolean thinksReadOnly() {
        return this.lastModified < -10L;
    }

    private void markReadOnly(boolean bl) {
        if (this.thinksReadOnly() != bl) {
            this.setLastModified(this.getLastModified(), bl);
        }
    }
}

