/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class LineChart
extends XYChart {
    public static final String TYPE = "Line";
    private static final int SHAPE_WIDTH = 30;
    private ScatterChart pointsChart;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.length;
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        float lineWidth = paint.getStrokeWidth();
        paint.setStrokeWidth(renderer.getLineWidth());
        if (renderer.isFillBelowLine()) {
            paint.setColor(renderer.getFillBelowLineColor());
            int pLength = points.length;
            float[] fillPoints = new float[pLength + 4];
            System.arraycopy(points, 0, fillPoints, 0, length);
            fillPoints[0] = points[0] + 1.0f;
            fillPoints[length] = fillPoints[length - 2];
            fillPoints[length + 1] = yAxisValue;
            fillPoints[length + 2] = fillPoints[0];
            fillPoints[length + 3] = fillPoints[length + 1];
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, fillPoints, paint, true);
        }
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, points, paint, false);
        paint.setStrokeWidth(lineWidth);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] points, double[] values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.length;
        ClickableArea[] ret = new ClickableArea[length / 2];
        for (int i = 0; i < length; i += 2) {
            int selectableBuffer = this.mRenderer.getSelectableBuffer();
            ret[i / 2] = new ClickableArea(new RectF(points[i] - (float)selectableBuffer, points[i + 1] - (float)selectableBuffer, points[i] + (float)selectableBuffer, points[i + 1] + (float)selectableBuffer), values[i], values[i + 1]);
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 30;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        canvas.drawLine(x, y, x + 30.0f, y, paint);
        if (this.isRenderPoints(renderer)) {
            this.pointsChart.drawLegendShape(canvas, renderer, x + 5.0f, y, seriesIndex, paint);
        }
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return ((XYSeriesRenderer)renderer).getPointStyle() != PointStyle.POINT;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.pointsChart;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

