/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.ArchiveResources;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.NetigsoModule;
import org.netbeans.ProxyClassLoader;
import org.netbeans.TopSecurityManager;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class NetigsoFramework {
    private static NetigsoFramework framework;
    private static List<NetigsoModule> toInit;
    private static ArrayList<Module> toEnable;

    protected NetigsoFramework() {
        if (!this.getClass().getName().equals("org.netbeans.core.netigso.Netigso")) {
            throw new IllegalStateException();
        }
    }

    protected abstract void prepare(Lookup var1, Collection<? extends Module> var2);

    protected abstract Set<String> start(Collection<? extends Module> var1);

    protected abstract void start();

    protected abstract void shutdown();

    protected abstract Set<String> createLoader(ModuleInfo var1, ProxyClassLoader var2, File var3) throws IOException;

    protected abstract void reload(Module var1) throws IOException;

    protected abstract void stopLoader(ModuleInfo var1, ClassLoader var2);

    protected ClassLoader findFrameworkClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected int defaultStartLevel() {
        return 0;
    }

    protected final byte[] fromArchive(ArchiveResources archiveResources, String string) throws IOException {
        return JarClassLoader.archive.getData(archiveResources, string);
    }

    static NetigsoFramework getDefault() {
        return framework;
    }

    static void willEnable(List<Module> list) {
        toEnable.addAll(list);
    }

    static Set<Module> turnOn(ClassLoader classLoader, Collection<Module> collection) throws InvalidException {
        Object object2;
        boolean bl = false;
        if (framework == null) {
            for (Object object2 : toEnable) {
                if (!(object2 instanceof NetigsoModule)) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return Collections.emptySet();
        }
        Lookup lookup = Lookups.metaInfServices((ClassLoader)classLoader);
        framework = (NetigsoFramework)lookup.lookup(NetigsoFramework.class);
        if (framework == null) {
            throw new IllegalStateException("No NetigsoFramework found, is org.netbeans.core.netigso module enabled?");
        }
        NetigsoFramework.getDefault().prepare(lookup, collection);
        toEnable.clear();
        toEnable.trimToSize();
        NetigsoFramework.delayedInit();
        object2 = framework.start(collection);
        if (object2 == null) {
            return Collections.emptySet();
        }
        HashSet<Module> hashSet = new HashSet<Module>();
        for (Module module : collection) {
            if (module.isEnabled() || !object2.contains(module.getCodeNameBase())) continue;
            hashSet.add(module);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean delayedInit() throws InvalidException {
        Object object = NetigsoFramework.class;
        synchronized (NetigsoFramework.class) {
            List<NetigsoModule> list = toInit;
            toInit = null;
            if (list == null || list.isEmpty()) {
                // ** MonitorExit[var1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            object = null;
            for (NetigsoModule netigsoModule : list) {
                try {
                    netigsoModule.start();
                }
                catch (IOException iOException) {
                    netigsoModule.setEnabled(false);
                    InvalidException invalidException = new InvalidException(netigsoModule, iOException.getMessage());
                    if (object == null) {
                        invalidException.initCause(iOException);
                    } else {
                        invalidException.initCause((Throwable)object);
                    }
                    object = invalidException;
                }
            }
            if (object != null) {
                throw object;
            }
            return false;
        }
    }

    static synchronized void classLoaderUp(NetigsoModule netigsoModule) throws IOException {
        if (toInit != null) {
            toInit.add(netigsoModule);
            return;
        }
        if (!toEnable.isEmpty()) {
            NetigsoFramework.getDefault().prepare(Lookup.getDefault(), toEnable);
            toEnable.clear();
        }
        netigsoModule.start();
    }

    static synchronized void classLoaderDown(NetigsoModule netigsoModule) {
        if (toInit != null) {
            toInit.remove((Object)netigsoModule);
            return;
        }
    }

    static void startFramework() {
        if (framework != null) {
            framework.start();
        }
    }

    static void shutdownFramework() {
        if (framework != null) {
            framework.shutdown();
        }
        framework = null;
        toInit = new ArrayList<NetigsoModule>();
        toEnable.clear();
    }

    static ClassLoader findFallbackLoader() {
        NetigsoFramework netigsoFramework = framework;
        if (netigsoFramework == null) {
            return null;
        }
        ClassLoader classLoader = netigsoFramework.findFrameworkClassLoader();
        Class[] classArray = TopSecurityManager.getStack();
        for (int i = 0; i < classArray.length; ++i) {
            ClassLoader classLoader2 = classArray[i].getClassLoader();
            if (classLoader2 == null || classLoader2.getClass().getClassLoader() != classLoader) continue;
            return classArray[i].getClassLoader();
        }
        return null;
    }

    static {
        toInit = new ArrayList<NetigsoModule>();
        toEnable = new ArrayList();
    }
}

