/*
 * Decompiled with CFR 0.152.
 */
package com.payeco.android.plugin.util;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.payeco.android.plugin.util.LBSTool$LBSThread;
import com.payeco.android.plugin.util.LBSTool$MyLocationListner;
import com.payeco.android.plugin.util.LocationData;
import java.io.IOException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class LBSTool {
    private Context mContext;
    private LocationManager mLocationManager;
    private LocationData mLocation;
    private LBSTool$LBSThread mLBSThread;
    private LBSTool$MyLocationListner mNetworkListner;
    private LBSTool$MyLocationListner mGPSListener;
    private Looper mLooper;

    public LBSTool(Context context) {
        this.mContext = context;
        this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
    }

    public LocationData getLocation(long l2) {
        this.mLocation = null;
        this.mLBSThread = new LBSTool$LBSThread(this, null);
        this.mLBSThread.start();
        l2 = l2 > 0L ? l2 : 0L;
        LBSTool$LBSThread lBSTool$LBSThread = this.mLBSThread;
        synchronized (lBSTool$LBSThread) {
            try {
                this.mLBSThread.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.mLBSThread = null;
        return this.mLocation;
    }

    public boolean isGPSEnabled() {
        return this.mLocationManager.isProviderEnabled("gps");
    }

    public boolean isNetworkEnabled() {
        return this.isWIFIEnabled() || this.isTelephonyEnabled();
    }

    public boolean isTelephonyEnabled() {
        boolean bl = false;
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        if (telephonyManager != null && telephonyManager.getNetworkType() != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isWIFIEnabled() {
        boolean bl = false;
        if (((WifiManager)this.mContext.getSystemService("wifi")).isWifiEnabled()) {
            bl = true;
        }
        return bl;
    }

    private void registerLocationListener() {
        if (this.isGPSEnabled()) {
            this.mGPSListener = new LBSTool$MyLocationListner(this, null);
            this.mLocationManager.requestLocationUpdates("gps", 1000L, 0.0f, (LocationListener)this.mGPSListener, this.mLooper);
        }
        if (this.isNetworkEnabled()) {
            this.mNetworkListner = new LBSTool$MyLocationListner(this, null);
            this.mLocationManager.requestLocationUpdates("network", 1000L, 0.0f, (LocationListener)this.mNetworkListner, this.mLooper);
        }
    }

    private void parseLatLon(String string, String string2) {
        try {
            Object object = new DefaultHttpClient();
            HttpGet httpGet = new HttpGet("http://ditu.google.cn/maps/geo?output=json&q=" + string + "," + string2);
            object = EntityUtils.toString((HttpEntity)object.execute((HttpUriRequest)httpGet).getEntity());
            object = new JSONObject((String)object);
            if (object.optJSONArray("Placemark") != null) {
                this.mLocation = new LocationData();
                this.mLocation.lat = string;
                this.mLocation.lon = string2;
                this.mLocation.address = object.optJSONArray("Placemark").optJSONObject(0).optString("address");
                return;
            }
        }
        catch (Exception exception) {
            Object var3_4 = null;
            exception.printStackTrace();
        }
    }

    private void unRegisterLocationListener() {
        if (this.mGPSListener != null) {
            this.mLocationManager.removeUpdates((LocationListener)this.mGPSListener);
            this.mGPSListener = null;
        }
        if (this.mNetworkListner != null) {
            this.mLocationManager.removeUpdates((LocationListener)this.mNetworkListner);
            this.mNetworkListner = null;
        }
    }

    public static String getAddress(Context object, double d2, double d3) {
        String string = null;
        object = new Geocoder((Context)object, Locale.getDefault());
        try {
            object = object.getFromLocation(d2, d3, 1);
            StringBuilder stringBuilder = new StringBuilder();
            if (object.size() > 0) {
                object = (Address)object.get(0);
                String string2 = object.getAdminArea();
                object = object.getLocality();
                if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)object)) {
                    stringBuilder.append(string2.substring(0, string2.length() - 1)).append(",").append(((String)object).substring(0, string2.length() - 1));
                }
                string = stringBuilder.toString();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    static /* synthetic */ void access$0(LBSTool lBSTool, Looper looper) {
        lBSTool.mLooper = looper;
    }

    static /* synthetic */ void access$1(LBSTool lBSTool) {
        lBSTool.registerLocationListener();
    }

    static /* synthetic */ void access$2(LBSTool lBSTool) {
        lBSTool.unRegisterLocationListener();
    }

    static /* synthetic */ LBSTool$LBSThread access$3(LBSTool lBSTool) {
        return lBSTool.mLBSThread;
    }

    static /* synthetic */ void access$4(LBSTool lBSTool, String string, String string2) {
        lBSTool.parseLatLon(string, string2);
    }

    static /* synthetic */ Looper access$5(LBSTool lBSTool) {
        return lBSTool.mLooper;
    }
}

