/*
 * Decompiled with CFR 0.152.
 */
package com.payeco.android.plugin.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IdcardUtils {
    public static final int CHINA_ID_MIN_LENGTH = 15;
    public static final int CHINA_ID_MAX_LENGTH = 18;
    public static final String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    public static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    public static final String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    public static final int MIN = 1930;
    public static Map cityCodes = new HashMap<String, String>();

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String conver15CardTo18(String string) {
        if (string.length() != 15) {
            return null;
        }
        if (!IdcardUtils.isNum(string)) return null;
        Object object = string.substring(6, 12);
        Date date = null;
        try {
            date = new SimpleDateFormat("yyMMdd").parse((String)object);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        object = Calendar.getInstance();
        if (date != null) {
            ((Calendar)object).setTime(date);
        }
        object = String.valueOf(((Calendar)object).get(1));
        string = String.valueOf(string.substring(0, 6)) + (String)object + string.substring(8);
        char[] cArray = string.toCharArray();
        object = cArray;
        if (cArray == null) return string;
        if (((String)(object = IdcardUtils.getCheckCode18(IdcardUtils.getPowerSum(IdcardUtils.converCharToInt((char[])object))))).length() <= 0) return null;
        return String.valueOf(string) + (String)object;
    }

    public static boolean validateCard(String string) {
        if ((string = string.trim()).length() == 18) {
            return IdcardUtils.validateIdCard18(string);
        }
        if (string.length() == 15) {
            return IdcardUtils.validateIdCard15(string);
        }
        return false;
    }

    public static boolean validateIdCard18(String string) {
        boolean bl = false;
        if (string.length() == 18) {
            Object object = string.substring(0, 17);
            string = string.substring(17, 18);
            if (IdcardUtils.isNum((String)object)) {
                char[] cArray = ((String)object).toCharArray();
                object = cArray;
                if (cArray != null && ((String)(object = IdcardUtils.getCheckCode18(IdcardUtils.getPowerSum(IdcardUtils.converCharToInt((char[])object))))).length() > 0 && ((String)object).equalsIgnoreCase(string)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean validateIdCard15(String string) {
        if (string.length() != 15) {
            return false;
        }
        if (IdcardUtils.isNum(string)) {
            Object object = string.substring(0, 2);
            if (cityCodes.get(object) == null) {
                return false;
            }
            string = string.substring(6, 12);
            object = null;
            try {
                object = new SimpleDateFormat("yy").parse(string.substring(0, 2));
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            if (object != null) {
                calendar.setTime((Date)object);
            }
            return IdcardUtils.valiDate(calendar.get(1), Integer.valueOf(string.substring(2, 4)), Integer.valueOf(string.substring(4, 6)));
        }
        return false;
    }

    public static int[] converCharToInt(char[] cArray) {
        int n2 = cArray.length;
        int[] nArray = new int[n2];
        try {
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = Integer.parseInt(String.valueOf(cArray[n3]));
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return nArray;
    }

    public static int getPowerSum(int[] nArray) {
        int n2 = 0;
        if (power.length == nArray.length) {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = 0;
                while (n4 < power.length) {
                    if (n3 == n4) {
                        n2 += nArray[n3] * power[n4];
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static String getCheckCode18(int n2) {
        String string = "";
        switch (n2 % 11) {
            case 10: {
                string = "2";
                break;
            }
            case 9: {
                string = "3";
                break;
            }
            case 8: {
                string = "4";
                break;
            }
            case 7: {
                string = "5";
                break;
            }
            case 6: {
                string = "6";
                break;
            }
            case 5: {
                string = "7";
                break;
            }
            case 4: {
                string = "8";
                break;
            }
            case 3: {
                string = "9";
                break;
            }
            case 2: {
                string = "x";
                break;
            }
            case 1: {
                string = "0";
                break;
            }
            case 0: {
                string = "1";
            }
        }
        return string;
    }

    public static int getAgeByIdCard(String string) {
        if (string.length() == 15) {
            string = IdcardUtils.conver15CardTo18(string);
        }
        string = string.substring(6, 10);
        return Calendar.getInstance().get(1) - Integer.valueOf(string);
    }

    public static String getBirthByIdCard(String string) {
        Integer n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtils.conver15CardTo18(string);
        }
        return string.substring(6, 14);
    }

    public static Short getYearByIdCard(String string) {
        Integer n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtils.conver15CardTo18(string);
        }
        return Short.valueOf(string.substring(6, 10));
    }

    public static Short getMonthByIdCard(String string) {
        Integer n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtils.conver15CardTo18(string);
        }
        return Short.valueOf(string.substring(10, 12));
    }

    public static Short getDateByIdCard(String string) {
        Integer n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtils.conver15CardTo18(string);
        }
        return Short.valueOf(string.substring(12, 14));
    }

    public static String getGenderByIdCard(String string) {
        if (string.length() == 15) {
            string = IdcardUtils.conver15CardTo18(string);
        }
        string = Integer.parseInt(string.substring(16, 17)) % 2 != 0 ? "M" : "F";
        return string;
    }

    public static String getProvinceByIdCard(String string) {
        int n2 = string.length();
        String string2 = "";
        if (n2 == 15 || n2 == 18) {
            string2 = string.substring(0, 2);
        }
        return (String)cityCodes.get(string2);
    }

    public static boolean isNum(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return string.matches("^[0-9]*$");
    }

    public static boolean valiDate(int n2, int n3, int n4) {
        int n5 = Calendar.getInstance().get(1);
        if (n2 < 1930 || n2 >= n5) {
            return false;
        }
        if (n3 <= 0 || n3 > 12) {
            return false;
        }
        switch (n3) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 30;
                break;
            }
            case 2: {
                n2 = (n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0) && n2 > 1930 && n2 < n5 ? 29 : 28;
                break;
            }
            default: {
                n2 = 31;
            }
        }
        return n4 > 0 && n4 <= n2;
    }
}

