/*
 * Decompiled with CFR 0.152.
 */
package com.payeco.android.plugin;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.payeco.android.plugin.PayecoPluginApplication;
import com.payeco.android.plugin.http.encryption.PayecoPluginBase64;
import com.payeco.android.plugin.http.encryption.PayecoPluginMD5;
import com.payeco.android.plugin.http.encryption.PayecoPluginRSA;
import com.payeco.android.plugin.http.encryption.PayecoPluginThreeDES;
import com.payeco.android.plugin.http.parse.ConfigFileUtil;
import com.payeco.android.plugin.http.parse.ConfigParseService;
import com.payeco.android.plugin.util.IdcardUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.http.util.EncodingUtils;

public class PayecoBaseUtil {
    public static void startActivity(Activity activity, Class clazz, String string, Serializable serializable, boolean bl) {
        clazz = new Intent((Context)activity, clazz);
        clazz.addFlags(131072);
        if (serializable != null) {
            clazz.putExtra(string, serializable);
        }
        activity.startActivity((Intent)clazz);
        activity.overridePendingTransition(0x10A0000, 0x10A0001);
        if (bl) {
            activity.finish();
        }
    }

    public static void showCommonDialog(Activity activity, String string, String string2, String string3, DialogInterface.OnClickListener onClickListener, String string4, DialogInterface.OnClickListener onClickListener2, boolean bl) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)string);
        builder.setPositiveButton((CharSequence)string3, onClickListener);
        builder.setNegativeButton((CharSequence)string4, onClickListener2);
        builder.setCancelable(bl);
        if (!activity.isFinishing()) {
            builder.create().show();
        }
    }

    public static Dialog createWaitDialog(Context context, boolean bl) {
        Resources resources = context.getResources();
        String string = context.getPackageName();
        LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)context).inflate(resources.getIdentifier("payeco_plugin_wait_dialog", "layout", string), null).findViewById(resources.getIdentifier("payeco_waitHttpResDialog", "id", string));
        context = new Dialog(context, resources.getIdentifier("payeco_fullHeightDialog", "style", string));
        context.setCancelable(bl);
        context.setContentView((View)linearLayout);
        return context;
    }

    public static void showToast(Activity activity, int n2) {
        Resources resources = activity.getResources();
        String string = activity.getPackageName();
        int n3 = resources.getIdentifier("payeco_plugin_toast", "layout", string);
        View view = activity.getLayoutInflater().inflate(n3, null);
        activity = new Toast((Context)activity);
        activity.setView(view);
        ((TextView)view.findViewById(resources.getIdentifier("payeco_plugin_toastInfo", "id", string))).setText(n2);
        activity.show();
    }

    public static void showToast(Activity activity, String string) {
        Resources resources = activity.getResources();
        String string2 = activity.getPackageName();
        int n2 = resources.getIdentifier("payeco_plugin_toast", "layout", string2);
        View view = activity.getLayoutInflater().inflate(n2, null);
        activity = new Toast((Context)activity);
        activity.setView(view);
        ((TextView)view.findViewById(resources.getIdentifier("payeco_plugin_toastInfo", "id", string2))).setText((CharSequence)string);
        activity.show();
    }

    public static boolean checkNetWork(Context context) {
        return (context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && context.getState() == NetworkInfo.State.CONNECTED && context.isAvailable();
    }

    public static String getIMEI(Context context) {
        return ((TelephonyManager)context.getSystemService("phone")).getDeviceId();
    }

    public static String getIMSI(Context context) {
        return ((TelephonyManager)context.getSystemService("phone")).getSubscriberId();
    }

    public static Object getConfigValue(Activity activity, String string) {
        Object var2_2 = null;
        PayecoPluginApplication payecoPluginApplication = PayecoPluginApplication.getInstance();
        Map map = payecoPluginApplication.getConfigMap();
        try {
            if (map == null) {
                Object object = PayecoBaseUtil.getConfigFilePrivateKey((Context)activity);
                Object object2 = ConfigFileUtil.readConfigFile(activity.openFileInput("payeco_plugin_config.xml"));
                object = PayecoPluginThreeDES.decryptMode(((String)object).getBytes(), (byte[])object2);
                object2 = new PayecoPluginMD5().getMD5((byte[])object);
                Object object3 = object2;
                object2 = PayecoPluginBase64.encodeLines(ConfigFileUtil.readConfigFile(activity.openFileInput("payeco_plugin_config_md5.xml")));
                if (((String)object2).equalsIgnoreCase((String)(object3 = (Object)PayecoPluginBase64.encodeLines(object3)))) {
                    object = EncodingUtils.getString((byte[])object, (String)"UTF-8");
                    ConfigFileUtil.writeConfigFile((Context)activity, (String)object, "temp.xml", 0);
                    map = new ConfigParseService().parseConfig(activity.openFileInput("temp.xml"));
                    payecoPluginApplication.setConfigMap(map);
                    activity.deleteFile("temp.xml");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (map != null) {
            var2_2 = map.get(string);
        }
        return var2_2;
    }

    public static String getConfigFilePrivateKey(Context context) {
        String string = PayecoBaseUtil.getValueFromPreferences(context, "configFilePrivateKey");
        if (string == null) {
            string = PayecoBaseUtil.a();
            PayecoBaseUtil.saveValueToPreferencs(context, "configFilePrivateKey", string);
        }
        return string;
    }

    private static String a() {
        Random random = null;
        char[] cArray = null;
        Object object = new Object();
        synchronized (object) {
            random = new Random();
            cArray = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        }
        object = new char[24];
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            object[n2] = cArray[random.nextInt(71)];
            ++n2;
        }
        return new String((char[])object);
    }

    public static String encryptPin(Activity object, String string) {
        if (string == null) {
            return null;
        }
        String string2 = String.valueOf(PayecoBaseUtil.getConfigValue(object, "frontModulus"));
        object = String.valueOf(PayecoBaseUtil.getConfigValue(object, "frontPublicExponent"));
        return PayecoPluginRSA.encryptForConfig(string, string2, (String)object);
    }

    public static String formatString(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > n2) {
            stringBuilder.append("**").append(string.substring(string.length() - n2, string.length()));
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static boolean checkMobileNum(String string) {
        return Pattern.compile("[0-9]{11}").matcher(string).matches();
    }

    public static boolean checkPan(String string) {
        return string.matches("[0-9]{10,19}");
    }

    public static boolean checkIdNum(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return IdcardUtils.validateCard(string);
    }

    public static boolean checkAnsStr(String string) {
        return string.matches("[^<>&\"']{1,}");
    }

    public static boolean checkStrlength(String string, int n2) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() == n2;
    }

    public static String getValueFromPreferences(Context context, String string) {
        return context.getSharedPreferences("plugin_preference", 0).getString(string, null);
    }

    public static void saveValueToPreferencs(Context context, String string, String string2) {
        context = context.getSharedPreferences("plugin_preference", 0).edit();
        context.putString(string, string2);
        context.commit();
    }

    public static String formatTimeStr(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, 4));
        stringBuilder.append("-").append(string.substring(4, 6));
        stringBuilder.append("-").append(string.substring(6, 8));
        stringBuilder.append(" ").append(string.substring(8, 10));
        stringBuilder.append(":").append(string.substring(10, 12));
        stringBuilder.append(":").append(string.substring(12, 14));
        return stringBuilder.toString();
    }

    public static String getLocalMacAddress(Context context) {
        return ((WifiManager)context.getSystemService("wifi")).getConnectionInfo().getMacAddress();
    }

    public String getLocalIpAddress(Context object) {
        try {
            object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                Enumeration<InetAddress> enumeration = ((NetworkInterface)object.nextElement()).getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException socketException) {
            Log.e((String)"WifiPreference IpAddress", (String)socketException.toString());
        }
        return null;
    }

    public static void saveFile(String string, String object) {
        try {
            object = new File((String)object);
            if (!((File)object).exists()) {
                new File(((File)object).getParent()).mkdirs();
                ((File)object).createNewFile();
            }
            object = new FileOutputStream((File)object, true);
            ((FileOutputStream)object).write(string.getBytes());
            ((FileOutputStream)object).close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static String fomatAmount(String object) {
        if (!TextUtils.isEmpty((CharSequence)object)) {
            double d2 = Double.parseDouble((String)object);
            object = new DecimalFormat();
            ((DecimalFormat)object).applyPattern("0.00");
            return ((NumberFormat)object).format(d2);
        }
        return null;
    }
}

