/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.openapi;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.mm.sdk.a.a;
import com.tencent.mm.sdk.a.a.a;
import com.tencent.mm.sdk.a.a.b;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.modelbiz.AddCardToWXCardPackage;
import com.tencent.mm.sdk.modelmsg.GetMessageFromWX;
import com.tencent.mm.sdk.modelmsg.LaunchFromWX;
import com.tencent.mm.sdk.modelmsg.SendAuth;
import com.tencent.mm.sdk.modelmsg.SendMessageToWX;
import com.tencent.mm.sdk.modelmsg.ShowMessageFromWX;
import com.tencent.mm.sdk.modelpay.PayResp;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.MMSharedPreferences;
import com.tencent.mm.sdk.openapi.WXApiImplComm;
import com.tencent.wxop.stat.c;
import com.tencent.wxop.stat.d;
import com.tencent.wxop.stat.e;

final class WXApiImplV10
implements IWXAPI {
    private static final String TAG = "MicroMsg.SDK.WXApiImplV10";
    private static ActivityLifecycleCb activityCb = null;
    private Context context;
    private String appId;
    private boolean checkSignature = false;
    private boolean detached = false;
    private static String wxappPayEntryClassname = null;

    WXApiImplV10(Context context, String string, boolean bl) {
        com.tencent.mm.sdk.b.a.d(TAG, "<init>, appId = " + string + ", checkSignature = " + bl);
        this.context = context;
        this.appId = string;
        this.checkSignature = bl;
    }

    public final boolean registerApp(String object) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "register app failed for wechat app signature check failed");
            return false;
        }
        if (activityCb == null && Build.VERSION.SDK_INT >= 14) {
            if (this.context instanceof Activity) {
                this.initMta(this.context, (String)object);
                activityCb = new ActivityLifecycleCb(this.context);
                ((Activity)this.context).getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else if (this.context instanceof Service) {
                this.initMta(this.context, (String)object);
                activityCb = new ActivityLifecycleCb(this.context);
                ((Service)this.context).getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else {
                com.tencent.mm.sdk.b.a.b(TAG, "context is not instanceof Activity or Service, disable WXStat");
            }
        }
        com.tencent.mm.sdk.b.a.d(TAG, "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        com.tencent.mm.sdk.b.a.d(TAG, "register app " + this.context.getPackageName());
        object = new a.a();
        new a.a().o = "com.tencent.mm";
        ((a.a)object).p = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((a.a)object).m = "weixin://registerapp?appid=" + this.appId;
        return com.tencent.mm.sdk.a.a.a.a(this.context, (a.a)object);
    }

    public final void unregisterApp() {
        if (this.detached) {
            throw new IllegalStateException("unregisterApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "unregister app failed for wechat app signature check failed");
            return;
        }
        com.tencent.mm.sdk.b.a.d(TAG, "unregisterApp, appId = " + this.appId);
        if (this.appId == null || this.appId.length() == 0) {
            com.tencent.mm.sdk.b.a.a(TAG, "unregisterApp fail, appId is empty");
            return;
        }
        com.tencent.mm.sdk.b.a.d(TAG, "unregister app " + this.context.getPackageName());
        a.a a2 = new a.a();
        new a.a().o = "com.tencent.mm";
        a2.p = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER";
        a2.m = "weixin://unregisterapp?appid=" + this.appId;
        com.tencent.mm.sdk.a.a.a.a(this.context, a2);
    }

    public final boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        if (!WXApiImplComm.isIntentFromWx(object, "com.tencent.mm.openapi.token")) {
            com.tencent.mm.sdk.b.a.c(TAG, "handleIntent fail, intent not from weixin msg");
            return false;
        }
        if (this.detached) {
            throw new IllegalStateException("handleIntent fail, WXMsgImpl has been detached");
        }
        Object object2 = object.getStringExtra("_mmessage_content");
        int n2 = object.getIntExtra("_mmessage_sdkVersion", 0);
        String string = object.getStringExtra("_mmessage_appPackage");
        if (string == null || string.length() == 0) {
            com.tencent.mm.sdk.b.a.a(TAG, "invalid argument");
            return false;
        }
        byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
        if (!this.checkSumConsistent(byArray, (byte[])(object2 = (Object)b.a((String)object2, n2, string)))) {
            com.tencent.mm.sdk.b.a.a(TAG, "checksum fail");
            return false;
        }
        int n3 = object.getIntExtra("_wxapi_command_type", 0);
        switch (n3) {
            case 1: {
                object = new SendAuth.Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 2: {
                object = new SendMessageToWX.Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 3: {
                object = new GetMessageFromWX.Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
            case 4: {
                object = new ShowMessageFromWX.Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
            case 5: {
                object = new PayResp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            case 6: {
                object = new LaunchFromWX.Req(object.getExtras());
                iWXAPIEventHandler.onReq((BaseReq)object);
                return true;
            }
            case 9: {
                object = new AddCardToWXCardPackage.Resp(object.getExtras());
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
        }
        com.tencent.mm.sdk.b.a.a(TAG, "unknown cmd = " + n3);
        return false;
    }

    public final boolean isWXAppInstalled() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppInstalled fail, WXMsgImpl has been detached");
        }
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                return false;
            }
            return WXApiImplComm.validateAppSignature(this.context, packageInfo.signatures, this.checkSignature);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public final boolean isWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        return this.getWXAppSupportAPI() >= 570490883;
    }

    public final int getWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("getWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            com.tencent.mm.sdk.b.a.a(TAG, "open wx app failed, not installed or signature check failed");
            return 0;
        }
        return new MMSharedPreferences(this.context).getInt("_build_info_sdk_int_", 0);
    }

    public final boolean openWXApp() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            com.tencent.mm.sdk.b.a.a(TAG, "open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            com.tencent.mm.sdk.b.a.a(TAG, "startActivity fail, exception = " + exception.getMessage());
            return false;
        }
        return true;
    }

    public final boolean sendReq(BaseReq object) {
        if (this.detached) {
            throw new IllegalStateException("sendReq fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendReq failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseReq)object).checkArgs()) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendReq checkArgs fail");
            return false;
        }
        com.tencent.mm.sdk.b.a.d(TAG, "sendReq, req type = " + ((BaseReq)object).getType());
        Bundle bundle = new Bundle();
        ((BaseReq)object).toBundle(bundle);
        if (((BaseReq)object).getType() == 5) {
            return this.sendPayReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 7) {
            return this.sendJumpToBizProfileReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 8) {
            return this.sendJumpToBizWebviewReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 9) {
            return this.sendAddCardToWX(this.context, bundle);
        }
        object = new a.a();
        new a.a().n = bundle;
        ((a.a)object).m = "weixin://sendreq?appid=" + this.appId;
        ((a.a)object).k = "com.tencent.mm";
        ((a.a)object).l = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return a.a(this.context, (a.a)object);
    }

    private boolean sendPayReq(Context context, Bundle bundle) {
        if (wxappPayEntryClassname == null) {
            wxappPayEntryClassname = new MMSharedPreferences(context).getString("_wxapp_pay_entry_classname_", null);
            com.tencent.mm.sdk.b.a.d(TAG, "pay, set wxappPayEntryClassname = " + wxappPayEntryClassname);
            if (wxappPayEntryClassname == null) {
                com.tencent.mm.sdk.b.a.a(TAG, "pay fail, wxappPayEntryClassname is null");
                return false;
            }
        }
        a.a a2 = new a.a();
        new a.a().n = bundle;
        a2.k = "com.tencent.mm";
        a2.l = wxappPayEntryClassname;
        return a.a(context, a2);
    }

    private boolean sendJumpToBizProfileReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_profile_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_profile_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_scene"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_profile_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizWebviewReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_scene")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendAddCardToWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/addCardToWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_add_card_to_wx_card_list"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    public final boolean sendResp(BaseResp object) {
        if (this.detached) {
            throw new IllegalStateException("sendResp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseResp)object).checkArgs()) {
            com.tencent.mm.sdk.b.a.a(TAG, "sendResp checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        ((BaseResp)object).toBundle(bundle);
        object = new a.a();
        new a.a().n = bundle;
        ((a.a)object).m = "weixin://sendresp?appid=" + this.appId;
        ((a.a)object).k = "com.tencent.mm";
        ((a.a)object).l = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return a.a(this.context, (a.a)object);
    }

    public final void detach() {
        com.tencent.mm.sdk.b.a.d(TAG, "detach");
        this.detached = true;
        if (activityCb != null && Build.VERSION.SDK_INT >= 14) {
            if (this.context instanceof Activity) {
                ((Activity)this.context).getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else if (this.context instanceof Service) {
                ((Service)this.context).getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            }
            activityCb.detach();
        }
        this.context = null;
    }

    private boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            com.tencent.mm.sdk.b.a.a(TAG, "checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            com.tencent.mm.sdk.b.a.a(TAG, "checkSumConsistent fail, length is different");
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void initMta(Context context, String string) {
        string = "AWXOP" + string;
        c.b(context, string);
        c.w();
        c.a(d.aG);
        c.t();
        c.c(context, "Wechat_Sdk");
        try {
            e.a(context, string, "2.0.2");
            return;
        }
        catch (com.tencent.wxop.stat.a a2) {
            a2.printStackTrace();
            return;
        }
    }

    private static final class ActivityLifecycleCb
    implements Application.ActivityLifecycleCallbacks {
        private static final String TAG = "MicroMsg.SDK.WXApiImplV10.ActivityLifecycleCb";
        private static final int DELAYED = 800;
        private boolean isForeground = false;
        private Handler handler = new Handler(Looper.getMainLooper());
        private Context context;
        private Runnable onPausedRunnable = new Runnable(){

            public void run() {
                if (activityCb != null && ActivityLifecycleCb.this.isForeground) {
                    Log.v((String)ActivityLifecycleCb.TAG, (String)"WXStat trigger onBackground");
                    e.d(ActivityLifecycleCb.this.context, "onBackground_WX");
                    ActivityLifecycleCb.this.isForeground = false;
                }
            }
        };
        private Runnable onResumedRunnable = new Runnable(){

            public void run() {
                if (activityCb != null && !ActivityLifecycleCb.this.isForeground) {
                    Log.v((String)ActivityLifecycleCb.TAG, (String)"WXStat trigger onForeground");
                    e.d(ActivityLifecycleCb.this.context, "onForeground_WX");
                    ActivityLifecycleCb.this.isForeground = true;
                }
            }
        };

        private ActivityLifecycleCb(Context context) {
            this.context = context;
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
            Log.v((String)TAG, (String)(activity.getComponentName().getClassName() + "  onActivityPaused"));
            this.handler.removeCallbacks(this.onResumedRunnable);
            this.handler.postDelayed(this.onPausedRunnable, 800L);
        }

        public final void onActivityResumed(Activity activity) {
            Log.v((String)TAG, (String)(activity.getComponentName().getClassName() + "  onActivityResumed"));
            this.handler.removeCallbacks(this.onPausedRunnable);
            this.handler.postDelayed(this.onResumedRunnable, 800L);
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public final void onActivityStarted(Activity activity) {
        }

        public final void onActivityStopped(Activity activity) {
        }

        public final void detach() {
            this.handler.removeCallbacks(this.onResumedRunnable);
            this.handler.removeCallbacks(this.onPausedRunnable);
            this.context = null;
        }
    }
}

