/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.support.util;

import com.alipay.config.Config;
import com.alipay.config.Env;
import com.alipay.support.util.RsaKey;
import com.alipay.support.util.SupportUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GenerateRsaUtil {
    public static String mkRsaPrivateKeyFile(String privateKeyLength) throws Exception {
        String keyLength;
        String string = keyLength = StringUtils.isBlank((String)privateKeyLength) ? "1024" : privateKeyLength;
        if (!SupportUtil.isExists(Config.KEY_SAVE_PATH)) {
            SupportUtil.mkDir(Config.KEY_SAVE_PATH);
        }
        if (Env.isMac()) {
            GenerateRsaUtil.execCmd("genrsa -out", String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt", keyLength);
        } else {
            GenerateRsaUtil.execCmd("genrsa -out", "\"" + Config.KEY_SAVE_PATH + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt" + "\"", keyLength);
        }
        return new File(String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt").getAbsolutePath();
    }

    public static String mkRsaPrivateKey(String privateKeyLength) throws Exception {
        String keyLength = StringUtils.isBlank((String)privateKeyLength) ? "1024" : privateKeyLength;
        return GenerateRsaUtil.execCmd(keyLength);
    }

    public static String mkRsaPublicKeyFile(String privateKeyFile, Integer keyLength) throws Exception {
        if (!GenerateRsaUtil.isExistFile(privateKeyFile)) {
            return null;
        }
        if (Env.isMac()) {
            GenerateRsaUtil.execCmd("rsa -in", privateKeyFile, "-pubout -out", String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt");
        } else {
            GenerateRsaUtil.execCmd("rsa -in", "\"" + privateKeyFile + "\"", "-pubout -out", "\"" + Config.KEY_SAVE_PATH + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt" + "\"");
        }
        return new File(String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt").getAbsolutePath();
    }

    public static String getKeyFromFile(String keyFilePath) throws Exception {
        if (StringUtils.isBlank((String)keyFilePath)) {
            return null;
        }
        File file = new File(keyFilePath);
        if (!file.exists()) {
            return null;
        }
        String key = SupportUtil.readFileAsString(keyFilePath);
        key = GenerateRsaUtil.getOriginalKey(key);
        return key;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (StringUtils.isNotBlank((String)str)) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String removeUrlParams(String url, String[] params) {
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            url = GenerateRsaUtil.removeUrlParam(url, param);
            ++n2;
        }
        return url;
    }

    public static String removeUrlParam(String url, String param) {
        String[] params = url.split("&");
        String signStr = "";
        int i = 0;
        while (i < params.length) {
            String para = params[i];
            if (!para.contains(String.valueOf(param) + "=")) {
                signStr = String.valueOf(signStr) + para + "&";
            }
            ++i;
        }
        if (StringUtils.isNotBlank((String)signStr)) {
            int endIndex = signStr.length();
            String sign = signStr.substring(0, endIndex - 1);
            return sign;
        }
        return null;
    }

    public static String removeUrlHead(String fileName, String url, Integer step) throws IOException {
        Integer queIndex = url.indexOf("?");
        Integer startHttpIndex = url.indexOf("http");
        if (startHttpIndex != 0 || queIndex <= 0) {
            String retUrlParam = url;
            return retUrlParam;
        }
        String retUrlParam = url.substring(queIndex + 1, url.length());
        RsaKey.appendTxtFile(fileName, step + ".\u5220\u9664url\u5730\u5740\uff1a\r\n");
        RsaKey.appendTxtFile(fileName, "\u3010" + retUrlParam + "\u3011\r\n\r\n");
        return retUrlParam;
    }

    public static String removeUrlEmptyParams(String url, String fileName) throws IOException {
        String[] params = url.split("&");
        StringBuffer retUrl = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            String para = params[i];
            if (StringUtils.isNotBlank((String)para)) {
                String[] paramValues = (para = para.trim()).split("=");
                if (paramValues.length == 1) {
                    RsaKey.appendTxtFile(fileName, "\t\t\u5220\u9664\u7a7a\u5b57\u6bb5\u3010" + paramValues[0] + "\u3011\r\n\r\n");
                } else {
                    retUrl.append(para.substring(0, para.indexOf("="))).append(para.substring(para.indexOf("="))).append("&");
                }
            }
            ++i;
        }
        String retUrlStr = retUrl.toString();
        String lastChar = retUrlStr.substring(retUrlStr.length() - 1, retUrlStr.length());
        if (StringUtils.isNotBlank((String)retUrl.toString()) && "&".equals(lastChar)) {
            url = retUrl.toString().substring(0, retUrl.toString().length() - 1);
        }
        return url;
    }

    public static String getUrlParams(String url, String param) {
        String[] params = url.split("&");
        String signStr = "";
        int i = 0;
        while (i < params.length) {
            String paramValueTrim;
            String para = params[i];
            String[] paramValue = para.split("=");
            if (paramValue.length > 1 && (paramValueTrim = String.valueOf(paramValue[0].trim()) + "=" + paramValue[1].trim()).contains(String.valueOf(param) + "=")) {
                signStr = params[i];
                break;
            }
            ++i;
        }
        if (StringUtils.isNotBlank((String)signStr)) {
            int beginIndex = signStr.indexOf("=");
            int endIndex = signStr.length();
            String sign = signStr.substring(beginIndex + 1, endIndex);
            return sign.trim();
        }
        return null;
    }

    public static String runCMD(String cmd) throws Exception {
        Process p = null;
        BufferedReader br = null;
        try {
            String readLine;
            p = Runtime.getRuntime().exec(cmd);
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (p != null) {
                p.destroy();
                p = null;
            }
        }
    }

    public static String runCMD(String[] cmd) throws Exception {
        Process p = null;
        BufferedReader br = null;
        try {
            String readLine;
            p = Runtime.getRuntime().exec(cmd);
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (p != null) {
                p.destroy();
                p = null;
            }
        }
    }

    public static void info(String msg) {
        GenerateRsaUtil.info(msg, null);
    }

    public static void info(String msg, Object[] args) {
        try {
            if (StringUtils.isNotBlank((String)msg)) {
                String info = MessageFormat.format(msg, args);
                SupportUtil.writeFileString("run.log", info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getOriginalKey(String key) {
        key = key.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        return GenerateRsaUtil.replaceBlank(key);
    }

    private static String execCmd(String ... cmdStr) throws Exception {
        String opensslPath = "openssl\\bin\\openssl.exe";
        if (Env.isMac()) {
            opensslPath = "/usr/bin/openssl";
        } else if (!GenerateRsaUtil.isExistFile(opensslPath)) {
            opensslPath = String.valueOf(Config.CURRENT_SIGN_TYPE) + File.separator + opensslPath;
        }
        if (!GenerateRsaUtil.isExistFile(opensslPath)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(opensslPath) + " ");
        if (cmdStr == null || cmdStr.length == 0) {
            throw new NullPointerException("\u6267\u884c\u751f\u6210\u5bc6\u94a5\u547d\u4ee4\u5931\u8d25");
        }
        String[] stringArray = cmdStr;
        int n = cmdStr.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            sb.append(c).append(" ");
            ++n2;
        }
        return GenerateRsaUtil.runCMD(sb.toString());
    }

    public static boolean isExistFile(String filePath) {
        if (StringUtils.isBlank((String)filePath)) {
            return false;
        }
        return new File(filePath).exists();
    }

    public static void clearHeadBottom(Integer keyLength) throws Exception {
        File tmpFile;
        String privateKeyFilePath = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u79c1\u94a5" + keyLength + ".txt";
        String publicKeyFilePath = String.valueOf(Config.KEY_SAVE_PATH) + "\u5e94\u7528\u516c\u94a5" + keyLength + ".txt";
        String privateKey = RsaKey.getKeyFromFile(privateKeyFilePath);
        String publicKey = RsaKey.getKeyFromFile(publicKeyFilePath);
        if (StringUtils.isEmpty((String)publicKey)) {
            tmpFile = new File(publicKeyFilePath);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        } else {
            SupportUtil.writeFileString(publicKeyFilePath, publicKey);
        }
        if (StringUtils.isEmpty((String)privateKey)) {
            tmpFile = new File(privateKeyFilePath);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        } else {
            SupportUtil.writeFileString(privateKeyFilePath, privateKey);
        }
    }
}

