/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map<ClassLoader, Map<List<String>, Object>> loaderToCache = new WeakHashMap<ClassLoader, Map<List<String>, Object>>();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map<Class<?>, Void> proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.doNewInstanceCheck();
        this.h = invocationHandler;
    }

    private void doNewInstanceCheck() {
        SecurityManager securityManager = System.getSecurityManager();
        Class<?> clazz = this.getClass();
        if (securityManager != null && ProxyAccessHelper.needsNewInstanceCheck(clazz)) {
            try {
                securityManager.checkPermission(ProxyAccessHelper.PROXY_PERMISSION);
            }
            catch (SecurityException securityException) {
                throw new SecurityException("Not allowed to construct a Proxy instance that implements a non-public interface", securityException);
            }
        }
    }

    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) throws IllegalArgumentException {
        return Proxy.getProxyClass0(classLoader, classArray);
    }

    private static void checkProxyLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && classLoader2 == null && classLoader != null && !ProxyAccessHelper.allowNullLoader) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getProxyClass0(ClassLoader classLoader, Class<?> ... classArray) {
        HashMap<List<String>, Object> hashMap;
        HashMap<List<String>, Object> hashMap2;
        Object object;
        String[] stringArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            stringArray = Reflection.getCallerClass(3);
            object = stringArray.getClassLoader();
            Proxy.checkProxyLoader((ClassLoader)object, classLoader);
            ReflectUtil.checkProxyPackageAccess((ClassLoader)object, classArray);
        }
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class clazz = null;
        stringArray = new String[classArray.length];
        object = new HashSet();
        for (int i = 0; i < classArray.length; ++i) {
            hashMap2 = classArray[i].getName();
            hashMap = null;
            try {
                hashMap = Class.forName((String)((Object)hashMap2), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (hashMap != classArray[i]) {
                throw new IllegalArgumentException(classArray[i] + " is not visible from class loader");
            }
            if (!((Class)((Object)hashMap)).isInterface()) {
                throw new IllegalArgumentException(((Class)((Object)hashMap)).getName() + " is not an interface");
            }
            if (object.contains(hashMap)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)((Object)hashMap)).getName());
            }
            object.add(hashMap);
            stringArray[i] = hashMap2;
        }
        List<String> list = Arrays.asList(stringArray);
        hashMap = loaderToCache;
        synchronized (hashMap) {
            hashMap2 = loaderToCache.get(classLoader);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<List<String>, Object>();
                loaderToCache.put(classLoader, hashMap2);
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            while (true) {
                Object v;
                if ((v = hashMap2.get(list)) instanceof Reference) {
                    clazz = (Class)((Reference)v).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (v != pendingGenerationMarker) break;
                try {
                    hashMap2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            hashMap2.put(list, pendingGenerationMarker);
        }
        try {
            long l;
            Object object2;
            hashMap = null;
            for (int i = 0; i < classArray.length; ++i) {
                String string;
                int n = classArray[i].getModifiers();
                if (Modifier.isPublic(n)) continue;
                object2 = classArray[i].getName();
                int n2 = ((String)object2).lastIndexOf(46);
                String string2 = string = n2 == -1 ? "" : ((String)object2).substring(0, n2 + 1);
                if (hashMap == null) {
                    hashMap = string;
                    continue;
                }
                if (string.equals(hashMap)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (hashMap == null) {
                hashMap = "sun.proxy.";
            }
            object2 = nextUniqueNumberLock;
            synchronized (object2) {
                l = nextUniqueNumber++;
            }
            object2 = (String)((Object)hashMap) + proxyClassNamePrefix + l;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)object2, classArray);
            try {
                clazz = Proxy.defineClass0(classLoader, (String)object2, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
            proxyClasses.put(clazz, null);
        }
        finally {
            hashMap = hashMap2;
            synchronized (hashMap) {
                if (clazz != null) {
                    hashMap2.put(list, new WeakReference<Class>(clazz));
                } else {
                    hashMap2.remove(list);
                }
                hashMap2.notifyAll();
            }
        }
        return clazz;
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = Proxy.getProxyClass0(classLoader, classArray);
        try {
            final Constructor<?> constructor = clazz.getConstructor(constructorParams);
            final InvocationHandler invocationHandler2 = invocationHandler;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && ProxyAccessHelper.needsNewInstanceCheck(clazz)) {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return Proxy.newInstance(constructor, invocationHandler2);
                    }
                });
            }
            return Proxy.newInstance(constructor, invocationHandler2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
    }

    private static Object newInstance(Constructor<?> constructor, InvocationHandler invocationHandler) {
        try {
            return constructor.newInstance(invocationHandler);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InternalError(throwable.toString());
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    private static class ProxyAccessHelper {
        static final Permission PROXY_PERMISSION = new ReflectPermission("proxyConstructorNewInstance");
        static final boolean allowNewInstance = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNewInstance");
        static final boolean allowNullLoader = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNullLoader");

        private ProxyAccessHelper() {
        }

        private static boolean getBooleanProperty(final String string) {
            String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(string);
                }
            });
            return Boolean.valueOf(string2);
        }

        static boolean needsNewInstanceCheck(Class<?> clazz) {
            if (!Proxy.isProxyClass(clazz) || allowNewInstance) {
                return false;
            }
            if (clazz.getName().startsWith("sun.proxy.")) {
                return false;
            }
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (Modifier.isPublic(clazz2.getModifiers())) continue;
                return true;
            }
            return false;
        }
    }
}

