/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import sun.invoke.WrapperInstance;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class MethodHandleProxies {
    private MethodHandleProxies() {
    }

    public static <T> T asInterfaceInstance(final Class<T> clazz, final MethodHandle methodHandle) {
        Object object;
        Object object2;
        Object object3;
        MethodHandle[] methodHandleArray;
        Object object4;
        if (!clazz.isInterface() || !Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("not a public interface: " + clazz.getName());
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object4 = Reflection.getCallerClass(2);
            methodHandleArray = object4.getClassLoader();
            ReflectUtil.checkProxyPackageAccess((ClassLoader)methodHandleArray, clazz);
        }
        if ((object3 = clazz.getClassLoader()) == null) {
            object4 = Thread.currentThread().getContextClassLoader();
            Object object5 = object3 = object4 != null ? object4 : ClassLoader.getSystemClassLoader();
        }
        if ((object4 = MethodHandleProxies.getSingleNameMethods(clazz)) == null) {
            throw new IllegalArgumentException("not a single-method interface: " + clazz.getName());
        }
        methodHandleArray = new MethodHandle[((Method[])object4).length];
        for (int i = 0; i < ((Method[])object4).length; ++i) {
            object2 = object4[i];
            object = MethodType.methodType(((Method)object2).getReturnType(), ((Method)object2).getParameterTypes());
            MethodHandle methodHandle2 = methodHandle.asType((MethodType)object);
            methodHandle2 = methodHandle2.asType(methodHandle2.type().changeReturnType(Object.class));
            methodHandleArray[i] = methodHandle2.asSpreader(Object[].class, ((MethodType)object).parameterCount());
        }
        InvocationHandler invocationHandler = new InvocationHandler((Method[])object4, methodHandleArray){
            final /* synthetic */ Method[] val$methods;
            final /* synthetic */ MethodHandle[] val$vaTargets;
            {
                this.val$methods = methodArray;
                this.val$vaTargets = methodHandleArray;
            }

            private Object getArg(String string) {
                if (string == "getWrapperInstanceTarget") {
                    return methodHandle;
                }
                if (string == "getWrapperInstanceType") {
                    return clazz;
                }
                throw new AssertionError();
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                for (int i = 0; i < this.val$methods.length; ++i) {
                    if (!method.equals(this.val$methods[i])) continue;
                    return this.val$vaTargets[i].invokeExact(objectArray);
                }
                if (method.getDeclaringClass() == WrapperInstance.class) {
                    return this.getArg(method.getName());
                }
                if (MethodHandleProxies.isObjectMethod(method)) {
                    return MethodHandleProxies.callObjectMethod(this, method, objectArray);
                }
                throw new InternalError("bad proxy method: " + method);
            }
        };
        if (securityManager != null) {
            object = object3;
            object2 = AccessController.doPrivileged(new PrivilegedAction<Object>((ClassLoader)object, clazz, invocationHandler){
                final /* synthetic */ ClassLoader val$loader;
                final /* synthetic */ Class val$intfc;
                final /* synthetic */ InvocationHandler val$ih;
                {
                    this.val$loader = classLoader;
                    this.val$intfc = clazz;
                    this.val$ih = invocationHandler;
                }

                @Override
                public Object run() {
                    return Proxy.newProxyInstance(this.val$loader, new Class[]{this.val$intfc, WrapperInstance.class}, this.val$ih);
                }
            });
        } else {
            object2 = Proxy.newProxyInstance((ClassLoader)object3, new Class[]{clazz, WrapperInstance.class}, invocationHandler);
        }
        return clazz.cast(object2);
    }

    public static boolean isWrapperInstance(Object object) {
        return object instanceof WrapperInstance;
    }

    private static WrapperInstance asWrapperInstance(Object object) {
        try {
            if (object != null) {
                return (WrapperInstance)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalArgumentException("not a wrapper instance");
    }

    public static MethodHandle wrapperInstanceTarget(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceTarget();
    }

    public static Class<?> wrapperInstanceType(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceType();
    }

    private static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                return method.getReturnType() == String.class && method.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
            }
            case "equals": {
                return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private static Object callObjectMethod(Object object, Method method, Object[] objectArray) {
        assert (MethodHandleProxies.isObjectMethod(method)) : method;
        switch (method.getName()) {
            case "toString": {
                return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
            }
            case "hashCode": {
                return System.identityHashCode(object);
            }
            case "equals": {
                return object == objectArray[0];
            }
        }
        return null;
    }

    private static Method[] getSingleNameMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        String string = null;
        for (Method method : clazz.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(method) || !Modifier.isAbstract(method.getModifiers())) continue;
            String string2 = method.getName();
            if (string == null) {
                string = string2;
            } else if (!string.equals(string2)) {
                return null;
            }
            arrayList.add(method);
        }
        if (string == null) {
            return null;
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }
}

