/*
 * Decompiled with CFR 0.152.
 */
package com.faceplusplus.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static String PRE_NAME = "com_megvii_api";
    private static String sdk_name = "FacePlusPlus Offline SDK (Android-0.9)";
    private static String offileServer = "http://offlinelog.faceplusplus.com/log/newlog";

    public static byte[] getByteArrayFromBitmap(Bitmap bitmap) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
        byte[] ret = bos.toByteArray();
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    private static String getLogString(Context context) throws JSONException {
        SharedPreferences sp = context.getSharedPreferences(PRE_NAME, 0);
        JSONObject jo = new JSONObject();
        jo.put("app_name", (Object)context.getPackageName());
        jo.put("sdk_name", (Object)sdk_name);
        jo.put("device_id", (Object)Utils.getImei(context));
        jo.put("mac_addr", (Object)Utils.getUUID(context));
        JSONObject deviceinfo = new JSONObject();
        deviceinfo.put("cpu", (Object)Utils.getCpuInfo(context));
        deviceinfo.put("os", (Object)("android_" + Build.VERSION.SDK_INT));
        jo.put("device_info", (Object)deviceinfo);
        jo.put("ip_addr", (Object)Utils.getLocalIpAddress());
        jo.put("timestamp", System.currentTimeMillis() / 1000L);
        JSONObject staticcount = new JSONObject();
        staticcount.put("count", sp.getInt("ST", 0));
        staticcount.put("success", sp.getInt("SS", 0));
        JSONObject dynamiccount = new JSONObject();
        dynamiccount.put("count", sp.getInt("DT", 0));
        dynamiccount.put("success", sp.getInt("DS", 0));
        if (sp.getInt("DT", 0) + sp.getInt("ST", 0) == 0) {
            return null;
        }
        JSONObject method = new JSONObject();
        method.put("detect_static", (Object)staticcount);
        method.put("detect_dynamic", (Object)dynamiccount);
        JSONObject callinfo = new JSONObject();
        callinfo.put("method", (Object)method);
        jo.put("call_info", (Object)callinfo);
        return jo.toString();
    }

    private static String getUUID(Context context) {
        SharedPreferences sp = context.getSharedPreferences(PRE_NAME, 0);
        if (sp.contains("uuid")) {
            return sp.getString("uuid", "");
        }
        String uuid = UUID.randomUUID().toString();
        Utils.saveString(sp, "uuid", uuid);
        return uuid;
    }

    private static String getImei(Context context) {
        SharedPreferences sp = context.getSharedPreferences(PRE_NAME, 0);
        if (sp.contains("imei")) {
            return sp.getString("imei", "");
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String imei = tm.getDeviceId();
        Utils.saveString(sp, "imei", imei);
        return imei;
    }

    private static String getCpuInfo(Context context) {
        SharedPreferences sp = context.getSharedPreferences(PRE_NAME, 0);
        if (sp.contains("cpuinfo")) {
            return sp.getString("cpuinfo", "");
        }
        String str1 = "/proc/cpuinfo";
        String str2 = "";
        String[] cpuInfo = new String[]{"", ""};
        try {
            FileReader fr = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(fr, 8192);
            str2 = localBufferedReader.readLine();
            String[] arrayOfString = str2.split("\\s+");
            int i = 2;
            while (i < arrayOfString.length) {
                cpuInfo[0] = String.valueOf(cpuInfo[0]) + arrayOfString[i] + " ";
                ++i;
            }
            str2 = localBufferedReader.readLine();
            arrayOfString = str2.split("\\s+");
            cpuInfo[1] = String.valueOf(cpuInfo[1]) + arrayOfString[2];
            localBufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Utils.saveString(sp, "cpuinfo", cpuInfo[0]);
        return cpuInfo[0];
    }

    private static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            Log.e((String)"WifiPreference IpAddress", (String)ex.toString());
        }
        return null;
    }

    private static void saveString(SharedPreferences sp, String key, String value) {
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(key, value);
        editor.commit();
    }

    private static void clearAll(Context context) {
        SharedPreferences sp = context.getSharedPreferences(PRE_NAME, 0);
        SharedPreferences.Editor edit = sp.edit();
        edit.putInt("DT", 0);
        edit.putInt("DS", 0);
        edit.putInt("ST", 0);
        edit.putInt("SS", 0);
        edit.putLong("lastupdate", System.currentTimeMillis());
        edit.commit();
    }

    public static synchronized void saveLog(Context context, int DT, int DS, int ST, int SS) {
        SharedPreferences sp = context.getSharedPreferences(PRE_NAME, 0);
        SharedPreferences.Editor edit = sp.edit();
        edit.putInt("DT", DT + sp.getInt("DT", 0));
        edit.putInt("DS", DS + sp.getInt("DS", 0));
        edit.putInt("ST", ST + sp.getInt("ST", 0));
        edit.putInt("SS", SS + sp.getInt("SS", 0));
        edit.commit();
    }

    public static void syncLog(final Context context, final String id, final String secret) {
        new Thread(){

            @Override
            public void run() {
                try {
                    JSONObject jo;
                    String log = Utils.getLogString(context);
                    if (log == null) {
                        return;
                    }
                    HttpPost httpPost = new HttpPost(offileServer);
                    long timestamp = System.currentTimeMillis() / 1000L;
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("partner_id", id));
                    params.add(new BasicNameValuePair("timestamp", String.valueOf(timestamp)));
                    params.add(new BasicNameValuePair("serial", Utils.getSerial(id, secret, timestamp)));
                    params.add(new BasicNameValuePair("log", Utils.getLogString(context)));
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                    HttpResponse httpResponse = new DefaultHttpClient().execute((HttpUriRequest)httpPost);
                    if (httpResponse.getStatusLine().getStatusCode() == 200 && (jo = Utils.getJSONFromHttpEntity(httpResponse.getEntity())).getInt("status") == 1) {
                        Utils.clearAll(context);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private static JSONObject getJSONFromHttpEntity(HttpEntity entity) throws IllegalStateException, JSONException {
        StringBuilder sb;
        block12: {
            BufferedReader br = null;
            sb = new StringBuilder();
            try {
                try {
                    String tmp;
                    br = new BufferedReader(new InputStreamReader(entity.getContent()));
                    while ((tmp = br.readLine()) != null) {
                        sb.append(String.valueOf(tmp) + "\n");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new JSONObject(sb.toString());
    }

    private static String getSerial(String key, String secret, long timestamp) {
        return Utils.MD5(String.valueOf(key) + secret + timestamp);
    }

    public static String MD5(String str) {
        if (str == null) {
            return null;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        char[] charArray = str.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        int i = 0;
        while (i < charArray.length) {
            byteArray[i] = (byte)charArray[i];
            ++i;
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        int i2 = 0;
        while (i2 < md5Bytes.length) {
            int val = md5Bytes[i2] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
            ++i2;
        }
        return hexValue.toString();
    }
}

