/*
 * Decompiled with CFR 0.152.
 */
package com.faceplusplus.api;

import android.content.Context;
import android.graphics.Bitmap;
import com.faceplusplus.api.Native;
import com.faceplusplus.api.Utils;
import org.json.JSONArray;

public class FaceDetecter {
    private int mDTHandle;
    private int mDTResult;
    private boolean isTracking = false;
    private Logger mLogger = new Logger();
    private String apikey;
    private String logkey = "5mizjzcsify5094mocb4";
    private String apisecret = "jsia8vbx8de5yvak46vdwqe5i9cx32b3";
    private Bitmap bitmap;
    private Face[] faceinfo;

    public boolean init(Context context, String apiKey) {
        this.apikey = apiKey;
        System.loadLibrary("faceppapi");
        System.loadLibrary("offlineapi");
        int ret = Native.init(context, Utils.MD5(Utils.MD5(Utils.MD5(this.apikey))));
        if (ret != 0) {
            return false;
        }
        this.mLogger.syncLog(context);
        this.mDTHandle = Native.createDTHandle();
        if (this.mDTHandle == 0) {
            return false;
        }
        this.mDTResult = Native.createDTResult();
        if (this.mDTResult == 0) {
            Native.release(context, this.mDTHandle, this.mDTResult);
            return false;
        }
        return true;
    }

    public boolean release(Context context) {
        Native.release(context, this.mDTHandle, this.mDTResult);
        this.mLogger.saveLog(context);
        this.mDTHandle = 0;
        this.mDTResult = 0;
        return true;
    }

    public int setTrackingMode(boolean inTracking) {
        this.isTracking = inTracking;
        int ret = 0;
        ret = Native.setTrackingMode(this.mDTHandle, inTracking);
        return ret;
    }

    public int setMinFaceSize(int minFaceSize) {
        return Native.setMinFaceSize(this.mDTHandle, minFaceSize);
    }

    public int setHighAccuracy(boolean highAccuracy) {
        int ret = 0;
        ret = Native.setHighAccuracy(this.mDTHandle, highAccuracy);
        return ret;
    }

    public Face[] findFaces(byte[] gray, int width, int height) {
        if (this.mDTHandle == 0 || this.mDTResult == 0) {
            return null;
        }
        float[] nativefaceinfo = Native.detectFaceFromGraybyte(this.mDTHandle, this.mDTResult, gray, width, height);
        this.mLogger.updateCount(this.isTracking, true);
        if (nativefaceinfo == null || nativefaceinfo.length % 5 != 0) {
            return null;
        }
        Face[] faceinfo = new Face[nativefaceinfo.length / 5];
        int i = 0;
        while (i < faceinfo.length) {
            Face tmp = new Face();
            tmp.initial((int)nativefaceinfo[i * 5 + 4], nativefaceinfo[i * 5], nativefaceinfo[i * 5 + 1], nativefaceinfo[i * 5 + 2], nativefaceinfo[i * 5 + 3]);
            faceinfo[i] = tmp;
            ++i;
        }
        return faceinfo;
    }

    public Face[] findFaces(Bitmap bitmap) {
        this.faceinfo = null;
        this.bitmap = bitmap;
        if (this.mDTHandle == 0 || this.mDTResult == 0) {
            return null;
        }
        float[] nativefaceinfo = Native.detectFaceFromBitmap(this.mDTHandle, this.mDTResult, bitmap);
        this.mLogger.updateCount(this.isTracking, true);
        if (nativefaceinfo == null || nativefaceinfo.length % 5 != 0) {
            return null;
        }
        this.faceinfo = new Face[nativefaceinfo.length / 5];
        int i = 0;
        while (i < this.faceinfo.length) {
            Face tmp = new Face();
            tmp.initial((int)nativefaceinfo[i * 5 + 4], nativefaceinfo[i * 5], nativefaceinfo[i * 5 + 1], nativefaceinfo[i * 5 + 2], nativefaceinfo[i * 5 + 3]);
            this.faceinfo[i] = tmp;
            ++i;
        }
        return this.faceinfo;
    }

    public byte[] getImageByteArray() {
        float scale;
        if (this.bitmap == null) {
            return null;
        }
        float f = scale = this.bitmap.getWidth() > this.bitmap.getHeight() ? (float)this.bitmap.getWidth() / 600.0f : (float)this.bitmap.getHeight() / 600.0f;
        if (scale > 1.0f) {
            this.bitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)((int)((float)this.bitmap.getWidth() / scale)), (int)((int)((float)this.bitmap.getHeight() / scale)), (boolean)true);
        }
        return Utils.getByteArrayFromBitmap(this.bitmap);
    }

    public String getResultJsonString() {
        if (this.bitmap == null || this.faceinfo == null) {
            return null;
        }
        int width = this.bitmap.getWidth();
        int height = this.bitmap.getHeight();
        JSONArray faces = new JSONArray();
        Face[] faceArray = this.faceinfo;
        int n = this.faceinfo.length;
        int n2 = 0;
        while (n2 < n) {
            Face face = faceArray[n2];
            JSONArray ja = new JSONArray();
            ja.put((int)((float)width * face.left));
            ja.put((int)((float)height * face.top));
            ja.put((int)((float)width * (face.right - face.left)));
            ja.put((int)((float)height * (face.bottom - face.top)));
            faces.put((Object)ja);
            ++n2;
        }
        return faces.toString();
    }

    public static class Face {
        public int trackingID;
        public float left;
        public float top;
        public float right;
        public float bottom;

        public void initial(int trackingId, float left, float top, float right, float bottom) {
            this.trackingID = trackingId;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    private class Logger {
        private int mDTotalCount;
        private int mDSuccessCount;
        private int mSTtotalCount;
        private int mSSuccessCount;

        void updateCount(boolean isTracking, boolean isSuccess) {
            if (isTracking) {
                ++this.mDTotalCount;
                this.mDSuccessCount += isSuccess ? 1 : 0;
            } else {
                ++this.mSTtotalCount;
                this.mSSuccessCount += isSuccess ? 1 : 0;
            }
        }

        void saveLog(Context context) {
            Utils.saveLog(context, this.mDTotalCount, this.mDSuccessCount, this.mSTtotalCount, this.mSSuccessCount);
        }

        void syncLog(Context context) {
            Utils.syncLog(context, FaceDetecter.this.logkey, FaceDetecter.this.apisecret);
        }
    }
}

