/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u5706\u5f62\u56fe\u7247\u6846\u7c7b\u5e93;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundImageView
extends ImageView {
    private Context mContext;
    private int mBorderThickness = 0;
    private int mBorderOutsideColor = 0;
    private int defaultWidth = 0;
    private int defaultHeight = 0;

    public RoundImageView(Context context) {
        super(context);
        this.mContext = context;
    }

    public RoundImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public RoundImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
    }

    public void setCustomAttributes(int n, int n2) {
        this.mBorderThickness = n;
        this.mBorderOutsideColor = n2;
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.measure(0, 0);
        if (drawable.getClass() == NinePatchDrawable.class) {
            return;
        }
        Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
        Bitmap bitmap2 = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        if (this.defaultWidth == 0) {
            this.defaultWidth = this.getWidth();
        }
        if (this.defaultHeight == 0) {
            this.defaultHeight = this.getHeight();
        }
        int n = 0;
        if (this.mBorderThickness > 0) {
            n = (this.defaultWidth < this.defaultHeight ? this.defaultWidth : this.defaultHeight) / 2 - this.mBorderThickness;
            this.drawCircleBorder(canvas, n + this.mBorderThickness / 2, this.mBorderOutsideColor);
        } else {
            n = (this.defaultWidth < this.defaultHeight ? this.defaultWidth : this.defaultHeight) / 2;
        }
        Bitmap bitmap3 = this.getCroppedRoundBitmap(bitmap2, n);
        canvas.drawBitmap(bitmap3, (float)(this.defaultWidth / 2 - n), (float)(this.defaultHeight / 2 - n), null);
    }

    public Bitmap getCroppedRoundBitmap(Bitmap bitmap, int n) {
        Bitmap bitmap2;
        int n2 = n * 2;
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n4 > n3) {
            n5 = n6 = n3;
            n7 = 0;
            n8 = (n4 - n3) / 2;
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n7, (int)n8, (int)n5, (int)n6);
        } else if (n4 < n3) {
            n5 = n6 = n4;
            n7 = (n3 - n4) / 2;
            n8 = 0;
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n7, (int)n8, (int)n5, (int)n6);
        } else {
            bitmap2 = bitmap;
        }
        Bitmap bitmap3 = bitmap2.getWidth() != n2 || bitmap2.getHeight() != n2 ? Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n2, (int)n2, (boolean)true) : bitmap2;
        Bitmap bitmap4 = Bitmap.createBitmap((int)bitmap3.getWidth(), (int)bitmap3.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap4);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap3.getWidth(), bitmap3.getHeight());
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(bitmap3.getWidth() / 2), (float)(bitmap3.getHeight() / 2), (float)(bitmap3.getWidth() / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap3, rect, rect, paint);
        bitmap = null;
        bitmap2 = null;
        bitmap3 = null;
        return bitmap4;
    }

    private void drawCircleBorder(Canvas canvas, int n, int n2) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        paint.setColor(n2);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)this.mBorderThickness);
        canvas.drawCircle((float)(this.defaultWidth / 2), (float)(this.defaultHeight / 2), (float)n, paint);
    }
}

