/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime;

import android.content.Intent;
import android.net.Uri;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.annotations.SimpleFunction;
import com.e4a.runtime.annotations.SimpleObject;
import com.e4a.runtime.\u4e0a\u4e0b\u6587\u64cd\u4f5c;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

@SimpleObject
public final class \u6587\u4ef6\u64cd\u4f5c {
    static FileInputStream fin;
    static InputStreamReader isr;
    static BufferedReader br;
    static String line;
    static FileOutputStream fout;
    static OutputStreamWriter osw;
    static BufferedWriter bw;

    private \u6587\u4ef6\u64cd\u4f5c() {
    }

    @SimpleFunction
    public static boolean \u4fee\u6539\u6587\u4ef6\u540d(String oldname, String newname) {
        if (newname.equals(oldname)) {
            return true;
        }
        File oldfile = new File(oldname);
        if (!oldfile.exists()) {
            return false;
        }
        File newfile = new File(newname);
        if (newfile.exists()) {
            return false;
        }
        return oldfile.renameTo(newfile);
    }

    @SimpleFunction
    public static boolean \u5220\u9664\u6587\u4ef6(String name) {
        File file = new File(name);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return file.delete();
    }

    @SimpleFunction
    public static boolean \u521b\u5efa\u76ee\u5f55(String path) {
        String[] dir = path.split("/");
        String dist = dir[0];
        boolean result = true;
        if (dir.length > 0) {
            for (int i = 1; i < dir.length; ++i) {
                File mkdir = new File(dist = dist + "/" + dir[i]);
                if (mkdir.exists()) continue;
                result = mkdir.mkdir();
            }
            return result;
        }
        return false;
    }

    @SimpleFunction
    public static boolean \u5220\u9664\u76ee\u5f55(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            return false;
        }
        return \u6587\u4ef6\u64cd\u4f5c.deleteDir(dir);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = \u6587\u4ef6\u64cd\u4f5c.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    @SimpleFunction
    public static boolean \u662f\u5426\u4e3a\u76ee\u5f55(String name) {
        File file = new File(name);
        if (!file.exists()) {
            return false;
        }
        return file.isDirectory();
    }

    @SimpleFunction
    public static boolean \u662f\u5426\u4e3a\u9690\u85cf\u6587\u4ef6(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.isHidden();
        }
        return false;
    }

    @SimpleFunction
    public static boolean \u6587\u4ef6\u662f\u5426\u5b58\u5728(String name) {
        return new File(name).exists();
    }

    @SimpleFunction
    public static String \u53d6\u6587\u4ef6\u7f16\u7801(String filename) {
        File file = new File(filename);
        String charset = "";
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fis);
            in.mark(4);
            byte[] first3bytes = new byte[3];
            in.read(first3bytes);
            in.reset();
            charset = first3bytes[0] == -17 && first3bytes[1] == -69 && first3bytes[2] == -65 ? "utf-8" : (first3bytes[0] == -1 && first3bytes[1] == -2 ? "unicode" : (first3bytes[0] == -2 && first3bytes[1] == -1 ? "utf-16be" : (first3bytes[0] == -1 && first3bytes[1] == -1 ? "utf-16le" : "GBK")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return charset;
    }

    @SimpleFunction
    public static String \u8bfb\u5165\u6587\u672c\u6587\u4ef6(String filename, String charset) {
        String res = "";
        if (new File(filename).exists()) {
            try {
                FileInputStream fin = new FileInputStream(filename);
                int length = fin.available();
                byte[] buffer = new byte[length];
                fin.read(buffer);
                res = new String(buffer, 0, length, charset);
                fin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    @SimpleFunction
    public static boolean \u5199\u51fa\u6587\u672c\u6587\u4ef6(String filename, String message, String charset) {
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            byte[] bytes = message.getBytes(charset);
            fout.write(bytes);
            fout.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @SimpleFunction
    public static byte[] \u8bfb\u5165\u5b57\u8282\u6587\u4ef6(String filename) {
        byte[] buffer = null;
        if (new File(filename).exists()) {
            try {
                FileInputStream fin = new FileInputStream(filename);
                int length = fin.available();
                buffer = new byte[length];
                fin.read(buffer);
                fin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return buffer;
    }

    @SimpleFunction
    public static boolean \u5199\u51fa\u5b57\u8282\u6587\u4ef6(String filename, byte[] bytes) {
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            fout.write(bytes);
            fout.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @SimpleFunction
    public static long \u53d6\u6587\u4ef6\u5c3a\u5bf8(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? \u6587\u4ef6\u64cd\u4f5c.getFileSizes(file) : \u6587\u4ef6\u64cd\u4f5c.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return blockSize;
    }

    private static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
        }
        return size;
    }

    private static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += \u6587\u4ef6\u64cd\u4f5c.getFileSizes(flist[i]);
                continue;
            }
            size += \u6587\u4ef6\u64cd\u4f5c.getFileSize(flist[i]);
        }
        return size;
    }

    @SimpleFunction
    public static String \u8bfb\u5165\u8d44\u6e90\u6587\u4ef6(String filename, String charset) {
        String res = "";
        try {
            InputStream inputstream = \u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getAssets().open(filename);
            if (inputstream == null) {
                return "";
            }
            int length = inputstream.available();
            byte[] buffer = new byte[length];
            inputstream.read(buffer);
            res = new String(buffer, 0, length, charset);
            inputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return res;
    }

    @SimpleFunction
    public static byte[] \u8bfb\u5165\u8d44\u6e90\u6587\u4ef62(String filename) {
        byte[] buffer = null;
        try {
            InputStream inputstream = \u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getAssets().open(filename);
            if (inputstream != null) {
                int length = inputstream.available();
                buffer = new byte[length];
                inputstream.read(buffer);
                inputstream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return buffer;
    }

    @SimpleFunction
    public static boolean \u5199\u51fa\u8d44\u6e90\u6587\u4ef6(String filename, String outFileName) {
        try {
            InputStream stream = \u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getAssets().open(filename);
            if (stream == null) {
                return false;
            }
            File file = new File(outFileName);
            if (!\u6587\u4ef6\u64cd\u4f5c.writeStreamToFile(stream, file)) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeStreamToFile(InputStream stream, File file) {
        FileOutputStream output = null;
        try {
            int read;
            output = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, read);
            }
            output.flush();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                ((OutputStream)output).close();
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @SimpleFunction
    public static String \u5bfb\u627e\u6587\u4ef6\u5173\u952e\u8bcd(String Path2, String keyword) {
        File[] files;
        String result = "";
        for (File f : files = new File(Path2).listFiles()) {
            if (f.getName().indexOf(keyword) < 0) continue;
            result = f.getPath() + "\n" + result;
        }
        return result;
    }

    @SimpleFunction
    public static String \u5bfb\u627e\u6587\u4ef6\u540e\u7f00\u540d(String Path2, String Extension) {
        File[] files;
        String result = "";
        for (File f : files = new File(Path2).listFiles()) {
            if (!f.getPath().substring(f.getPath().length() - Extension.length()).equals(Extension) || f.isDirectory()) continue;
            result = f.getPath() + "\n" + result;
        }
        return result;
    }

    @SimpleFunction
    public static boolean \u590d\u5236\u6587\u4ef6(String sourcePath, String targetPath) {
        if (new File(sourcePath).exists()) {
            try {
                int bytesum = 0;
                int byteread = 0;
                FileInputStream inStream = new FileInputStream(sourcePath);
                FileOutputStream fs = new FileOutputStream(targetPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
                fs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @SimpleFunction
    public static boolean \u521b\u5efa\u6587\u4ef6(String path) {
        boolean result = false;
        File f = new File(path);
        if (!f.exists()) {
            try {
                result = f.createNewFile();
            }
            catch (IOException iOException) {}
        } else {
            result = true;
        }
        return result;
    }

    @SimpleFunction
    public static boolean \u6253\u5f00\u6587\u672c\u6587\u4ef6_\u8bfb(String filename, String charset) {
        if (new File(filename).exists()) {
            try {
                fin = new FileInputStream(filename);
                isr = new InputStreamReader((InputStream)fin, charset);
                br = new BufferedReader(isr);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @SimpleFunction
    public static boolean \u5173\u95ed\u8bfb() {
        try {
            br.close();
            fin.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @SimpleFunction
    public static String \u8bfb\u4e00\u884c() {
        try {
            line = br.readLine();
            if (line != null) {
                return line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @SimpleFunction
    public static boolean \u6253\u5f00\u6587\u672c\u6587\u4ef6_\u5199(String filename, String charset) {
        if (new File(filename).exists()) {
            try {
                fout = new FileOutputStream(filename);
                osw = new OutputStreamWriter((OutputStream)fout, charset);
                bw = new BufferedWriter(osw);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @SimpleFunction
    public static boolean \u5173\u95ed\u5199() {
        try {
            bw.close();
            fout.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @SimpleFunction
    public static boolean \u5199\u4e00\u884c(String message) {
        try {
            bw.newLine();
            bw.write(message);
            bw.flush();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @SimpleFunction
    public static String \u53d6\u5b50\u76ee\u5f55(String dir) {
        String pa = "";
        File f = new File(dir);
        File[] ff = f.listFiles();
        for (int i = 0; i < ff.length; ++i) {
            if (!ff[i].isDirectory()) continue;
            pa = pa + ff[i].getAbsolutePath() + "|";
        }
        return pa;
    }

    @SimpleFunction
    public static String \u53d6\u6587\u4ef6\u4fee\u6539\u65f6\u95f4(String path) {
        File f = new File(path);
        long time = f.lastModified();
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String modifiedtime = format.format(date);
        return modifiedtime;
    }

    @SimpleFunction
    public static void \u6253\u5f00\u6587\u4ef6(String Path2) {
        mainActivity.getContext().startActivity(\u6587\u4ef6\u64cd\u4f5c.openFile(Path2));
    }

    private static Intent openFile(String filePath) {
        File file = new File(filePath);
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        String end = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length()).toLowerCase();
        if (end.equals("m4a") || end.equals("mp3") || end.equals("mid") || end.equals("xmf") || end.equals("ogg") || end.equals("wav")) {
            return \u6587\u4ef6\u64cd\u4f5c.getAudioFileIntent(filePath);
        }
        if (end.equals("3gp") || end.equals("mp4")) {
            return \u6587\u4ef6\u64cd\u4f5c.getVideoFileIntent(filePath);
        }
        if (end.equals("jpg") || end.equals("gif") || end.equals("png") || end.equals("jpeg") || end.equals("bmp")) {
            return \u6587\u4ef6\u64cd\u4f5c.getImageFileIntent(filePath);
        }
        if (end.equals("apk")) {
            return \u6587\u4ef6\u64cd\u4f5c.getApkFileIntent(filePath);
        }
        if (end.equals("ppt")) {
            return \u6587\u4ef6\u64cd\u4f5c.getPptFileIntent(filePath);
        }
        if (end.equals("xls")) {
            return \u6587\u4ef6\u64cd\u4f5c.getExcelFileIntent(filePath);
        }
        if (end.equals("doc")) {
            return \u6587\u4ef6\u64cd\u4f5c.getWordFileIntent(filePath);
        }
        if (end.equals("pdf")) {
            return \u6587\u4ef6\u64cd\u4f5c.getPdfFileIntent(filePath);
        }
        if (end.equals("chm")) {
            return \u6587\u4ef6\u64cd\u4f5c.getChmFileIntent(filePath);
        }
        if (end.equals("txt")) {
            return \u6587\u4ef6\u64cd\u4f5c.getTextFileIntent(filePath, false);
        }
        return \u6587\u4ef6\u64cd\u4f5c.getAllIntent(filePath);
    }

    private static Intent getAllIntent(String param) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "*/*");
        return intent;
    }

    private static Intent getApkFileIntent(String param) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        return intent;
    }

    private static Intent getVideoFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x4000000);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "video/*");
        return intent;
    }

    private static Intent getAudioFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x4000000);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "audio/*");
        return intent;
    }

    private static Intent getHtmlFileIntent(String param) {
        Uri uri = Uri.parse((String)param).buildUpon().encodedAuthority("com.android.htmlfileprovider").scheme("content").encodedPath(param).build();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "text/html");
        return intent;
    }

    private static Intent getImageFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "image/*");
        return intent;
    }

    private static Intent getPptFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
        return intent;
    }

    private static Intent getExcelFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "application/vnd.ms-excel");
        return intent;
    }

    private static Intent getWordFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "application/msword");
        return intent;
    }

    private static Intent getChmFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "application/x-chm");
        return intent;
    }

    private static Intent getTextFileIntent(String param, boolean paramBoolean) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        if (paramBoolean) {
            Uri uri1 = Uri.parse((String)param);
            intent.setDataAndType(uri1, "text/plain");
        } else {
            Uri uri2 = Uri.fromFile((File)new File(param));
            intent.setDataAndType(uri2, "text/plain");
        }
        return intent;
    }

    private static Intent getPdfFileIntent(String param) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromFile((File)new File(param));
        intent.setDataAndType(uri, "application/pdf");
        return intent;
    }

    static {
        line = "";
    }
}

