/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime;

import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import com.e4a.runtime.annotations.SimpleFunction;
import com.e4a.runtime.annotations.SimpleObject;
import com.e4a.runtime.\u4e0a\u4e0b\u6587\u64cd\u4f5c;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;

@SimpleObject
public final class \u5a92\u4f53\u64cd\u4f5c {
    private static MediaPlayer mp;
    private static boolean over;
    private static int MAX_VOLUME;
    private static int Progress;

    private \u5a92\u4f53\u64cd\u4f5c() {
    }

    @SimpleFunction
    public static void \u64ad\u653e\u97f3\u4e50(String mFile) {
        Progress = 0;
        mp = new MediaPlayer();
        over = false;
        try {
            if (mFile.startsWith("/")) {
                if (new File(mFile).exists()) {
                    mp.setDataSource(mFile);
                }
            } else if (mFile.startsWith("http://")) {
                mp.setDataSource(mFile);
                mp.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

                    public void onBufferingUpdate(MediaPlayer mp, int percent) {
                        \u5a92\u4f53\u64cd\u4f5c.setProgress(percent);
                    }
                });
            } else {
                AssetFileDescriptor aFD = \u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getAssets().openFd(mFile);
                FileDescriptor fileDescriptor = aFD.getFileDescriptor();
                mp.setDataSource(fileDescriptor, aFD.getStartOffset(), aFD.getLength());
                aFD.close();
            }
            mp.prepare();
            mp.start();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                over = true;
                mp.release();
            }
        });
    }

    private static void setProgress(int value) {
        Progress = value;
    }

    @SimpleFunction
    public static int \u53d6\u7f13\u51b2\u8fdb\u5ea6() {
        return Progress;
    }

    @SimpleFunction
    public static void \u7ee7\u7eed\u64ad\u653e() {
        if (!over && mp != null) {
            try {
                mp.start();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SimpleFunction
    public static void \u505c\u6b62\u64ad\u653e() {
        if (!over && mp != null) {
            try {
                over = true;
                mp.stop();
                mp.release();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SimpleFunction
    public static void \u6682\u505c\u64ad\u653e() {
        if (!over && mp != null) {
            try {
                mp.pause();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SimpleFunction
    public static boolean \u53d6\u5faa\u73af\u64ad\u653e() {
        if (!over && mp != null) {
            return mp.isLooping();
        }
        return false;
    }

    @SimpleFunction
    public static void \u7f6e\u5faa\u73af\u64ad\u653e(boolean value) {
        if (!over && mp != null) {
            mp.setLooping(value);
        }
    }

    @SimpleFunction
    public static int \u53d6\u97f3\u4e50\u65f6\u957f() {
        if (!over && mp != null) {
            return mp.getDuration();
        }
        return 0;
    }

    @SimpleFunction
    public static int \u53d6\u64ad\u653e\u4f4d\u7f6e() {
        if (!over && mp != null) {
            return mp.getCurrentPosition();
        }
        return 0;
    }

    @SimpleFunction
    public static void \u7f6e\u64ad\u653e\u4f4d\u7f6e(int value) {
        if (!over && mp != null) {
            mp.seekTo(value);
        }
    }

    @SimpleFunction
    public static void \u7f6e\u64ad\u653e\u97f3\u91cf(int soundVolume) {
        if (!over && mp != null) {
            float volume = (float)(1.0 - Math.log(MAX_VOLUME - soundVolume) / Math.log(MAX_VOLUME));
            mp.setVolume(volume, volume);
        }
    }

    @SimpleFunction
    public static boolean \u53d6\u64ad\u653e\u72b6\u6001() {
        if (!over && mp != null) {
            return mp.isPlaying();
        }
        return false;
    }

    static {
        MAX_VOLUME = 100;
    }
}

