/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.variants;

import com.e4a.runtime.helpers.ConvHelpers;
import com.e4a.runtime.helpers.ExprHelpers;
import com.e4a.runtime.variants.DoubleVariant;
import com.e4a.runtime.variants.Variant;

public final class SingleVariant
extends Variant {
    private float value;

    public static final SingleVariant getSingleVariant(float value) {
        return new SingleVariant(value);
    }

    private SingleVariant(float value) {
        super((byte)6);
        this.value = value;
    }

    public boolean getBoolean() {
        return ConvHelpers.single2boolean(this.value);
    }

    public byte getByte() {
        return ConvHelpers.single2byte(this.value);
    }

    public short getShort() {
        return ConvHelpers.single2short(this.value);
    }

    public int getInteger() {
        return (int)this.value;
    }

    public long getLong() {
        return (long)this.value;
    }

    public float getSingle() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return Float.toString(this.value);
    }

    public Variant add(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return rightOp.add(this);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return SingleVariant.getSingleVariant(this.getSingle() + rightOp.getSingle());
    }

    public Variant sub(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.sub(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return SingleVariant.getSingleVariant(this.getSingle() - rightOp.getSingle());
            }
            case 7: 
            case 8: 
        }
        return DoubleVariant.getDoubleVariant(this.getDouble() - rightOp.getDouble());
    }

    public Variant mul(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return rightOp.mul(this);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return SingleVariant.getSingleVariant(this.getSingle() * rightOp.getSingle());
    }

    public Variant div(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.getDouble()).div(rightOp);
    }

    public Variant idiv(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.idiv(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return SingleVariant.getSingleVariant(ExprHelpers.idiv(this.getSingle(), rightOp.getSingle()));
            }
            case 7: 
            case 8: 
        }
        return DoubleVariant.getDoubleVariant(ExprHelpers.idiv(this.getDouble(), rightOp.getDouble()));
    }

    public Variant mod(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.mod(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return SingleVariant.getSingleVariant(this.getSingle() % rightOp.getSingle());
            }
            case 7: 
            case 8: 
        }
        return DoubleVariant.getDoubleVariant(this.getDouble() % rightOp.getDouble());
    }

    public Variant pow(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(Math.pow(this.getDouble(), rightOp.getDouble()));
    }

    public Variant neg() {
        return SingleVariant.getSingleVariant(-this.value);
    }

    public int cmp(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return -rightOp.cmp(this);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        float rvalue = rightOp.getSingle();
        if (this.value == rvalue) {
            return 0;
        }
        return this.value > rvalue ? 1 : -1;
    }
}

