/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.variants;

import com.e4a.runtime.errors.UnknownIdentifierError;
import com.e4a.runtime.helpers.ConvHelpers;
import com.e4a.runtime.variants.ArrayVariant;
import com.e4a.runtime.variants.BooleanVariant;
import com.e4a.runtime.variants.ByteVariant;
import com.e4a.runtime.variants.DoubleVariant;
import com.e4a.runtime.variants.IntegerVariant;
import com.e4a.runtime.variants.LongVariant;
import com.e4a.runtime.variants.ShortVariant;
import com.e4a.runtime.variants.SingleVariant;
import com.e4a.runtime.variants.StringVariant;
import com.e4a.runtime.variants.UninitializedVariant;
import com.e4a.runtime.variants.Variant;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectVariant
extends Variant {
    private Object value;

    public static final ObjectVariant getObjectVariant(Object value) {
        return new ObjectVariant(value);
    }

    private ObjectVariant(Object value) {
        super((byte)9);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public boolean identical(Variant rightOp) {
        if (rightOp.getKind() != 9) {
            return super.identical(rightOp);
        }
        return this.value == rightOp.getObject();
    }

    private Object convertVariant(Class<?> type, Variant variant) {
        if (type.isArray()) {
            return variant.getArray();
        }
        if (type == Boolean.TYPE) {
            return variant.getBoolean();
        }
        if (type == Byte.TYPE) {
            return variant.getByte();
        }
        if (type == Short.TYPE) {
            return variant.getShort();
        }
        if (type == Integer.TYPE) {
            return variant.getInteger();
        }
        if (type == Long.TYPE) {
            return variant.getLong();
        }
        if (type == Float.TYPE) {
            return Float.valueOf(variant.getSingle());
        }
        if (type == Double.TYPE) {
            return variant.getDouble();
        }
        if (type == String.class) {
            return variant.getString();
        }
        return variant.getObject();
    }

    private Variant convertObject(Class<?> type, Object object) {
        if (type == Void.TYPE) {
            return UninitializedVariant.getUninitializedVariant();
        }
        if (type == Boolean.TYPE) {
            return BooleanVariant.getBooleanVariant((Boolean)object);
        }
        if (type == Byte.TYPE) {
            return ByteVariant.getByteVariant(ConvHelpers.integer2byte(((Byte)object).intValue()));
        }
        if (type == Short.TYPE) {
            return ShortVariant.getShortVariant(ConvHelpers.integer2short(((Short)object).intValue()));
        }
        if (type == Integer.TYPE) {
            return IntegerVariant.getIntegerVariant((Integer)object);
        }
        if (type == Long.TYPE) {
            return LongVariant.getLongVariant((Long)object);
        }
        if (type == Float.TYPE) {
            return SingleVariant.getSingleVariant(((Float)object).floatValue());
        }
        if (type == Double.TYPE) {
            return DoubleVariant.getDoubleVariant((Double)object);
        }
        if (type == String.class) {
            return StringVariant.getStringVariant((String)object);
        }
        if (type.isArray()) {
            return ArrayVariant.getArrayVariant(object);
        }
        return ObjectVariant.getObjectVariant(object);
    }

    private Object[] convertArguments(Class<?>[] argTypes, Variant[] args) {
        int len = argTypes.length;
        Object[] objArgs = new Object[len];
        for (int i = 0; i < len; ++i) {
            objArgs[i] = this.convertVariant(argTypes[i], args[i]);
        }
        return objArgs;
    }

    @Override
    public Variant function(String name, Variant[] args) {
        Class<?> type = this.value.getClass();
        for (Method method : type.getMethods()) {
            Class<?>[] argTypes;
            if (!method.getName().equals(name) || (argTypes = method.getParameterTypes()).length != args.length) continue;
            Object[] convertedArgs = this.convertArguments(argTypes, args);
            Object result = null;
            try {
                result = method.invoke(this.value, convertedArgs);
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException ite) {
                throw new UnknownIdentifierError();
            }
            return this.convertObject(method.getReturnType(), result);
        }
        throw new UnknownIdentifierError();
    }

    @Override
    public Variant dataMember(String name) {
        Class<?> type = this.value.getClass();
        try {
            Field field = type.getField(name);
            return this.convertObject(field.getType(), field.get(this.value));
        }
        catch (NoSuchFieldException nsfe) {
            return this.function(name, new Variant[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public void dataMember(String name, Variant variant) {
        Class<?> type = this.value.getClass();
        try {
            Field field = type.getField(name);
            field.set(this.value, this.convertVariant(field.getType(), variant));
        }
        catch (NoSuchFieldException nsfe) {
            this.function(name, new Variant[]{variant});
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
    }
}

