/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.variants;

import com.e4a.runtime.helpers.ConvHelpers;
import com.e4a.runtime.helpers.ExprHelpers;
import com.e4a.runtime.variants.Variant;

public final class DoubleVariant
extends Variant {
    private double value;

    public static final DoubleVariant getDoubleVariant(double value) {
        return new DoubleVariant(value);
    }

    private DoubleVariant(double value) {
        super((byte)7);
        this.value = value;
    }

    public boolean getBoolean() {
        return ConvHelpers.double2boolean(this.value);
    }

    public byte getByte() {
        return ConvHelpers.double2byte(this.value);
    }

    public short getShort() {
        return ConvHelpers.double2short(this.value);
    }

    public int getInteger() {
        return (int)this.value;
    }

    public long getLong() {
        return (long)this.value;
    }

    public float getSingle() {
        return (float)this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return Double.toString(this.value);
    }

    public Variant add(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.value + rightOp.getDouble());
    }

    public Variant sub(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.value - rightOp.getDouble());
    }

    public Variant mul(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.value * rightOp.getDouble());
    }

    public Variant div(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.value / rightOp.getDouble());
    }

    public Variant idiv(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(ExprHelpers.idiv(this.value, rightOp.getDouble()));
    }

    public Variant mod(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.value % rightOp.getDouble());
    }

    public Variant pow(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(Math.pow(this.value, rightOp.getDouble()));
    }

    public Variant neg() {
        return DoubleVariant.getDoubleVariant(-this.value);
    }

    public int cmp(Variant rightOp) {
        double rightValue = rightOp.getDouble();
        if (this.value == rightValue) {
            return 0;
        }
        return this.value > rightValue ? 1 : -1;
    }
}

