/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.variants;

import com.e4a.runtime.helpers.ConvHelpers;
import com.e4a.runtime.helpers.ExprHelpers;
import com.e4a.runtime.variants.DoubleVariant;
import com.e4a.runtime.variants.IntegerVariant;
import com.e4a.runtime.variants.LongVariant;
import com.e4a.runtime.variants.SingleVariant;
import com.e4a.runtime.variants.Variant;

public final class ByteVariant
extends Variant {
    private byte value;

    public static final ByteVariant getByteVariant(byte value) {
        return new ByteVariant(value);
    }

    private ByteVariant(byte value) {
        super((byte)2);
        this.value = value;
    }

    public boolean getBoolean() {
        return this.value != 0;
    }

    public byte getByte() {
        return this.value;
    }

    public short getShort() {
        return (short)ConvHelpers.byte2integer(this.value);
    }

    public int getInteger() {
        return ConvHelpers.byte2integer(this.value);
    }

    public long getLong() {
        return ConvHelpers.byte2integer(this.value);
    }

    public float getSingle() {
        return ConvHelpers.byte2integer(this.value);
    }

    public double getDouble() {
        return ConvHelpers.byte2integer(this.value);
    }

    public String getString() {
        return Integer.toString(ConvHelpers.byte2integer(this.value));
    }

    public Variant add(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return rightOp.add(this);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return IntegerVariant.getIntegerVariant(this.getInteger() + rightOp.getInteger());
    }

    public Variant sub(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.sub(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() - rightOp.getInteger());
            }
            case 5: {
                return LongVariant.getLongVariant(this.getLong() - rightOp.getLong());
            }
            case 6: {
                return SingleVariant.getSingleVariant(this.getSingle() - rightOp.getSingle());
            }
            case 7: 
            case 8: 
        }
        return DoubleVariant.getDoubleVariant(this.getDouble() - rightOp.getDouble());
    }

    public Variant mul(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return rightOp.mul(this);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return IntegerVariant.getIntegerVariant(this.getInteger() * rightOp.getInteger());
    }

    public Variant div(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.getDouble()).div(rightOp);
    }

    public Variant idiv(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.idiv(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() / rightOp.getInteger());
            }
            case 5: {
                return LongVariant.getLongVariant(this.getLong() / rightOp.getLong());
            }
            case 6: {
                return SingleVariant.getSingleVariant(ExprHelpers.idiv(this.getSingle(), rightOp.getSingle()));
            }
            case 7: 
            case 8: 
        }
        return DoubleVariant.getDoubleVariant(ExprHelpers.idiv(this.getDouble(), rightOp.getDouble()));
    }

    public Variant mod(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.mod(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() % rightOp.getInteger());
            }
            case 5: {
                return LongVariant.getLongVariant(this.getLong() % rightOp.getLong());
            }
            case 6: {
                return SingleVariant.getSingleVariant(this.getSingle() % rightOp.getSingle());
            }
            case 7: 
            case 8: 
        }
        return DoubleVariant.getDoubleVariant(this.getDouble() % rightOp.getDouble());
    }

    public Variant pow(Variant rightOp) {
        return DoubleVariant.getDoubleVariant(this.getDouble()).pow(rightOp);
    }

    public Variant neg() {
        return ByteVariant.getByteVariant(-this.value);
    }

    public Variant shl(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.and(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() << rightOp.getInteger());
            }
            case 5: 
            case 8: 
        }
        return LongVariant.getLongVariant(this.getLong() << (int)rightOp.getLong());
    }

    public Variant shr(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.and(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() >> rightOp.getInteger());
            }
            case 5: 
            case 8: 
        }
        return LongVariant.getLongVariant(this.getLong() >> (int)rightOp.getLong());
    }

    public int cmp(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return -rightOp.cmp(this);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return this.getInteger() - rightOp.getInteger();
    }

    public Variant not() {
        return ByteVariant.getByteVariant(~this.value);
    }

    public Variant and(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.and(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() & rightOp.getInteger());
            }
            case 5: 
            case 8: 
        }
        return LongVariant.getLongVariant(this.getLong() & rightOp.getLong());
    }

    public Variant or(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.or(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() | rightOp.getInteger());
            }
            case 5: 
            case 8: 
        }
        return LongVariant.getLongVariant(this.getLong() | rightOp.getLong());
    }

    public Variant xor(Variant rightOp) {
        switch (rightOp.getKind()) {
            default: {
                return super.xor(rightOp);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return IntegerVariant.getIntegerVariant(this.getInteger() ^ rightOp.getInteger());
            }
            case 5: 
            case 8: 
        }
        return LongVariant.getLongVariant(this.getLong() ^ rightOp.getLong());
    }
}

