/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.events;

import com.e4a.runtime.errors.RuntimeError;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventDispatcher {
    private static Map<String, List<EventHandlerClosure>> registry = new HashMap<String, List<EventHandlerClosure>>();

    private EventDispatcher() {
    }

    public static void registerEvent(Object object, String dataMemberName, String eventName) {
        List<EventHandlerClosure> closures = registry.get(eventName);
        if (closures == null) {
            closures = new ArrayList<EventHandlerClosure>();
            registry.put(eventName, closures);
        }
        closures.add(new EventHandlerClosure(object, dataMemberName, eventName));
    }

    public static synchronized void dispatchEvent(Object that, String eventName, Object ... args) {
        List<EventHandlerClosure> closures = registry.get(eventName);
        if (closures != null) {
            for (EventHandlerClosure closure : closures.toArray(new EventHandlerClosure[closures.size()])) {
                if (closure.getDataMemberObject() != that) continue;
                closure.invokeEvent(args);
            }
        }
    }

    private static final class EventHandlerClosure {
        private final Object object;
        private Field dataMember;
        private Method eventHandler;

        EventHandlerClosure(Object object, String dataMemberName, String eventName) {
            this.object = object;
            Class<?> cls = object.getClass();
            for (Method method : cls.getMethods()) {
                if (!method.getName().equals(dataMemberName + '$' + eventName)) continue;
                this.eventHandler = method;
                break;
            }
            try {
                this.dataMember = cls.getField(dataMemberName);
            }
            catch (NoSuchFieldException ignored) {
                // empty catch block
            }
        }

        Object getDataMemberObject() {
            if (this.dataMember == null) {
                return null;
            }
            try {
                return this.dataMember.get(this.object);
            }
            catch (IllegalAccessException ignored) {
                return null;
            }
        }

        void invokeEvent(Object ... args) {
            try {
                this.eventHandler.invoke(this.object, args);
            }
            catch (Throwable t) {
                RuntimeError.convertToRuntimeError(t);
            }
        }
    }
}

