/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n96;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final int MAX_DECODE_PICTURE_SIZE = 2764800;

    public static byte[] bmpToByteArray(Bitmap bmp, boolean needRecycle) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)output);
        if (needRecycle) {
            bmp.recycle();
        }
        byte[] result = output.toByteArray();
        try {
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] httpGet(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        HttpClient httpClient = Util.getNewHttpClient();
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);
            if (resp.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            return EntityUtils.toByteArray((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] httpPost(String url, String entity) {
        if (url == null || url.length() == 0) {
            return null;
        }
        HttpClient httpClient = Util.getNewHttpClient();
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(entity, "utf-8"));
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            HttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);
            if (resp.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            return EntityUtils.toByteArray((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static HttpClient getNewHttpClient() {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            SSLSocketFactoryEx sf = new SSLSocketFactoryEx(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)sf, 443));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        catch (Exception e) {
            return new DefaultHttpClient();
        }
    }

    public static byte[] readFromFile(String fileName, int offset, int len) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        if (len == -1) {
            len = (int)file.length();
        }
        if (offset < 0) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        if (offset + len > (int)file.length()) {
            return null;
        }
        byte[] b = null;
        try {
            RandomAccessFile in = new RandomAccessFile(fileName, "r");
            b = new byte[len];
            in.seek(offset);
            in.readFully(b);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static Bitmap extractThumbNail(String path, int height, int width, boolean crop) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        try {
            options.inJustDecodeBounds = true;
            Bitmap tmp = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            if (tmp != null) {
                tmp.recycle();
                tmp = null;
            }
            double beY = (double)options.outHeight * 1.0 / (double)height;
            double beX = (double)options.outWidth * 1.0 / (double)width;
            options.inSampleSize = (int)(crop ? (beY > beX ? beX : beY) : (beY < beX ? beX : beY));
            if (options.inSampleSize <= 1) {
                options.inSampleSize = 1;
            }
            while (options.outHeight * options.outWidth / options.inSampleSize > 2764800) {
                ++options.inSampleSize;
            }
            int newHeight = height;
            int newWidth = width;
            if (crop) {
                if (beY > beX) {
                    newHeight = (int)((double)newWidth * 1.0 * (double)options.outHeight / (double)options.outWidth);
                } else {
                    newWidth = (int)((double)newHeight * 1.0 * (double)options.outWidth / (double)options.outHeight);
                }
            } else if (beY < beX) {
                newHeight = (int)((double)newWidth * 1.0 * (double)options.outHeight / (double)options.outWidth);
            } else {
                newWidth = (int)((double)newHeight * 1.0 * (double)options.outWidth / (double)options.outHeight);
            }
            options.inJustDecodeBounds = false;
            Bitmap bm = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            if (bm == null) {
                return null;
            }
            Bitmap scale = Bitmap.createScaledBitmap((Bitmap)bm, (int)newWidth, (int)newHeight, (boolean)true);
            if (scale != null) {
                bm.recycle();
                bm = scale;
            }
            if (crop) {
                Bitmap cropped = Bitmap.createBitmap((Bitmap)bm, (int)(bm.getWidth() - width >> 1), (int)(bm.getHeight() - height >> 1), (int)width, (int)height);
                if (cropped == null) {
                    return bm;
                }
                bm.recycle();
                bm = cropped;
            }
            return bm;
        }
        catch (OutOfMemoryError e) {
            options = null;
            return null;
        }
    }

    public static String sha1(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes());
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> stringsToList(String[] src) {
        if (src == null || src.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < src.length; ++i) {
            result.add(src[i]);
        }
        return result;
    }

    private static class SSLSocketFactoryEx
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public SSLSocketFactoryEx(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

