/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n95;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.e4a.runtime.components.impl.android.n95.AddContentsRow;
import com.e4a.runtime.components.impl.android.n95.AddDivisionRow;
import com.e4a.runtime.components.impl.android.n95.AddHeadRow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class E4AtableView
extends ScrollView {
    private TableLayout tableLayout;
    private AddDivisionRow divisionRow;
    private int StretchableColumn = -1;
    private int headColor = -1;
    private int headHeight = -2;
    private int headtextColor = -16777216;
    private int headMaxEms = 10;
    private int headTextSize = 9;
    private int divisonColor = -65536;
    private int divisonWidth = 3;
    private int cellMaxEms = 10;
    private int cellTextColor = -16777216;
    private int cellTextSize = 9;
    private int cellHeight = -2;
    private boolean suolve = false;
    private boolean showImage = true;
    private int totalRows = 0;
    private int totalColumns = 0;
    private Context mContext;
    private OnTableRowClickListener onTableRowClickListener;

    public void setOnTableRowClickListener(OnTableRowClickListener listener) {
        this.onTableRowClickListener = listener;
    }

    public E4AtableView(Context context) {
        super(context);
        this.mContext = context;
        this.initWidge();
    }

    public E4AtableView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWidge();
    }

    public void setTableHeaders(String[] header) {
        if (this.StretchableColumn == -1) {
            this.tableLayout.setColumnStretchable((header.length - 1) * 2 + 1, true);
        } else {
            this.tableLayout.setColumnStretchable(this.StretchableColumn * 2 + 1, true);
        }
        this.divisionRow = new AddDivisionRow(this.getContext());
        this.tableLayout.addView((View)this.divisionRow.addTableRow(this.divisonColor, this.divisonWidth));
        AddHeadRow row = new AddHeadRow(this.getContext(), header);
        row.setDivisonColor(this.divisonColor);
        row.setDivisonWidth(this.divisonWidth);
        row.setBackgroundColor(this.headColor);
        row.setTabRowHeight(this.headHeight);
        row.setTextMaxEms(this.headMaxEms);
        row.setTextClor(this.headtextColor);
        row.setTextSize(this.headTextSize);
        this.tableLayout.addView((View)row.addTableRow(-1));
        this.tableLayout.addView((View)this.divisionRow.addTableRow(this.divisonColor, this.divisonWidth));
        this.totalColumns = header.length;
    }

    public void setTableheadColor(int color) {
        this.headColor = color;
    }

    public void setTableHeadHeigt(int height) {
        this.headHeight = height;
    }

    public void setTableHeadTextcolor(int color) {
        this.headtextColor = color;
    }

    public void setTableHeadMaxEms(int size) {
        this.headMaxEms = size;
    }

    public void setTableHeadTextSize(int size) {
        this.headTextSize = size;
    }

    public void setTableDivisonColor(int color) {
        this.divisonColor = color;
    }

    public void setTableDivisonWidth(int width) {
        this.divisonWidth = width;
    }

    public void setStretchableColumn(int column) {
        this.StretchableColumn = column;
    }

    public void showTableCellImage(boolean value) {
        this.showImage = value;
    }

    public void addNewRow(String[] objects, int color) {
        AddContentsRow addContentsRow = new AddContentsRow(this.getContext(), objects);
        addContentsRow.showTableCellImage(this.showImage);
        addContentsRow.setBackColor(color);
        addContentsRow.setDivisonColor(this.divisonColor);
        addContentsRow.setTextColor(this.cellTextColor);
        addContentsRow.setTextMaxEms(this.cellMaxEms);
        addContentsRow.setTextSize(this.cellTextSize);
        addContentsRow.setTabRowHeight(this.cellHeight);
        addContentsRow.setSuolve(this.suolve);
        TableRow tr = addContentsRow.addTableRow(this.totalRows);
        tr.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (E4AtableView.this.onTableRowClickListener != null) {
                    E4AtableView.this.onTableRowClickListener.onTableRowClick(Integer.parseInt("" + v.getTag()));
                }
            }
        });
        this.tableLayout.addView((View)tr);
        this.tableLayout.addView((View)this.divisionRow.addTableRow(this.divisonColor, this.divisonWidth));
        ++this.totalRows;
    }

    public void setTableRowColor(int row, int color) {
        if (row > this.totalRows - 1) {
            return;
        }
        int id1 = (row + 1) * 2 + 1;
        TableRow tr = (TableRow)this.tableLayout.getChildAt(id1);
        tr.setBackgroundColor(color);
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getTotalColumns() {
        return this.totalColumns;
    }

    public void removeRow(int index) {
        if (index > this.totalRows - 1) {
            return;
        }
        int id = (index + 1) * 2 + 1;
        this.tableLayout.removeViewAt(id);
        this.tableLayout.removeViewAt(id);
        --this.totalRows;
        for (int i = 0; i < this.totalRows; ++i) {
            int id1 = (i + 1) * 2 + 1;
            TableRow tableRow = (TableRow)this.tableLayout.getChildAt(id1);
            tableRow.setTag((Object)("" + i));
        }
    }

    public void clearTable() {
        this.tableLayout.removeAllViews();
        this.totalRows = 0;
    }

    public String getCellContent(int row, int column) {
        if (row > this.totalRows - 1) {
            return "";
        }
        if (column > this.totalColumns - 1) {
            return "";
        }
        int id1 = (row + 1) * 2 + 1;
        int id2 = column * 2 + 1;
        TableRow tableRow = (TableRow)this.tableLayout.getChildAt(id1);
        View view = tableRow.getChildAt(id2);
        String tag = (String)view.getTag();
        return this.\u53d6\u6587\u672c\u53f3\u8fb9(tag, tag.length() - 2);
    }

    public String \u53d6\u6587\u672c\u5de6\u8fb9(String str, int len) {
        if ("".equals(str) || len <= 0) {
            return "";
        }
        if (len > str.length()) {
            return str;
        }
        return str.substring(0, len);
    }

    public String \u53d6\u6587\u672c\u53f3\u8fb9(String str, int len) {
        if ("".equals(str) || len <= 0) {
            return "";
        }
        if (len > str.length()) {
            return str;
        }
        int start = str.length() - len;
        return str.substring(start, str.length());
    }

    public void setCellContent(int row, int column, String newContent) {
        if (row > this.totalRows - 1) {
            return;
        }
        if (column > this.totalColumns - 1) {
            return;
        }
        int id1 = (row + 1) * 2 + 1;
        int id2 = column * 2 + 1;
        TableRow tableRow = (TableRow)this.tableLayout.getChildAt(id1);
        View view = tableRow.getChildAt(id2);
        String tag = (String)view.getTag();
        String type = this.\u53d6\u6587\u672c\u5de6\u8fb9(tag, 2);
        if (type.equals("1|")) {
            TextView textView = (TextView)view;
            textView.setText((CharSequence)newContent);
            textView.setTag((Object)("1|" + newContent));
        } else {
            ImageView imageView = (ImageView)view;
            imageView.setImageDrawable(this.getDrawable(newContent));
            imageView.setTag((Object)("2|" + newContent));
        }
    }

    public Drawable getDrawable(String imagePath) {
        Drawable drawable = null;
        if (imagePath.length() > 0) {
            if (imagePath.startsWith("/")) {
                File f = new File(imagePath);
                if (f.exists()) {
                    drawable = Drawable.createFromPath((String)imagePath);
                }
            } else {
                try {
                    drawable = Drawable.createFromStream((InputStream)this.mContext.getResources().getAssets().open(imagePath), (String)imagePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return drawable;
    }

    public void setTableCellMaxEms(int length) {
        this.cellMaxEms = length;
    }

    public void setTableCellTextSize(int size) {
        this.cellTextSize = size;
    }

    public void setTableCellTextColor(int color) {
        this.cellTextColor = color;
    }

    public void setTableCellHeight(int height) {
        this.cellHeight = height;
    }

    public void setSuolve(boolean value) {
        this.suolve = value;
    }

    private void initWidge() {
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.getContext());
        horizontalScrollView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        horizontalScrollView.setFillViewport(true);
        this.tableLayout = new TableLayout(this.getContext());
        this.tableLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        horizontalScrollView.addView((View)this.tableLayout);
        this.addView((View)horizontalScrollView);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    public static interface OnTableRowClickListener {
        public void onTableRowClick(int var1);
    }
}

