/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n87;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.os.Build;
import android.os.Parcelable;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.n87.NFC;
import com.e4a.runtime.events.EventDispatcher;
import com.e4a.runtime.\u5e94\u7528\u64cd\u4f5c;
import java.io.IOException;

public class NFCImpl
extends ComponentImpl
implements NFC,
mainActivity.OnResumeListener,
mainActivity.OnNewIntentListener {
    private IntentFilter[] mFilters;
    private PendingIntent pendingIntent;
    private String[][] mTechLists;
    private boolean isFirst = true;
    private NfcAdapter nfc;
    private boolean read = false;
    private boolean write = false;
    private String neirong = null;
    Context main = mainActivity.getContext();

    public NFCImpl(ComponentContainer container) {
        super(container);
    }

    public int \u521d\u59cb\u5316() {
        if (Build.VERSION.SDK_INT < 10) {
            return 1;
        }
        this.nfc = NfcAdapter.getDefaultAdapter((Context)this.main);
        if (this.nfc == null) {
            return 1;
        }
        if (!this.nfc.isEnabled()) {
            return 2;
        }
        mainActivity.getContext().addOnResumeListener(this);
        mainActivity.getContext().addOnNewIntentListener(this);
        this.pendingIntent = PendingIntent.getActivity((Context)this.main, (int)0, (Intent)new Intent(this.main, this.main.getClass()).addFlags(0x20000000), (int)0);
        IntentFilter ndef = new IntentFilter("android.nfc.action.TECH_DISCOVERED");
        ndef.addCategory("*/*");
        this.mFilters = new IntentFilter[]{ndef};
        this.mTechLists = new String[][]{{MifareClassic.class.getName()}, {NfcA.class.getName()}};
        return 3;
    }

    public void onResume() {
        this.nfc.enableForegroundDispatch((Activity)mainActivity.getContext(), this.pendingIntent, this.mFilters, this.mTechLists);
        if (this.isFirst) {
            if ("android.nfc.action.TECH_DISCOVERED".equals(\u5e94\u7528\u64cd\u4f5c.\u83b7\u53d6\u542f\u52a8\u53c2\u6570().getAction())) {
                String result = this.processIntent(\u5e94\u7528\u64cd\u4f5c.\u83b7\u53d6\u542f\u52a8\u53c2\u6570());
                this.\u8bfb\u53d6\u5230\u4fe1\u606f(result);
            }
            this.isFirst = false;
        }
    }

    public void \u7f6e\u8bfb\u53d6\u6a21\u5f0f() {
        this.read = true;
        this.write = false;
    }

    public void \u7f6e\u5199\u5165\u6a21\u5f0f(String yes) {
        this.neirong = yes;
        this.read = false;
        this.write = true;
    }

    public void onNewIntent(Intent intent) {
        if ("android.nfc.action.TECH_DISCOVERED".equals(intent.getAction()) || "android.nfc.action.TAG_DISCOVERED".equals(intent.getAction())) {
            this.getTagInfo(intent);
            if (this.read && !this.write) {
                String result = this.processIntent(intent);
                this.\u8bfb\u53d6\u5230\u4fe1\u606f(result);
            }
            if (this.write && !this.read) {
                Tag tag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
                NdefMessage ndefMessage = this.getNoteAsNdef();
                if (ndefMessage != null) {
                    this.writeTag(this.getNoteAsNdef(), tag);
                } else {
                    this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u8bf7\u8f93\u5165\u60a8\u8981\u5199\u5165\u6807\u7b7e\u7684\u4fe1\u606f");
                }
            }
        }
    }

    private void getTagInfo(Intent intent) {
        Tag tag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        Long cardNo = Long.parseLong(this.flipHexStr(this.ByteArrayToHexString(tag.getId())), 16);
        String num = cardNo.toString();
        this.\u8bfb\u53d6\u5230\u5361\u53f7(num);
    }

    public void \u8bfb\u53d6\u5230\u5361\u53f7(String \u5361\u7247ID) {
        EventDispatcher.dispatchEvent(this, "\u8bfb\u53d6\u5230\u5361\u53f7", \u5361\u7247ID);
    }

    private String flipHexStr(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i <= s.length() - 2; i += 2) {
            result.append((CharSequence)new StringBuilder(s.substring(i, i + 2)).reverse());
        }
        return result.reverse().toString();
    }

    public String ByteArrayToHexString(byte[] inarray) {
        String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        String out = "";
        for (int j = 0; j < inarray.length; ++j) {
            int in = inarray[j] & 0xFF;
            int i = in >> 4 & 0xF;
            out = out + hex[i];
            i = in & 0xF;
            out = out + hex[i];
        }
        return out;
    }

    private NdefMessage getNoteAsNdef() {
        String text = this.neirong;
        if (text.equals("")) {
            return null;
        }
        byte[] textBytes = text.getBytes();
        NdefRecord textRecord = new NdefRecord(2, "image/jpeg".getBytes(), new byte[0], textBytes);
        return new NdefMessage(new NdefRecord[]{textRecord});
    }

    public String processIntent(Intent intent) {
        Parcelable[] rawmsgs = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
        NdefMessage msg = (NdefMessage)rawmsgs[0];
        NdefRecord[] records = msg.getRecords();
        String resultStr = new String(records[0].getPayload());
        return resultStr;
    }

    public void \u8bfb\u53d6\u5230\u4fe1\u606f(String \u4fe1\u606f) {
        EventDispatcher.dispatchEvent(this, "\u8bfb\u53d6\u5230\u4fe1\u606f", \u4fe1\u606f);
    }

    boolean writeTag(NdefMessage message, Tag tag) {
        int size = message.toByteArray().length;
        try {
            Ndef ndef = Ndef.get((Tag)tag);
            if (ndef != null) {
                ndef.connect();
                if (!ndef.isWritable()) {
                    this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u6807\u7b7e\u4e0d\u5141\u8bb8\u5199\u5165");
                    return false;
                }
                if (ndef.getMaxSize() < size) {
                    this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u5199\u5165\u4fe1\u606f\u8d85\u51fa\u5bb9\u91cf");
                    return false;
                }
                ndef.writeNdefMessage(message);
                this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u5199\u5165\u4fe1\u606f\u6210\u529f");
                return true;
            }
            NdefFormatable format = NdefFormatable.get((Tag)tag);
            if (format != null) {
                try {
                    format.connect();
                    format.format(message);
                    this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u683c\u5f0f\u5316\u6807\u7b7e\u5e76\u4e14\u5199\u5165\u4fe1\u606f");
                    return true;
                }
                catch (IOException e) {
                    this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u683c\u5f0f\u5316\u6807\u7b7e\u5931\u8d25");
                    return false;
                }
            }
            this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u6807\u7b7e\u4e0d\u652f\u6301NDEF");
            return false;
        }
        catch (Exception e) {
            this.\u8bfb\u53d6\u5230\u4fe1\u606f("\u5199\u5165\u4fe1\u606f\u5931\u8d25");
            return false;
        }
    }
}

