/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n86;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.baidu.cyberplayer.core.BMediaController;
import com.baidu.cyberplayer.core.BVideoView;
import com.baidu.cyberplayer.subtitle.SubtitleManager;
import com.baidu.cyberplayer.subtitle.utils.SubtitleError;
import com.baidu.cyberplayer.subtitle.utils.SubtitleErrorCallback;
import com.e4a.runtime.android.mainActivity;

public class VideoViewPlayingActivity
extends Activity
implements BVideoView.OnPreparedListener,
BVideoView.OnCompletionListener,
BVideoView.OnErrorListener,
BVideoView.OnInfoListener,
BVideoView.OnPlayingBufferCacheListener {
    private final String TAG = "VideoViewPlayingActivity";
    private String AK = "";
    private String SK = "";
    private static String HttpHeader = "";
    private static String UserAgent = "";
    public static String mVideoSource = null;
    public static String ZMDZ = null;
    public static int ZMDX = 30;
    public static int ZMYS = 0;
    public static BVideoView mVV = null;
    public static Handler handler = null;
    private BMediaController mVVCtl = null;
    private RelativeLayout mViewHolder = null;
    private LinearLayout mControllerHolder = null;
    private static EventHandler mEventHandler;
    private HandlerThread mHandlerThread;
    private final Object SYNC_Playing = new Object();
    private static final int EVENT_PLAY = 0;
    private PowerManager.WakeLock mWakeLock = null;
    private static final String POWER_LOCK = "VideoViewPlayingActivity";
    private static PLAYER_STATUS mPlayerStatus;
    private static int mLastPos;
    private static SubtitleManager mSubtitleManager;
    public static Handler handlerPreOrNext;
    private View.OnClickListener mPreListener = new View.OnClickListener(){

        public void onClick(View v) {
            Message msg = new Message();
            msg.what = 1;
            handler.sendMessage(msg);
        }
    };
    private View.OnClickListener mNextListener = new View.OnClickListener(){

        public void onClick(View v) {
            Message msg = new Message();
            msg.what = 2;
            handler.sendMessage(msg);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getResources().getIdentifier("controllerplaying", "layout", mainActivity.getContext().getPackageName()));
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(536870938, POWER_LOCK);
        this.AK = this.getIntent().getStringExtra("AK");
        this.SK = this.getIntent().getStringExtra("SK");
        ZMDZ = this.getIntent().getStringExtra("ZMDZ");
        ZMDX = this.getIntent().getIntExtra("ZMDX", 30);
        ZMYS = this.getIntent().getIntExtra("ZMYS", 0);
        HttpHeader = this.getIntent().getStringExtra("HttpHeader");
        UserAgent = this.getIntent().getStringExtra("UserAgent");
        Uri uriPath = this.getIntent().getData();
        if (uriPath != null) {
            String scheme = uriPath.getScheme();
            mVideoSource = scheme != null ? uriPath.toString() : uriPath.getPath();
        }
        this.initUI();
        this.mHandlerThread = new HandlerThread("event handler thread", 10);
        this.mHandlerThread.start();
        mEventHandler = new EventHandler(this.mHandlerThread.getLooper());
    }

    private void initUI() {
        this.mViewHolder = (RelativeLayout)this.findViewById(this.getResources().getIdentifier("view_holder", "id", mainActivity.getContext().getPackageName()));
        this.mControllerHolder = (LinearLayout)this.findViewById(this.getResources().getIdentifier("controller_holder", "id", mainActivity.getContext().getPackageName()));
        BVideoView.setAKSK((String)this.AK, (String)this.SK);
        mVV = new BVideoView((Context)this);
        mSubtitleManager = mVV.getSubtitlePlayManger(new SubtitleErrorCallback(){

            public void onSubtitleError(SubtitleError error) {
                Log.w((String)"test_subtitle", (String)("code: " + error.errorCode + " msg: " + error.errorMsg));
            }
        });
        this.mVVCtl = new BMediaController((Context)this);
        this.mViewHolder.addView((View)mVV);
        this.mControllerHolder.addView((View)this.mVVCtl);
        mVV.setCustomHttpHeader(HttpHeader);
        mVV.setUserAgent(UserAgent);
        mVV.setOnPreparedListener((BVideoView.OnPreparedListener)this);
        mVV.setOnCompletionListener((BVideoView.OnCompletionListener)this);
        mVV.setOnErrorListener((BVideoView.OnErrorListener)this);
        mVV.setOnInfoListener((BVideoView.OnInfoListener)this);
        this.mVVCtl.setPreNextListener(this.mPreListener, this.mNextListener);
        mVV.setMediaController(this.mVVCtl);
        mVV.setDecodeMode(1);
        mSubtitleManager = mVV.getSubtitlePlayManger(new SubtitleErrorCallback(){

            public void onSubtitleError(SubtitleError error) {
                Log.w((String)"test_subtitle", (String)("code: " + error.errorCode + " msg: " + error.errorMsg));
            }
        });
    }

    public boolean onInfo(int what, int extra) {
        switch (what) {
            case 701: {
                break;
            }
        }
        return false;
    }

    public void onPlayingBufferCache(int percent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onError(int what, int extra) {
        Log.v((String)POWER_LOCK, (String)"onError");
        Object object = this.SYNC_Playing;
        synchronized (object) {
            this.SYNC_Playing.notify();
        }
        mPlayerStatus = PLAYER_STATUS.PLAYER_IDLE;
        Message msg = new Message();
        msg.what = 6;
        handler.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion() {
        Log.v((String)POWER_LOCK, (String)"onCompletion");
        Object object = this.SYNC_Playing;
        synchronized (object) {
            this.SYNC_Playing.notify();
        }
        mPlayerStatus = PLAYER_STATUS.PLAYER_IDLE;
        Message msg = new Message();
        msg.what = 5;
        handler.sendMessage(msg);
    }

    public void onPrepared() {
        Log.v((String)POWER_LOCK, (String)"onPrepared");
        mPlayerStatus = PLAYER_STATUS.PLAYER_PREPARED;
        Message msg = new Message();
        msg.what = 4;
        handler.sendMessage(msg);
    }

    protected void onResume() {
        super.onResume();
        Log.v((String)POWER_LOCK, (String)"onResume");
        if (this.mWakeLock != null && !this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire();
        }
        mEventHandler.sendEmptyMessage(0);
    }

    protected void onPause() {
        super.onPause();
        Log.v((String)POWER_LOCK, (String)"onPause");
        if (mPlayerStatus == PLAYER_STATUS.PLAYER_PREPARED) {
            mLastPos = mVV.getCurrentPosition();
            mVV.stopPlayback();
        }
    }

    protected void onStop() {
        super.onStop();
    }

    @SuppressLint(value={"NewApi"})
    protected void onDestroy() {
        super.onDestroy();
        this.mHandlerThread.quit();
        Log.v((String)POWER_LOCK, (String)"onDestroy");
    }

    public boolean onKeyDown(int keycode, KeyEvent event) {
        if (keycode == 4) {
            this.\u5173\u95ed\u64ad\u653e\u5668();
            return true;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("KC", keycode);
        Message msg = new Message();
        msg.setData(bundle);
        msg.what = 7;
        handler.sendMessage(msg);
        return false;
    }

    public void \u5173\u95ed\u64ad\u653e\u5668() {
        mVV.pause();
        mLastPos = mVV.getCurrentPosition();
        Bundle bundle = new Bundle();
        bundle.putInt("SC", mVV.getDuration());
        bundle.putInt("WZ", mVV.getCurrentPosition());
        Message msg = new Message();
        msg.setData(bundle);
        msg.what = 3;
        handler.sendMessage(msg);
        mVV.stopPlayback();
        Intent intent = new Intent((Context)this, mainActivity.class);
        this.startActivity(intent);
    }

    static {
        mPlayerStatus = PLAYER_STATUS.PLAYER_IDLE;
        mLastPos = 0;
        handlerPreOrNext = new Handler(){

            public void handleMessage(Message msg) {
                String[] strs = (String[])msg.obj;
                switch (msg.what) {
                    case 1: {
                        ZMDZ = strs[1];
                        ZMDX = Integer.parseInt(strs[2]);
                        ZMYS = Integer.parseInt(strs[3]);
                        Uri uriPath = Uri.parse((String)strs[0]);
                        if (mPlayerStatus != PLAYER_STATUS.PLAYER_IDLE) {
                            mVV.stopPlayback();
                        }
                        if (uriPath != null) {
                            String scheme = uriPath.getScheme();
                            mVideoSource = scheme != null ? uriPath.toString() : uriPath.getPath();
                        }
                        HttpHeader = strs[4];
                        UserAgent = strs[5];
                        mVV.setCustomHttpHeader(HttpHeader);
                        mVV.setUserAgent(UserAgent);
                        mVV.setVideoPath(mVideoSource);
                        if (ZMDZ != null && ZMDZ.length() > 0) {
                            mSubtitleManager.startSubtitle(ZMDZ);
                            mSubtitleManager.setIsShowSubtitle(true);
                            mSubtitleManager.getSubtitleSettings().setDisplayColor(ZMYS);
                            mSubtitleManager.getSubtitleSettings().setDisplayFontSize((float)ZMDX);
                        }
                        if (mEventHandler.hasMessages(0)) {
                            mEventHandler.removeMessages(0);
                        }
                        mEventHandler.sendEmptyMessage(0);
                        break;
                    }
                    case 2: {
                        double second = Double.parseDouble(strs[0]);
                        if (mVV == null || mPlayerStatus != PLAYER_STATUS.PLAYER_PREPARED) break;
                        mVV.seekTo(second);
                        break;
                    }
                    case 3: {
                        Message msg2 = new Message();
                        msg2.what = 1;
                        mEventHandler.sendMessage(msg2);
                    }
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PLAYER_STATUS {
        PLAYER_IDLE,
        PLAYER_PREPARING,
        PLAYER_PREPARED;

    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (mPlayerStatus != PLAYER_STATUS.PLAYER_IDLE) {
                        Object object = VideoViewPlayingActivity.this.SYNC_Playing;
                        synchronized (object) {
                            try {
                                VideoViewPlayingActivity.this.SYNC_Playing.wait();
                                Log.v((String)VideoViewPlayingActivity.POWER_LOCK, (String)"wait player status to idle");
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    mVV.setCustomHttpHeader(HttpHeader);
                    mVV.setUserAgent(UserAgent);
                    mVV.setVideoPath(mVideoSource);
                    if (ZMDZ != null && ZMDZ.length() > 0) {
                        mSubtitleManager.startSubtitle(ZMDZ);
                        mSubtitleManager.setIsShowSubtitle(true);
                        mSubtitleManager.getSubtitleSettings().setDisplayColor(ZMYS);
                        mSubtitleManager.getSubtitleSettings().setDisplayFontSize((float)ZMDX);
                    }
                    EventHandler eventHandler = this;
                    if (mLastPos > 0) {
                        EventHandler eventHandler2 = this;
                        mVV.seekTo((double)mLastPos);
                        mLastPos = 0;
                    }
                    mVV.showCacheInfo(true);
                    mVV.start();
                    mPlayerStatus = PLAYER_STATUS.PLAYER_PREPARING;
                    break;
                }
                case 1: {
                    VideoViewPlayingActivity.this.\u5173\u95ed\u64ad\u653e\u5668();
                }
            }
        }
    }
}

