/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n84;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.e4a.runtime.\u7cfb\u7edf\u76f8\u5173\u7c7b;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PullToRefreshListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final int TAP_TO_REFRESH = 1;
    private static final int PULL_TO_REFRESH = 2;
    private static final int RELEASE_TO_REFRESH = 3;
    private static final int REFRESHING = 4;
    private static final int TAP_TO_LOADMORE = 5;
    private static final int LOADING = 6;
    private OnRefreshListener mOnRefreshListener;
    private AbsListView.OnScrollListener mOnScrollListener;
    private LayoutInflater mInflater;
    private RelativeLayout mRefreshHeaderView;
    private TextView mRefreshViewText;
    private ImageView mRefreshViewImage;
    private ProgressBar mRefreshViewProgress;
    private TextView mRefreshViewLastUpdated;
    private RelativeLayout mLoadMoreFooterView;
    private TextView mLoadMoreText;
    private ProgressBar mLoadMoreProgress;
    private int mCurrentScrollState;
    private int mRefreshState;
    private int mLoadState;
    private RotateAnimation mFlipAnimation;
    private RotateAnimation mReverseFlipAnimation;
    private int mRefreshViewHeight;
    private int mRefreshOriginalTopPadding;
    private int mLastMotionY;
    private int pull_to_refresh_header;
    private int pull_to_refresh_text;
    private int pull_to_refresh_image;
    private int pull_to_refresh_progress;
    private int pull_to_refresh_updated_at;
    private int loadmore_footer;
    private int loadmore_text;
    private int loadmore_progress;
    private int pulltorefresh_arrow;
    private boolean \u4e0b\u62c9\u5237\u65b0\u53ef\u89c6 = true;
    private boolean \u52a0\u8f7d\u66f4\u591a\u53ef\u89c6 = true;
    private int \u8bed\u8a00\u7c7b\u578b = 1;

    public PullToRefreshListView(Context context) {
        super(context);
        this.init(context);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PullToRefreshListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.pull_to_refresh_header = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("pull_to_refresh_header", "layout");
        this.pull_to_refresh_text = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("pull_to_refresh_text", "id");
        this.pull_to_refresh_image = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("pull_to_refresh_image", "id");
        this.pull_to_refresh_progress = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("pull_to_refresh_progress", "id");
        this.pull_to_refresh_updated_at = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("pull_to_refresh_updated_at", "id");
        this.loadmore_footer = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("loadmore_footer", "layout");
        this.loadmore_text = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("loadmore_text", "id");
        this.loadmore_progress = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("loadmore_progress", "id");
        this.pulltorefresh_arrow = \u7cfb\u7edf\u76f8\u5173\u7c7b.\u53d6\u8d44\u6e90\u7d22\u5f15("pulltorefresh_arrow", "drawable");
        this.mFlipAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mFlipAnimation.setDuration(250L);
        this.mFlipAnimation.setFillAfter(true);
        this.mReverseFlipAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mReverseFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mReverseFlipAnimation.setDuration(250L);
        this.mReverseFlipAnimation.setFillAfter(true);
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mRefreshHeaderView = (RelativeLayout)this.mInflater.inflate(this.pull_to_refresh_header, (ViewGroup)this, false);
        this.mRefreshViewText = (TextView)this.mRefreshHeaderView.findViewById(this.pull_to_refresh_text);
        this.mRefreshViewImage = (ImageView)this.mRefreshHeaderView.findViewById(this.pull_to_refresh_image);
        this.mRefreshViewProgress = (ProgressBar)this.mRefreshHeaderView.findViewById(this.pull_to_refresh_progress);
        this.mRefreshViewLastUpdated = (TextView)this.mRefreshHeaderView.findViewById(this.pull_to_refresh_updated_at);
        this.mLoadMoreFooterView = (RelativeLayout)this.mInflater.inflate(this.loadmore_footer, (ViewGroup)this, false);
        this.mLoadMoreText = (TextView)this.mLoadMoreFooterView.findViewById(this.loadmore_text);
        this.mLoadMoreProgress = (ProgressBar)this.mLoadMoreFooterView.findViewById(this.loadmore_progress);
        this.mRefreshViewImage.setMinimumHeight(50);
        this.mRefreshHeaderView.setOnClickListener((View.OnClickListener)new OnClickRefreshListener());
        this.mRefreshOriginalTopPadding = this.mRefreshHeaderView.getPaddingTop();
        this.mLoadMoreFooterView.setOnClickListener((View.OnClickListener)new OnClickLoadMoreListener());
        this.mRefreshState = 1;
        this.mLoadState = 5;
        this.addHeaderView((View)this.mRefreshHeaderView);
        this.addFooterView((View)this.mLoadMoreFooterView);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.measureView((View)this.mRefreshHeaderView);
        this.mRefreshViewHeight = this.mRefreshHeaderView.getMeasuredHeight();
    }

    public void \u8bbe\u7f6e\u8bed\u8a00\u7c7b\u578b(int value) {
        this.\u8bed\u8a00\u7c7b\u578b = value;
        if (value == 1) {
            this.mRefreshViewText.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0");
            this.mLoadMoreText.setText((CharSequence)"\u52a0\u8f7d\u66f4\u591a");
        } else {
            this.mRefreshViewText.setText((CharSequence)"pull to refresh");
            this.mLoadMoreText.setText((CharSequence)"load more");
        }
    }

    public void \u8bbe\u7f6e\u4e0b\u62c9\u5237\u65b0\u6807\u7b7e\u5b57\u4f53\u989c\u8272(int color) {
        this.mRefreshViewText.setTextColor(color);
    }

    public void \u8bbe\u7f6e\u5237\u65b0\u65f6\u95f4\u6807\u7b7e\u5b57\u4f53\u989c\u8272(int color) {
        this.mRefreshViewLastUpdated.setTextColor(color);
    }

    public void \u8bbe\u7f6e\u52a0\u8f7d\u66f4\u591a\u6807\u7b7e\u5b57\u4f53\u989c\u8272(int color) {
        this.mLoadMoreText.setTextColor(color);
    }

    public void \u8bbe\u7f6e\u52a0\u8f7d\u66f4\u591a\u53ef\u89c1\u6027(boolean value) {
        if (value) {
            if (!this.\u52a0\u8f7d\u66f4\u591a\u53ef\u89c6) {
                this.addFooterView((View)this.mLoadMoreFooterView);
                this.\u52a0\u8f7d\u66f4\u591a\u53ef\u89c6 = true;
            }
        } else if (this.\u52a0\u8f7d\u66f4\u591a\u53ef\u89c6) {
            this.removeFooterView((View)this.mLoadMoreFooterView);
            this.\u52a0\u8f7d\u66f4\u591a\u53ef\u89c6 = false;
        }
    }

    public void \u8bbe\u7f6e\u4e0b\u62c9\u5237\u65b0\u53ef\u89c1\u6027(boolean value) {
        if (value) {
            if (!this.\u4e0b\u62c9\u5237\u65b0\u53ef\u89c6) {
                this.addHeaderView((View)this.mRefreshHeaderView);
                this.\u4e0b\u62c9\u5237\u65b0\u53ef\u89c6 = true;
            }
        } else if (this.\u4e0b\u62c9\u5237\u65b0\u53ef\u89c6) {
            this.removeHeaderView((View)this.mRefreshHeaderView);
            this.\u4e0b\u62c9\u5237\u65b0\u53ef\u89c6 = false;
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOnScrollListener = l;
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    public void setLastUpdated(CharSequence lastUpdated) {
        if (lastUpdated != null) {
            this.mRefreshViewLastUpdated.setVisibility(0);
            if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
                this.mRefreshViewLastUpdated.setText((CharSequence)("\u66f4\u65b0\u4e8e: " + lastUpdated));
            } else {
                this.mRefreshViewLastUpdated.setText((CharSequence)("updated in: " + lastUpdated));
            }
        } else {
            this.mRefreshViewLastUpdated.setVisibility(8);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.\u4e0b\u62c9\u5237\u65b0\u53ef\u89c6) {
            return super.onTouchEvent(event);
        }
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 1: {
                if (!this.isVerticalScrollBarEnabled()) {
                    this.setVerticalScrollBarEnabled(true);
                }
                if (this.getFirstVisiblePosition() != 0 || this.mRefreshState == 4) break;
                if ((this.mRefreshHeaderView.getBottom() > this.mRefreshViewHeight || this.mRefreshHeaderView.getTop() >= 0) && this.mRefreshState == 3) {
                    this.mRefreshState = 4;
                    this.prepareForRefresh();
                    this.onRefresh();
                    break;
                }
                if (this.mRefreshHeaderView.getBottom() >= this.mRefreshViewHeight && this.mRefreshHeaderView.getTop() >= 0) break;
                this.resetHeader();
                this.setSelection(1);
                break;
            }
            case 0: {
                this.mLastMotionY = y;
                break;
            }
            case 2: {
                this.applyHeaderPadding(event);
            }
        }
        return super.onTouchEvent(event);
    }

    private void applyHeaderPadding(MotionEvent ev) {
        int historySize = ev.getHistorySize();
        int pointerCount = 1;
        try {
            Method method = MotionEvent.class.getMethod("getPointerCount", new Class[0]);
            pointerCount = (Integer)method.invoke((Object)ev, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            pointerCount = 1;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            System.err.println("unexpected " + e);
        }
        catch (InvocationTargetException e) {
            System.err.println("unexpected " + e);
        }
        for (int h = 0; h < historySize; ++h) {
            for (int p = 0; p < pointerCount; ++p) {
                if (this.mRefreshState != 3) continue;
                if (this.isVerticalFadingEdgeEnabled()) {
                    this.setVerticalScrollBarEnabled(false);
                }
                int historicalY = 0;
                try {
                    Method method = MotionEvent.class.getMethod("getHistoricalY", Integer.TYPE, Integer.TYPE);
                    historicalY = ((Float)method.invoke((Object)ev, p, h)).intValue();
                }
                catch (NoSuchMethodException e) {
                    historicalY = (int)ev.getHistoricalY(h);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    System.err.println("unexpected " + e);
                }
                catch (InvocationTargetException e) {
                    System.err.println("unexpected " + e);
                }
                int topPadding = (int)((double)(historicalY - this.mLastMotionY - this.mRefreshViewHeight) / 1.7);
                this.mRefreshHeaderView.setPadding(this.mRefreshHeaderView.getPaddingLeft(), topPadding, this.mRefreshHeaderView.getPaddingRight(), this.mRefreshHeaderView.getPaddingBottom());
            }
        }
    }

    private void resetHeaderPadding() {
        this.mRefreshHeaderView.setPadding(this.mRefreshHeaderView.getPaddingLeft(), this.mRefreshOriginalTopPadding, this.mRefreshHeaderView.getPaddingRight(), this.mRefreshHeaderView.getPaddingBottom());
    }

    private void resetHeader() {
        if (this.mRefreshState != 1) {
            this.mRefreshState = 1;
            this.resetHeaderPadding();
            if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
                this.mRefreshViewText.setText((CharSequence)"\u70b9\u6b64\u5237\u65b0");
            } else {
                this.mRefreshViewText.setText((CharSequence)"click to update");
            }
            this.mRefreshViewImage.setImageResource(this.pulltorefresh_arrow);
            this.mRefreshViewImage.clearAnimation();
            this.mRefreshViewImage.setVisibility(8);
            this.mRefreshViewProgress.setVisibility(8);
        }
    }

    private void resetFooter() {
        if (this.mLoadState != 5) {
            this.mLoadState = 5;
            this.mLoadMoreProgress.setVisibility(8);
            if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
                this.mLoadMoreText.setText((CharSequence)"\u70b9\u51fb\u52a0\u8f7d\u66f4\u591a");
            } else {
                this.mLoadMoreText.setText((CharSequence)"click to load more");
            }
        }
    }

    private void measureView(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.\u4e0b\u62c9\u5237\u65b0\u53ef\u89c6) {
            return;
        }
        if (this.mCurrentScrollState == 1 && this.mRefreshState != 4) {
            if (firstVisibleItem == 0) {
                this.mRefreshViewImage.setVisibility(0);
                if ((this.mRefreshHeaderView.getBottom() > this.mRefreshViewHeight + 20 || this.mRefreshHeaderView.getTop() >= 0) && this.mRefreshState != 3) {
                    if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
                        this.mRefreshViewText.setText((CharSequence)"\u91ca\u653e\u4ee5\u5237\u65b0...");
                    } else {
                        this.mRefreshViewText.setText((CharSequence)"release to refresh");
                    }
                    this.mRefreshViewImage.clearAnimation();
                    this.mRefreshViewImage.startAnimation((Animation)this.mFlipAnimation);
                    this.mRefreshState = 3;
                } else if (this.mRefreshHeaderView.getBottom() < this.mRefreshViewHeight + 20 && this.mRefreshState != 2) {
                    if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
                        this.mRefreshViewText.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0...");
                    } else {
                        this.mRefreshViewText.setText((CharSequence)"pull to refresh");
                    }
                    if (this.mRefreshState != 1) {
                        this.mRefreshViewImage.clearAnimation();
                        this.mRefreshViewImage.startAnimation((Animation)this.mReverseFlipAnimation);
                    }
                    this.mRefreshState = 2;
                }
            } else {
                this.mRefreshViewImage.setVisibility(8);
                this.resetHeader();
            }
        } else if (this.mCurrentScrollState == 2 && firstVisibleItem == 0 && this.mRefreshState != 4) {
            this.setSelection(1);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mCurrentScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void prepareForRefresh() {
        this.resetHeaderPadding();
        this.mRefreshViewImage.setVisibility(8);
        this.mRefreshViewImage.setImageDrawable(null);
        this.mRefreshViewProgress.setVisibility(0);
        if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
            this.mRefreshViewText.setText((CharSequence)"\u6b63\u5728\u5237\u65b0...");
        } else {
            this.mRefreshViewText.setText((CharSequence)"refreshing...");
        }
        this.mRefreshState = 4;
    }

    public void prepareForLoadMore() {
        this.mLoadMoreProgress.setVisibility(0);
        if (this.\u8bed\u8a00\u7c7b\u578b == 1) {
            this.mLoadMoreText.setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d...");
        } else {
            this.mLoadMoreText.setText((CharSequence)"loading...");
        }
        this.mLoadState = 6;
    }

    public void onRefresh() {
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh();
        }
    }

    public void OnLoadMore() {
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onLoadMore();
        }
    }

    public void onRefreshComplete() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd  HH:mm");
        String date = format.format(new Date());
        this.setLastUpdated(date);
        this.resetHeader();
        if (this.mRefreshHeaderView.getBottom() > 0) {
            this.invalidateViews();
            this.setSelection(1);
        }
    }

    public void onLoadMoreComplete() {
        this.resetFooter();
    }

    public static interface OnRefreshListener {
        public void onRefresh();

        public void onLoadMore();
    }

    private class OnClickLoadMoreListener
    implements View.OnClickListener {
        private OnClickLoadMoreListener() {
        }

        public void onClick(View v) {
            if (PullToRefreshListView.this.mLoadState != 6) {
                PullToRefreshListView.this.prepareForLoadMore();
                PullToRefreshListView.this.OnLoadMore();
            }
        }
    }

    private class OnClickRefreshListener
    implements View.OnClickListener {
        private OnClickRefreshListener() {
        }

        public void onClick(View v) {
            if (PullToRefreshListView.this.mRefreshState != 4) {
                PullToRefreshListView.this.prepareForRefresh();
                PullToRefreshListView.this.onRefresh();
            }
        }
    }
}

