/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n7;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.android.ViewComponent;
import com.e4a.runtime.components.impl.android.n7.\u753b\u677f;
import com.e4a.runtime.components.impl.android.util.PaintUtil;
import com.e4a.runtime.components.impl.android.\u4e8b\u4ef6\u76d1\u542c\u5668Impl;
import com.e4a.runtime.components.\u4e8b\u4ef6\u76d1\u542c\u5668;
import com.e4a.runtime.events.EventDispatcher;
import com.e4a.runtime.\u5e94\u7528\u64cd\u4f5c;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class \u753b\u677fImpl
extends ViewComponent
implements \u753b\u677f,
View.OnTouchListener,
View.OnClickListener {
    private GestureDetector mGestureDetector;
    private int lastX;
    private int lastY;
    private int currX;
    private int currY;
    private Paint paintColor;
    private Paint backgroundColor;
    private String backgroundImage = "";
    private int backgroundImage2 = -1;
    private int paintsize;
    private float textsize;
    private int paintstyle;
    private Typeface typeface = null;
    private boolean visiable;
    private int canvaswidth = mainActivity.getContext().getWallpaperDesiredMinimumWidth();
    private int canvasheight = mainActivity.getContext().getWallpaperDesiredMinimumWidth();
    private \u4e8b\u4ef6\u76d1\u542c\u5668Impl \u76d1\u542c\u5668;
    private boolean \u7ed1\u5b9a = false;
    private int \u7d22\u5f15;

    public \u753b\u677fImpl(ComponentContainer container) {
        super(container);
    }

    protected View createView() {
        CanvasView view = new CanvasView((Context)mainActivity.getContext());
        view.setOnClickListener(this);
        view.setFocusable(true);
        this.backgroundColor = new Paint();
        this.paintColor = new Paint(1);
        this.paintColor.setStrokeWidth(1.0f);
        this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                int deltaX = (int)(e1.getRawX() - e2.getRawX());
                int deltaY = (int)(e1.getRawY() - e2.getRawY());
                int direction = Math.abs(deltaX) > Math.abs(deltaY) ? (deltaX > 0 ? 4 : 5) : (deltaY > 0 ? 2 : 3);
                \u753b\u677fImpl.this.\u89e6\u6478\u624b\u52bf(direction);
                return true;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                int direction = Math.abs(distanceX) > Math.abs(distanceY) ? (distanceX > 0.0f ? 8 : 9) : (distanceY > 0.0f ? 6 : 7);
                \u753b\u677fImpl.this.\u89e6\u6478\u624b\u52bf(direction);
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                \u753b\u677fImpl.this.\u89e6\u6478\u624b\u52bf(0);
                return true;
            }

            public boolean onDoubleTap(MotionEvent e) {
                \u753b\u677fImpl.this.\u89e6\u6478\u624b\u52bf(1);
                return true;
            }
        });
        view.setOnTouchListener(this);
        return view;
    }

    public boolean onTouch(View view, MotionEvent event) {
        this.lastX = this.currX;
        this.lastY = this.currY;
        this.currX = (int)event.getX();
        this.currY = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.lastX = this.currX;
                this.lastY = this.currY;
                this.\u88ab\u6309\u4e0b(this.currX, this.currY);
                if (this.\u76d1\u542c\u5668 == null) break;
                this.\u76d1\u542c\u5668.\u88ab\u6309\u4e0b(this.\u7d22\u5f15, this.currX, this.currY);
                break;
            }
            case 2: {
                this.\u88ab\u79fb\u52a8(this.lastX, this.lastY, this.currX, this.currY);
                if (!this.\u7ed1\u5b9a) break;
                this.\u76d1\u542c\u5668.\u88ab\u79fb\u52a8(this.\u7d22\u5f15, this.lastX, this.lastY, this.currX, this.currY);
                break;
            }
            case 1: {
                this.lastX = this.currX;
                this.lastY = this.currY;
                this.\u88ab\u5f39\u8d77(this.currX, this.currY);
                if (this.\u76d1\u542c\u5668 == null) break;
                this.\u76d1\u542c\u5668.\u88ab\u5f39\u8d77(this.\u7d22\u5f15, this.currX, this.currY);
            }
        }
        this.mGestureDetector.onTouchEvent(event);
        return false;
    }

    public void \u89e6\u6478\u624b\u52bf(int direction) {
        EventDispatcher.dispatchEvent(this, "\u89e6\u6478\u624b\u52bf", direction);
    }

    public void onClick(View view) {
        this.\u88ab\u5355\u51fb();
        if (this.\u7ed1\u5b9a) {
            this.\u76d1\u542c\u5668.\u88ab\u5355\u51fb(this.\u7d22\u5f15);
        }
    }

    public void \u88ab\u5355\u51fb() {
        EventDispatcher.dispatchEvent(this, "\u88ab\u5355\u51fb", new Object[0]);
    }

    public void \u7f6e\u7ec4\u4ef6\u7d22\u5f15(int id) {
        View view = this.getView();
        view.setId(id);
        this.\u7d22\u5f15 = id;
    }

    public int \u53d6\u7ec4\u4ef6\u7d22\u5f15() {
        View view = this.getView();
        return view.getId();
    }

    public void \u7ed1\u5b9a\u4e8b\u4ef6(\u4e8b\u4ef6\u76d1\u542c\u5668 listener) {
        this.\u76d1\u542c\u5668 = (\u4e8b\u4ef6\u76d1\u542c\u5668Impl)listener;
        this.\u7ed1\u5b9a = true;
    }

    public void \u88ab\u6309\u4e0b(int x, int y) {
        EventDispatcher.dispatchEvent(this, "\u88ab\u6309\u4e0b", x, y);
    }

    public void \u88ab\u5f39\u8d77(int x, int y) {
        EventDispatcher.dispatchEvent(this, "\u88ab\u5f39\u8d77", x, y);
    }

    public void \u88ab\u79fb\u52a8(int x1, int y1, int x2, int y2) {
        EventDispatcher.dispatchEvent(this, "\u88ab\u79fb\u52a8", x1, y1, x2, y2);
    }

    public int \u80cc\u666f\u989c\u8272() {
        return PaintUtil.extractARGB(this.backgroundColor);
    }

    public void \u80cc\u666f\u989c\u8272(int argb) {
        PaintUtil.changePaint(this.backgroundColor, argb);
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawPaint(this.backgroundColor);
        view.invalidate();
    }

    public String \u80cc\u666f\u56fe\u7247() {
        return this.backgroundImage;
    }

    public void \u80cc\u666f\u56fe\u7247(String imagePath) {
        this.backgroundImage = imagePath;
        try {
            if (imagePath.length() > 0) {
                if (imagePath.startsWith("/")) {
                    CanvasView view = (CanvasView)this.getView();
                    PaintUtil.changePaint(this.backgroundColor, 0);
                    view.canvas.drawPaint(this.backgroundColor);
                    view.setBackgroundDrawable(Drawable.createFromStream((InputStream)new FileInputStream(imagePath), (String)imagePath));
                    view.invalidate();
                } else {
                    CanvasView view = (CanvasView)this.getView();
                    PaintUtil.changePaint(this.backgroundColor, 0);
                    view.canvas.drawPaint(this.backgroundColor);
                    view.setBackgroundDrawable(Drawable.createFromStream((InputStream)view.getContext().getAssets().open(imagePath), (String)imagePath));
                    view.invalidate();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int \u80cc\u666f\u56fe\u72472() {
        return this.backgroundImage2;
    }

    public void \u80cc\u666f\u56fe\u72472(int id) {
        this.backgroundImage2 = id;
        CanvasView view = (CanvasView)this.getView();
        PaintUtil.changePaint(this.backgroundColor, 0);
        view.canvas.drawPaint(this.backgroundColor);
        view.setBackgroundResource(id);
        view.invalidate();
    }

    public int \u753b\u7b14\u989c\u8272() {
        return PaintUtil.extractARGB(this.paintColor);
    }

    public void \u753b\u7b14\u989c\u8272(int argb) {
        PaintUtil.changePaint(this.paintColor, argb);
    }

    public int \u753b\u7b14\u7c97\u7ec6() {
        return this.paintsize;
    }

    public void \u753b\u7b14\u7c97\u7ec6(int size) {
        if (size == 0) {
            this.paintColor.setStrokeWidth(1.0f);
            this.paintsize = 1;
        } else {
            this.paintColor.setStrokeWidth((float)size);
            this.paintsize = size;
        }
    }

    public int \u753b\u7b14\u7c7b\u578b() {
        return this.paintstyle;
    }

    public void \u753b\u7b14\u7c7b\u578b(int style) {
        if (style == 1) {
            this.paintColor.setStyle(Paint.Style.FILL);
        } else {
            this.paintColor.setStyle(Paint.Style.STROKE);
        }
        this.paintstyle = style;
    }

    public float \u5b57\u4f53\u5927\u5c0f() {
        return this.textsize;
    }

    public void \u5b57\u4f53\u5927\u5c0f(float size) {
        if (\u5e94\u7528\u64cd\u4f5c.\u662f\u5426\u81ea\u9002\u5e94()) {
            this.paintColor.setTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(size));
        } else {
            this.paintColor.setTextSize(size);
        }
        this.textsize = size;
    }

    public int \u753b\u5e03\u5bbd\u5ea6() {
        return this.canvaswidth;
    }

    public void \u753b\u5e03\u5bbd\u5ea6(int w) {
        this.canvaswidth = w;
        CanvasView canvas = (CanvasView)this.getView();
        canvas.reset(this.canvaswidth, this.canvasheight);
        canvas.invalidate();
    }

    public int \u753b\u5e03\u9ad8\u5ea6() {
        return this.canvasheight;
    }

    public void \u753b\u5e03\u9ad8\u5ea6(int h) {
        this.canvasheight = h;
        CanvasView canvas = (CanvasView)this.getView();
        canvas.reset(this.canvaswidth, this.canvasheight);
        canvas.invalidate();
    }

    public void \u7f6e\u753b\u5e03\u5c3a\u5bf8(int w, int h) {
        CanvasView canvas = (CanvasView)this.getView();
        canvas.reset(w, h);
        canvas.invalidate();
    }

    public void \u81ea\u5b9a\u4e49\u5b57\u4f53(String name) {
        this.typeface = name.startsWith("/") ? Typeface.createFromFile((String)name) : Typeface.createFromAsset((AssetManager)mainActivity.getContext().getAssets(), (String)name);
        this.paintColor.setTypeface(this.typeface);
    }

    public void \u6e05\u7a7a() {
        CanvasView view = (CanvasView)this.getView();
        view.bitmap.eraseColor(0);
        view.invalidate();
    }

    public void \u4fdd\u5b58\u753b\u9762(String path, int format) {
        CanvasView view = (CanvasView)this.getView();
        try {
            File file = new File(path);
            FileOutputStream fos = new FileOutputStream(file);
            if (format == 1) {
                view.bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            } else {
                view.bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            }
            fos.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public int \u53d6\u70b9\u989c\u8272\u503c(int x, int y) {
        CanvasView view = (CanvasView)this.getView();
        return view.bitmap.getPixel(x, y);
    }

    public void \u4fdd\u5b58\u72b6\u6001() {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.save();
    }

    public void \u6062\u590d\u72b6\u6001() {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.restore();
    }

    public void \u65cb\u8f6c\u753b\u5e03(int x, int y, float angle) {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.rotate(angle, (float)x, (float)y);
    }

    public void \u753b\u70b9(int x, int y) {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawPoint((float)x, (float)y, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u5706(int x, int y, float r) {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawCircle((float)x, (float)y, r, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u76f4\u7ebf(int x1, int y1, int x2, int y2) {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawLine((float)x1, (float)y1, (float)x2, (float)y2, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u8d1d\u585e\u5c14\u66f2\u7ebf(int qx, int qy, int fx, int fy, int zx, int zy) {
        Path path = new Path();
        path.moveTo((float)qx, (float)qy);
        path.quadTo((float)fx, (float)fy, (float)zx, (float)zy);
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawPath(path, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u6587\u5b57(int x, int y, String text) {
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawText(text, (float)x, (float)y, this.paintColor);
        view.invalidate();
    }

    public int \u753b\u6587\u5b572(int x, int y, String text, float spacing, int width) {
        CanvasView view = (CanvasView)this.getView();
        TextPaint textPaint = new TextPaint();
        textPaint.setAntiAlias(true);
        if (\u5e94\u7528\u64cd\u4f5c.\u662f\u5426\u81ea\u9002\u5e94()) {
            textPaint.setTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
        } else {
            textPaint.setTextSize(this.textsize);
        }
        textPaint.setColor(this.\u753b\u7b14\u989c\u8272());
        textPaint.setStrokeWidth((float)this.paintsize);
        if (this.typeface != null) {
            textPaint.setTypeface(this.typeface);
        }
        if (this.paintstyle == 1) {
            textPaint.setStyle(Paint.Style.FILL);
        } else {
            textPaint.setStyle(Paint.Style.STROKE);
        }
        StaticLayout staticLayout = new StaticLayout((CharSequence)text, textPaint, width, Layout.Alignment.ALIGN_NORMAL, spacing, 0.0f, true);
        view.canvas.translate((float)x, (float)y);
        staticLayout.draw(view.canvas);
        view.canvas.translate((float)(-x), (float)(-y));
        view.invalidate();
        return staticLayout.getLineCount();
    }

    public int \u53d6\u6587\u5b57\u5bbd\u5ea6(String str) {
        Rect rect = new Rect();
        this.paintColor.getTextBounds(str, 0, str.length(), rect);
        int w = rect.width();
        return w;
    }

    public int \u53d6\u6587\u5b57\u9ad8\u5ea6(String str) {
        Rect rect = new Rect();
        this.paintColor.getTextBounds(str, 0, str.length(), rect);
        int h = rect.height();
        return h;
    }

    public void \u753b\u77e9\u5f62(int x, int y, int w, int h) {
        CanvasView view = (CanvasView)this.getView();
        Rect dst = new Rect();
        dst.left = x;
        dst.top = y;
        dst.right = x + w;
        dst.bottom = y + h;
        view.canvas.drawRect(dst, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u5706\u89d2\u77e9\u5f62(int x, int y, int w, int h, float r) {
        CanvasView view = (CanvasView)this.getView();
        RectF dst = new RectF();
        dst.left = x;
        dst.top = y;
        dst.right = x + w;
        dst.bottom = y + h;
        view.canvas.drawRoundRect(dst, r, r, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u5f27\u5f62(int x, int y, int w, int h, float startAngle, float sweepAngle, boolean useCenter) {
        CanvasView view = (CanvasView)this.getView();
        RectF dst = new RectF();
        dst.left = x;
        dst.top = y;
        dst.right = x + w;
        dst.bottom = y + h;
        view.canvas.drawArc(dst, startAngle, sweepAngle, useCenter, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u56fe\u7247(String imagePath, int x, int y) {
        try {
            if (imagePath.length() > 0) {
                if (imagePath.startsWith("/")) {
                    File f = new File(imagePath);
                    if (f.exists()) {
                        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath);
                        CanvasView view = (CanvasView)this.getView();
                        view.canvas.drawBitmap(bitmap, (float)x, (float)y, this.paintColor);
                        view.invalidate();
                    }
                } else {
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)mainActivity.getContext().getResources().getAssets().open(imagePath));
                    CanvasView view = (CanvasView)this.getView();
                    view.canvas.drawBitmap(bitmap, (float)x, (float)y, this.paintColor);
                    view.invalidate();
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void \u753b\u5b57\u8282\u56fe\u7247(byte[] image, int x, int y) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        CanvasView view = (CanvasView)this.getView();
        view.canvas.drawBitmap(bitmap, (float)x, (float)y, this.paintColor);
        view.invalidate();
    }

    public void \u753b\u56fe\u7247\u7f29\u653e(String imagePath, int x, int y, int w, int h) {
        try {
            if (imagePath.length() > 0) {
                if (imagePath.startsWith("/")) {
                    File f = new File(imagePath);
                    if (f.exists()) {
                        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath);
                        Rect dst = new Rect();
                        dst.left = x;
                        dst.top = y;
                        dst.right = x + w;
                        dst.bottom = y + h;
                        CanvasView view = (CanvasView)this.getView();
                        view.canvas.drawBitmap(bitmap, null, dst, this.paintColor);
                        view.invalidate();
                        dst = null;
                    }
                } else {
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)mainActivity.getContext().getResources().getAssets().open(imagePath));
                    Rect dst = new Rect();
                    dst.left = x;
                    dst.top = y;
                    dst.right = x + w;
                    dst.bottom = y + h;
                    CanvasView view = (CanvasView)this.getView();
                    view.canvas.drawBitmap(bitmap, null, dst, this.paintColor);
                    view.invalidate();
                    dst = null;
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void \u753b\u56fe\u7247\u7f29\u653e2(int imageId, int x, int y, int w, int h) {
        Bitmap bmp = BitmapFactory.decodeResource((Resources)mainActivity.getContext().getResources(), (int)imageId);
        NinePatch patch = new NinePatch(bmp, bmp.getNinePatchChunk(), null);
        CanvasView view = (CanvasView)this.getView();
        patch.draw(view.canvas, new Rect(x, y, w, h));
    }

    public void \u753b\u56fe\u7247\u7f29\u653e\u90e8\u5206(String imagePath, int x, int y, int w, int h, int x2, int y2, int w2, int h2) {
        try {
            if (imagePath.length() > 0) {
                if (imagePath.startsWith("/")) {
                    File f = new File(imagePath);
                    if (f.exists()) {
                        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x2, (int)y2, (int)w2, (int)h2);
                        Rect dst = new Rect();
                        dst.left = x;
                        dst.top = y;
                        dst.right = x + w;
                        dst.bottom = y + h;
                        CanvasView view = (CanvasView)this.getView();
                        view.canvas.drawBitmap(bitmap, null, dst, this.paintColor);
                        view.invalidate();
                        dst = null;
                    }
                } else {
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)mainActivity.getContext().getResources().getAssets().open(imagePath));
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x2, (int)y2, (int)w2, (int)h2);
                    Rect dst = new Rect();
                    dst.left = x;
                    dst.top = y;
                    dst.right = x + w;
                    dst.bottom = y + h;
                    CanvasView view = (CanvasView)this.getView();
                    view.canvas.drawBitmap(bitmap, null, dst, this.paintColor);
                    view.invalidate();
                    dst = null;
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private class CanvasView
    extends View {
        protected Canvas canvas;
        protected Bitmap bitmap;

        protected void onDraw(Canvas c) {
            if (this.bitmap != null) {
                c.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
            }
        }

        public CanvasView(Context context) {
            super(context);
            this.bitmap = Bitmap.createBitmap((int)context.getWallpaperDesiredMinimumWidth(), (int)context.getWallpaperDesiredMinimumWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas = new Canvas(this.bitmap);
        }

        public void reset(int w, int h) {
            this.bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas.setBitmap(this.bitmap);
        }
    }
}

