/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n63;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.annotations.SimpleObject;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.android.ViewComponent;
import com.e4a.runtime.components.impl.android.n63.\u6444\u50cf\u6846;
import com.e4a.runtime.events.EventDispatcher;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@SimpleObject
public class \u6444\u50cf\u6846Impl
extends ViewComponent
implements \u6444\u50cf\u6846 {
    private LinearLayout layout;
    private CameraView cv;
    private int \u6444\u50cf\u5934\u7c7b\u578b;
    private int width;
    private int height;
    private boolean \u95ea\u5149\u706f;
    private int \u5c4f\u5e55\u65b9\u5411;
    private int \u62cd\u7167\u65b9\u5f0f;
    private final CameraSizeComparator sizeComparator = new CameraSizeComparator();

    public \u6444\u50cf\u6846Impl(ComponentContainer container) {
        super(container);
    }

    protected View createView() {
        this.layout = new LinearLayout((Context)mainActivity.getContext());
        this.layout.setOrientation(1);
        this.layout.setHorizontalGravity(1);
        this.layout.setBackgroundColor(-16777216);
        return this.layout;
    }

    public void \u5f00\u542f\u6444\u50cf\u5934(int t, int w, int h) {
        this.\u5173\u95ed\u6444\u50cf\u5934();
        this.\u6444\u50cf\u5934\u7c7b\u578b = t;
        this.width = w;
        this.height = h;
        this.\u5c4f\u5e55\u65b9\u5411 = mainActivity.getContext().getResources().getConfiguration().orientation == 1 ? 1 : 2;
        this.cv = new CameraView((Context)mainActivity.getContext());
        LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(-1, -1);
        this.layout.addView((View)this.cv, (ViewGroup.LayoutParams)param);
        this.cv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                \u6444\u50cf\u6846Impl.this.\u88ab\u5355\u51fb();
            }
        });
    }

    public void \u88ab\u5355\u51fb() {
        EventDispatcher.dispatchEvent(this, "\u88ab\u5355\u51fb", new Object[0]);
    }

    public void \u5f00\u59cb\u5bf9\u7126() {
        if (this.cv != null) {
            this.cv.focus();
        }
    }

    public void \u5bf9\u7126\u5b8c\u6bd5(boolean result) {
        EventDispatcher.dispatchEvent(this, "\u5bf9\u7126\u5b8c\u6bd5", result);
    }

    public void \u62cd\u6444\u7167\u7247(String path, int format, int rate) {
        if (this.cv != null) {
            this.\u62cd\u7167\u65b9\u5f0f = 1;
            this.cv.takePicture(path, format, rate);
        }
    }

    public void \u62cd\u7167\u5b8c\u6bd5(String path) {
        EventDispatcher.dispatchEvent(this, "\u62cd\u7167\u5b8c\u6bd5", path);
    }

    public void \u62cd\u6444\u7167\u72472(int format, int rate) {
        if (this.cv != null) {
            this.\u62cd\u7167\u65b9\u5f0f = 2;
            this.cv.takePicture("", format, rate);
        }
    }

    public void \u62cd\u7167\u5b8c\u6bd52(byte[] data) {
        EventDispatcher.dispatchEvent(this, "\u62cd\u7167\u5b8c\u6bd52", new Object[]{data});
    }

    public void \u5f00\u59cb\u5f55\u50cf(String path, int format, int rate, boolean sound) {
        if (this.cv != null) {
            this.cv.takeVideo(path, format, rate, sound);
        }
    }

    public void \u505c\u6b62\u5f55\u50cf() {
        if (this.cv != null) {
            this.cv.stopVideo();
        }
    }

    public void \u5f00\u542f\u95ea\u5149\u706f() {
        if (this.cv != null) {
            this.cv.openFlashlight();
        }
    }

    public void \u5173\u95ed\u95ea\u5149\u706f() {
        if (this.cv != null) {
            this.cv.closeFlashlight();
        }
    }

    public void \u5173\u95ed\u6444\u50cf\u5934() {
        if (this.cv != null) {
            this.cv.close();
            this.layout.removeView((View)this.cv);
            this.cv = null;
        }
    }

    public void \u83b7\u5f97\u9884\u89c8\u5c3a\u5bf8\u5217\u8868(String \u5c3a\u5bf8\u5217\u8868) {
        EventDispatcher.dispatchEvent(this, "\u83b7\u5f97\u9884\u89c8\u5c3a\u5bf8\u5217\u8868", \u5c3a\u5bf8\u5217\u8868);
    }

    public void \u83b7\u5f97\u7167\u7247\u5c3a\u5bf8\u5217\u8868(String \u5c3a\u5bf8\u5217\u8868) {
        EventDispatcher.dispatchEvent(this, "\u83b7\u5f97\u7167\u7247\u5c3a\u5bf8\u5217\u8868", \u5c3a\u5bf8\u5217\u8868);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CameraSizeComparator
    implements Comparator<Camera.Size> {
        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            if (lhs.width == rhs.width) {
                return 0;
            }
            if (lhs.width > rhs.width) {
                return 1;
            }
            return -1;
        }
    }

    public class CameraView
    extends SurfaceView
    implements SurfaceHolder.Callback {
        private MediaRecorder mMediaRecorder;
        private SurfaceHolder mHolder;
        private Camera mCamera;
        private String savePath1;
        private int \u538b\u7f29\u7387;
        private int \u56fe\u7247\u683c\u5f0f;
        private List<Camera.Size> list1;
        private List<Camera.Size> list2;
        private int \u6700\u4f73\u7167\u7247\u5bbd\u5ea6;
        private int \u6700\u4f73\u7167\u7247\u9ad8\u5ea6;
        private int \u6700\u4f73\u9884\u89c8\u5bbd\u5ea6;
        private int \u6700\u4f73\u9884\u89c8\u9ad8\u5ea6;
        private Camera.PictureCallback jpegCallback;

        CameraView(Context context) {
            super(context);
            this.list1 = null;
            this.list2 = null;
            this.\u6700\u4f73\u7167\u7247\u5bbd\u5ea6 = -1;
            this.\u6700\u4f73\u7167\u7247\u9ad8\u5ea6 = -1;
            this.\u6700\u4f73\u9884\u89c8\u5bbd\u5ea6 = -1;
            this.\u6700\u4f73\u9884\u89c8\u9ad8\u5ea6 = -1;
            this.jpegCallback = new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Bitmap CameraBitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix m = new Matrix();
                    if (\u6444\u50cf\u6846Impl.this.\u6444\u50cf\u5934\u7c7b\u578b == 1) {
                        if (\u6444\u50cf\u6846Impl.this.\u5c4f\u5e55\u65b9\u5411 == 1) {
                            m.setRotate(270.0f, (float)CameraBitmap.getWidth() / 2.0f, (float)CameraBitmap.getHeight() / 2.0f);
                        }
                    } else if (\u6444\u50cf\u6846Impl.this.\u5c4f\u5e55\u65b9\u5411 == 1) {
                        m.setRotate(90.0f, (float)CameraBitmap.getWidth() / 2.0f, (float)CameraBitmap.getHeight() / 2.0f);
                    }
                    Bitmap bm = Bitmap.createBitmap((Bitmap)CameraBitmap, (int)0, (int)0, (int)CameraBitmap.getWidth(), (int)CameraBitmap.getHeight(), (Matrix)m, (boolean)true);
                    if (\u6444\u50cf\u6846Impl.this.\u62cd\u7167\u65b9\u5f0f == 1) {
                        File myCaptureFile = new File(CameraView.this.savePath1);
                        try {
                            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
                            if (CameraView.this.\u56fe\u7247\u683c\u5f0f == 1) {
                                bm.compress(Bitmap.CompressFormat.JPEG, CameraView.this.\u538b\u7f29\u7387, (OutputStream)bos);
                            } else {
                                bm.compress(Bitmap.CompressFormat.PNG, CameraView.this.\u538b\u7f29\u7387, (OutputStream)bos);
                            }
                            bos.flush();
                            bos.close();
                            \u6444\u50cf\u6846Impl.this.\u62cd\u7167\u5b8c\u6bd5(CameraView.this.savePath1);
                        }
                        catch (Exception e) {
                            e.getMessage();
                        }
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        if (CameraView.this.\u56fe\u7247\u683c\u5f0f == 1) {
                            bm.compress(Bitmap.CompressFormat.JPEG, CameraView.this.\u538b\u7f29\u7387, (OutputStream)baos);
                        } else {
                            bm.compress(Bitmap.CompressFormat.PNG, CameraView.this.\u538b\u7f29\u7387, (OutputStream)baos);
                        }
                        \u6444\u50cf\u6846Impl.this.\u62cd\u7167\u5b8c\u6bd52(baos.toByteArray());
                    }
                    CameraView.this.mCamera.stopPreview();
                    CameraView.this.mCamera.startPreview();
                }
            };
            this.mHolder = this.getHolder();
            this.mHolder.addCallback((SurfaceHolder.Callback)this);
            this.mHolder.setType(3);
            this.mHolder.setKeepScreenOn(true);
        }

        public void surfaceCreated(SurfaceHolder holder) {
            int cameraCount = 0;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            cameraCount = Camera.getNumberOfCameras();
            if (cameraCount == 1) {
                this.mCamera = Camera.open();
            } else {
                for (int camIdx = 0; camIdx < cameraCount; ++camIdx) {
                    Camera.getCameraInfo((int)camIdx, (Camera.CameraInfo)cameraInfo);
                    if (\u6444\u50cf\u6846Impl.this.\u6444\u50cf\u5934\u7c7b\u578b == 1) {
                        if (cameraInfo.facing != 1) continue;
                        try {
                            this.mCamera = Camera.open((int)camIdx);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (cameraInfo.facing != 0) continue;
                    try {
                        this.mCamera = Camera.open((int)camIdx);
                        continue;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                this.mCamera.setPreviewDisplay(holder);
                this.initCamera();
                this.mCamera.startPreview();
            }
            catch (IOException exception) {
                this.mCamera.release();
                this.mCamera = null;
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    if (success) {
                        CameraView.this.initCamera();
                        CameraView.this.mCamera.cancelAutoFocus();
                    }
                }
            });
        }

        private void initCamera() {
            Camera.Parameters parameters = this.mCamera.getParameters();
            parameters.setPictureFormat(256);
            if (this.list1 == null) {
                boolean \u5df2\u5339\u914d1 = false;
                this.list1 = parameters.getSupportedPictureSizes();
                if (this.list1 != null) {
                    Collections.sort(this.list1, \u6444\u50cf\u6846Impl.this.sizeComparator);
                    String result1 = "";
                    for (int i = 0; i < this.list1.size(); ++i) {
                        result1 = result1.equals("") ? "" + this.list1.get((int)i).height + "\u00d7" + this.list1.get((int)i).width : result1 + "\n" + this.list1.get((int)i).height + "\u00d7" + this.list1.get((int)i).width;
                        if (\u5df2\u5339\u914d1) continue;
                        if (\u6444\u50cf\u6846Impl.this.width == this.list1.get((int)i).height && \u6444\u50cf\u6846Impl.this.height == this.list1.get((int)i).width) {
                            this.\u6700\u4f73\u7167\u7247\u5bbd\u5ea6 = \u6444\u50cf\u6846Impl.this.height;
                            this.\u6700\u4f73\u7167\u7247\u9ad8\u5ea6 = \u6444\u50cf\u6846Impl.this.width;
                            \u5df2\u5339\u914d1 = true;
                            continue;
                        }
                        if (this.list1.get((int)i).height > \u6444\u50cf\u6846Impl.this.width) continue;
                        this.\u6700\u4f73\u7167\u7247\u5bbd\u5ea6 = this.list1.get((int)i).width;
                        this.\u6700\u4f73\u7167\u7247\u9ad8\u5ea6 = this.list1.get((int)i).height;
                    }
                    \u6444\u50cf\u6846Impl.this.\u83b7\u5f97\u7167\u7247\u5c3a\u5bf8\u5217\u8868(result1);
                }
            }
            if (this.list2 == null) {
                boolean \u5df2\u5339\u914d2 = false;
                this.list2 = parameters.getSupportedPreviewSizes();
                if (this.list2 != null) {
                    Collections.sort(this.list2, \u6444\u50cf\u6846Impl.this.sizeComparator);
                    String result2 = "";
                    for (int j = 0; j < this.list2.size(); ++j) {
                        result2 = result2.equals("") ? "" + this.list2.get((int)j).height + "\u00d7" + this.list2.get((int)j).width : result2 + "\n" + this.list2.get((int)j).height + "\u00d7" + this.list2.get((int)j).width;
                        if (\u5df2\u5339\u914d2) continue;
                        if (\u6444\u50cf\u6846Impl.this.width == this.list2.get((int)j).height && \u6444\u50cf\u6846Impl.this.height == this.list2.get((int)j).width) {
                            this.\u6700\u4f73\u9884\u89c8\u5bbd\u5ea6 = \u6444\u50cf\u6846Impl.this.height;
                            this.\u6700\u4f73\u9884\u89c8\u9ad8\u5ea6 = \u6444\u50cf\u6846Impl.this.width;
                            \u5df2\u5339\u914d2 = true;
                            continue;
                        }
                        if (this.list2.get((int)j).height > \u6444\u50cf\u6846Impl.this.width) continue;
                        this.\u6700\u4f73\u9884\u89c8\u5bbd\u5ea6 = this.list2.get((int)j).width;
                        this.\u6700\u4f73\u9884\u89c8\u9ad8\u5ea6 = this.list2.get((int)j).height;
                    }
                    \u6444\u50cf\u6846Impl.this.\u83b7\u5f97\u9884\u89c8\u5c3a\u5bf8\u5217\u8868(result2);
                }
            }
            if (this.\u6700\u4f73\u9884\u89c8\u5bbd\u5ea6 != -1) {
                parameters.setPreviewSize(this.\u6700\u4f73\u9884\u89c8\u5bbd\u5ea6, this.\u6700\u4f73\u9884\u89c8\u9ad8\u5ea6);
            }
            if (this.\u6700\u4f73\u7167\u7247\u5bbd\u5ea6 != -1) {
                parameters.setPictureSize(this.\u6700\u4f73\u7167\u7247\u5bbd\u5ea6, this.\u6700\u4f73\u7167\u7247\u9ad8\u5ea6);
            }
            if (\u6444\u50cf\u6846Impl.this.\u95ea\u5149\u706f) {
                parameters.setFlashMode("torch");
            } else {
                parameters.setFlashMode("off");
            }
            if (\u6444\u50cf\u6846Impl.this.\u6444\u50cf\u5934\u7c7b\u578b == 2) {
                parameters.setFocusMode("continuous-picture");
            }
            if (\u6444\u50cf\u6846Impl.this.\u5c4f\u5e55\u65b9\u5411 == 1) {
                if (Build.VERSION.SDK_INT >= 8) {
                    this.setDisplayOrientation(this.mCamera, 90);
                } else {
                    parameters.setRotation(90);
                }
            }
            this.mCamera.setParameters(parameters);
            this.mCamera.startPreview();
            this.mCamera.cancelAutoFocus();
        }

        private void setDisplayOrientation(Camera camera, int angle) {
            try {
                Method downPolymorphic = camera.getClass().getMethod("setDisplayOrientation", Integer.TYPE);
                if (downPolymorphic != null) {
                    downPolymorphic.invoke((Object)camera, angle);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void focus() {
            if (this.mCamera != null) {
                this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                    public void onAutoFocus(boolean success, Camera camera) {
                        \u6444\u50cf\u6846Impl.this.\u5bf9\u7126\u5b8c\u6bd5(success);
                        CameraView.this.mCamera.cancelAutoFocus();
                    }
                });
            }
        }

        public void takePicture(String path, int format, int rate) {
            if (this.mCamera != null) {
                this.savePath1 = path;
                this.\u538b\u7f29\u7387 = rate;
                this.\u56fe\u7247\u683c\u5f0f = format;
                this.mCamera.takePicture(null, null, this.jpegCallback);
            }
        }

        private File createFile(String path) {
            try {
                File file = new File(path);
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    file.createNewFile();
                } else {
                    file.delete();
                }
                return file;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected boolean prepareRecord(String path, int format, int rate, boolean sound) {
            File file = this.createFile(path);
            this.mMediaRecorder = new MediaRecorder();
            this.mMediaRecorder.reset();
            this.mCamera.unlock();
            this.mMediaRecorder.setCamera(this.mCamera);
            if (sound) {
                this.mMediaRecorder.setAudioSource(1);
            }
            this.mMediaRecorder.setVideoSource(1);
            CamcorderProfile mProfile = CamcorderProfile.get((int)1);
            this.mMediaRecorder.setOutputFormat(mProfile.fileFormat);
            if (sound) {
                this.mMediaRecorder.setAudioEncoder(mProfile.audioCodec);
            }
            this.mMediaRecorder.setVideoEncoder(mProfile.videoCodec);
            this.mMediaRecorder.setVideoSize(mProfile.videoFrameWidth, mProfile.videoFrameHeight);
            this.mMediaRecorder.setVideoFrameRate(mProfile.videoFrameRate);
            this.mMediaRecorder.setVideoEncodingBitRate(mProfile.videoBitRate);
            if (sound) {
                this.mMediaRecorder.setAudioEncodingBitRate(mProfile.audioBitRate);
                this.mMediaRecorder.setAudioChannels(mProfile.audioChannels);
                this.mMediaRecorder.setAudioSamplingRate(mProfile.audioSampleRate);
            }
            if (\u6444\u50cf\u6846Impl.this.\u6444\u50cf\u5934\u7c7b\u578b == 2) {
                this.mMediaRecorder.setOrientationHint(90);
            } else {
                this.mMediaRecorder.setOrientationHint(270);
            }
            this.mMediaRecorder.setOutputFile(file.getAbsolutePath());
            this.mMediaRecorder.setPreviewDisplay(this.mHolder.getSurface());
            this.mMediaRecorder.setOnErrorListener(new MediaRecorder.OnErrorListener(){

                public void onError(MediaRecorder mr, int what, int extra) {
                    CameraView.this.mMediaRecorder.stop();
                    CameraView.this.mMediaRecorder.release();
                    CameraView.this.mMediaRecorder = null;
                }
            });
            try {
                this.mMediaRecorder.prepare();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public void takeVideo(String path, int format, int rate, boolean sound) {
            if (this.prepareRecord(path, format, rate, sound)) {
                this.mMediaRecorder.start();
            }
        }

        public void stopVideo() {
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.stop();
                this.mMediaRecorder.release();
                this.mMediaRecorder = null;
            }
        }

        public void openFlashlight() {
            \u6444\u50cf\u6846Impl.this.\u95ea\u5149\u706f = true;
            this.initCamera();
        }

        public void closeFlashlight() {
            \u6444\u50cf\u6846Impl.this.\u95ea\u5149\u706f = false;
            this.initCamera();
        }

        public void close() {
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.release();
                this.mMediaRecorder = null;
            }
            if (this.mCamera != null) {
                this.mHolder.removeCallback((SurfaceHolder.Callback)this);
                this.mCamera.stopPreview();
                this.mCamera.release();
                this.mCamera = null;
            }
        }
    }
}

