/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n59;

import android.app.Activity;
import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.android.ViewComponent;
import com.e4a.runtime.components.impl.android.n59.CalendarView.adapter.CalendarGridViewAdapter;
import com.e4a.runtime.components.impl.android.n59.CalendarView.util.CalendarUtil;
import com.e4a.runtime.components.impl.android.n59.\u65e5\u5386;
import com.e4a.runtime.events.EventDispatcher;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class \u65e5\u5386Impl
extends ViewComponent
implements \u65e5\u5386,
AdapterView.OnItemClickListener {
    private CalendarGridViewAdapter currentGridAdapter;
    private GridView currentGridView;
    private Calendar currentCalendar;
    private int currentYear = 0;
    private int currentMonth = 0;
    private int currentDay = 0;
    private GestureDetector mGestureDetector;

    public \u65e5\u5386Impl(ComponentContainer container) {
        super(container);
    }

    @Override
    protected View createView() {
        this.currentCalendar = Calendar.getInstance();
        this.currentGridView = new GridView((Context)mainActivity.getContext());
        this.currentGridAdapter = new CalendarGridViewAdapter((Activity)mainActivity.getContext(), this.currentCalendar);
        this.currentGridView.setAdapter((ListAdapter)this.currentGridAdapter);
        this.currentGridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.currentGridView.setNumColumns(7);
        this.currentGridView.setStretchMode(2);
        this.currentGridView.setVerticalSpacing(1);
        this.currentGridView.setHorizontalSpacing(1);
        this.currentGridView.setBackgroundColor(-16776961);
        this.currentGridView.setPadding(0, 0, 0, 0);
        this.mGestureDetector = new GestureDetector((GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                int deltaX = (int)(e1.getRawX() - e2.getRawX());
                int deltaY = (int)(e1.getRawY() - e2.getRawY());
                if (Math.abs(deltaX) > Math.abs(deltaY)) {
                    int direction = deltaX > 0 ? 4 : 5;
                    \u65e5\u5386Impl.this.\u89e6\u6478\u624b\u52bf(direction);
                    return true;
                }
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                return false;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return false;
            }

            public boolean onDoubleTap(MotionEvent e) {
                return false;
            }
        });
        this.currentGridView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return \u65e5\u5386Impl.this.mGestureDetector.onTouchEvent(event);
            }
        });
        return this.currentGridView;
    }

    @Override
    public void \u89e6\u6478\u624b\u52bf(int direction) {
        EventDispatcher.dispatchEvent(this, "\u89e6\u6478\u624b\u52bf", direction);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        LinearLayout txtDay = (LinearLayout)this.currentGridView.findViewById(position + 5000);
        if (txtDay != null && txtDay.getTag() != null) {
            Date date = (Date)txtDay.getTag();
            Calendar calSelected = Calendar.getInstance();
            calSelected.setTime(date);
            this.currentGridAdapter.setSelectedDate(calSelected);
            this.currentGridAdapter.notifyDataSetChanged();
            this.\u65e5\u671f\u88ab\u9009\u62e9(CalendarUtil.getCurrentDay(calSelected));
        }
    }

    @Override
    public void \u65e5\u671f\u88ab\u9009\u62e9(String \u88ab\u9009\u62e9\u65e5\u671f) {
        EventDispatcher.dispatchEvent(this, "\u65e5\u671f\u88ab\u9009\u62e9", \u88ab\u9009\u62e9\u65e5\u671f);
    }

    @Override
    public String \u53d6\u519c\u5386(Calendar date) {
        CalendarUtil cu = new CalendarUtil(date);
        return cu.cyclical() + cu.animalsYear() + "\u5e74" + cu.getDay();
    }

    @Override
    public void \u663e\u793a\u4e0b\u4e2a\u6708() {
        this.currentGridAdapter.update(this.currentCalendar);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u663e\u793a\u4e0a\u4e2a\u6708() {
        this.currentCalendar.set(2, this.currentCalendar.get(2) - 2);
        this.currentGridAdapter.update(this.currentCalendar);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u663e\u793a\u73b0\u884c\u6708() {
        this.currentCalendar = Calendar.getInstance();
        this.currentGridAdapter.update(this.currentCalendar);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public int \u53d6\u73b0\u884c\u663e\u793a\u5e74\u4efd() {
        int year = this.currentCalendar.get(1);
        int month = this.currentCalendar.get(2);
        if (month == 0) {
            --year;
        }
        return year;
    }

    @Override
    public int \u53d6\u73b0\u884c\u663e\u793a\u6708\u4efd() {
        int month = this.currentCalendar.get(2);
        if (month == 0) {
            month = 12;
        }
        return month;
    }

    @Override
    public void \u9009\u62e9\u6307\u5b9a\u65e5\u671f(int year, int month, int day) {
        Calendar calSelected = Calendar.getInstance();
        calSelected.set(year, month - 1, day);
        this.currentGridAdapter.setSelectedDate(calSelected);
        this.currentGridAdapter.notifyDataSetChanged();
        this.currentGridView.invalidate();
    }

    @Override
    public void \u6807\u8bb0\u6307\u5b9a\u65e5\u671f(String[] date, int color) {
        Calendar[] calSelectedArray = new Calendar[date.length];
        for (int i = 0; i < date.length; ++i) {
            GregorianCalendar cal = new GregorianCalendar();
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                cal.setTime(dateFormat.parse(date[i]));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            calSelectedArray[i] = cal;
        }
        this.currentGridAdapter.setSelectedDateArray(calSelectedArray, color);
        this.currentGridAdapter.notifyDataSetChanged();
        this.currentGridView.invalidate();
    }

    @Override
    public void \u663e\u793a\u6307\u5b9a\u5e74\u6708(int year, int month) {
        this.currentCalendar.set(1, year);
        this.currentCalendar.set(2, month - 1);
        this.currentGridAdapter.update(this.currentCalendar);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u80cc\u666f\u989c\u8272(int color) {
        this.currentGridView.setBackgroundColor(color);
        this.currentGridView.invalidate();
    }

    @Override
    public void \u7f6e\u661f\u671f\u80cc\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u661f\u671f\u80cc\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u661f\u671f\u524d\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u661f\u671f\u524d\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u65e5\u671f\u80cc\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u65e5\u671f\u80cc\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u5f53\u524d\u65e5\u671f\u80cc\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u5f53\u524d\u65e5\u671f\u80cc\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u9009\u4e2d\u65e5\u671f\u80cc\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u9009\u4e2d\u65e5\u671f\u80cc\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u5f53\u524d\u6708\u516c\u5386\u524d\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u5f53\u524d\u6708\u516c\u5386\u524d\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u975e\u5f53\u524d\u6708\u516c\u5386\u524d\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u975e\u5f53\u524d\u6708\u516c\u5386\u524d\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u5f53\u524d\u6708\u519c\u5386\u524d\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u5f53\u524d\u6708\u519c\u5386\u524d\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }

    @Override
    public void \u7f6e\u975e\u5f53\u524d\u6708\u519c\u5386\u524d\u666f\u8272(int color) {
        this.currentGridAdapter.\u7f6e\u975e\u5f53\u524d\u6708\u519c\u5386\u524d\u666f\u8272(color);
        this.currentGridAdapter.notifyDataSetChanged();
    }
}

