/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n50;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.android.Information;
import com.e4a.runtime.components.impl.android.ViewComponent;
import com.e4a.runtime.components.impl.android.n50.\u6298\u7ebf\u56fe;
import com.e4a.runtime.\u5e94\u7528\u64cd\u4f5c;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.ChartFactory;
import org.achartengine.chart.PointStyle;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class \u6298\u7ebf\u56feImpl
extends ViewComponent
implements \u6298\u7ebf\u56fe {
    private int itemcolor;
    private ArrayList<Information> list;
    private String title;
    private String xtitle;
    private String ytitle;
    private float textsize;
    private int xcount;
    private View view = null;
    private Context context;
    private LinearLayout layout;
    private double maxValue = 0.0;

    public \u6298\u7ebf\u56feImpl(ComponentContainer container) {
        super(container);
    }

    @Override
    protected View createView() {
        this.context = mainActivity.getContext();
        this.layout = new LinearLayout(this.context);
        this.layout.setOrientation(1);
        this.layout.setHorizontalGravity(1);
        return this.layout;
    }

    @Override
    public void \u521d\u59cb\u5316\u56fe\u8868(String chartTitle, String xTitle, String yTitle, float textSize, int backColor, int itemColor) {
        this.title = chartTitle;
        this.xtitle = xTitle;
        this.ytitle = yTitle;
        this.textsize = textSize;
        this.layout.setBackgroundColor(backColor);
        this.itemcolor = itemColor;
        this.xcount = 0;
        this.maxValue = 0.0;
        this.list = new ArrayList();
    }

    @Override
    public void \u6dfb\u52a0\u6570\u636e(String name, String data, String unit) {
        this.list.add(new Information(name, data, unit, 0));
        ++this.xcount;
    }

    @Override
    public void \u6784\u5efa\u56fe\u8868() {
        int i;
        if (this.view != null) {
            this.layout.removeView(this.view);
        }
        String[] titles = new String[]{this.title};
        ArrayList<double[]> x = new ArrayList<double[]>();
        double[] xInfo = new double[this.list.size()];
        int count = 1;
        for (i = 0; i < this.list.size(); ++i) {
            xInfo[i] = count;
            ++count;
        }
        for (i = 0; i < titles.length; ++i) {
            x.add(xInfo);
        }
        double[] xValue = new double[this.list.size()];
        for (int i2 = 0; i2 < xValue.length; ++i2) {
            xValue[i2] = Double.parseDouble(this.list.get((int)i2).data);
            if (!(xValue[i2] > this.maxValue)) continue;
            this.maxValue = xValue[i2] + this.maxValue / 8.0;
        }
        ArrayList<double[]> values = new ArrayList<double[]>();
        values.add(xValue);
        int[] colors = new int[]{this.itemcolor};
        PointStyle[] styles = new PointStyle[]{PointStyle.DIAMOND};
        XYMultipleSeriesRenderer renderer = this.buildRenderer(colors, styles);
        int length = renderer.getSeriesRendererCount();
        for (int i3 = 0; i3 < length; ++i3) {
            ((XYSeriesRenderer)renderer.getSeriesRendererAt(i3)).setFillPoints(true);
            ((XYSeriesRenderer)renderer.getSeriesRendererAt(i3)).setLineWidth(2.0f);
        }
        this.setChartSettings(renderer);
        this.view = ChartFactory.getLineChartView((Context)this.context, (XYMultipleSeriesDataset)this.buildDataset(titles, x, values), (XYMultipleSeriesRenderer)renderer);
        LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(-1, -1);
        this.layout.addView(this.view, (ViewGroup.LayoutParams)param);
    }

    private XYMultipleSeriesRenderer buildRenderer(int[] colors, PointStyle[] styles) {
        XYMultipleSeriesRenderer renderer = new XYMultipleSeriesRenderer();
        this.setRenderer(renderer, colors, styles);
        return renderer;
    }

    private void setRenderer(XYMultipleSeriesRenderer renderer, int[] colors, PointStyle[] styles) {
        if (\u5e94\u7528\u64cd\u4f5c.\u662f\u5426\u81ea\u9002\u5e94()) {
            renderer.setAxisTitleTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setChartTitleTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setChartValuesTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setLabelsTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setLegendTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
        } else {
            renderer.setAxisTitleTextSize(this.textsize);
            renderer.setChartTitleTextSize(this.textsize);
            renderer.setChartValuesTextSize(this.textsize);
            renderer.setLabelsTextSize(this.textsize);
            renderer.setLegendTextSize(this.textsize);
        }
        renderer.setPointSize(5.0f);
        renderer.setMargins(new int[]{this.\u53d6\u76f8\u5bf9\u50cf\u7d20(20), this.\u53d6\u76f8\u5bf9\u50cf\u7d20(30), this.\u53d6\u76f8\u5bf9\u50cf\u7d20(45), this.\u53d6\u76f8\u5bf9\u50cf\u7d20(20)});
        int length = colors.length;
        for (int i = 0; i < length; ++i) {
            XYSeriesRenderer r = new XYSeriesRenderer();
            r.setColor(colors[i]);
            r.setPointStyle(styles[i]);
            renderer.addSeriesRenderer((SimpleSeriesRenderer)r);
        }
    }

    private int \u53d6\u76f8\u5bf9\u50cf\u7d20(int value) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)((float)value * scale + 0.5f);
    }

    private void setChartSettings(XYMultipleSeriesRenderer renderer) {
        renderer.setChartTitle(this.title);
        renderer.setXTitle(this.xtitle);
        renderer.setYTitle(this.ytitle);
        renderer.setXAxisMin(0.5);
        if (this.xcount <= 5) {
            renderer.setXAxisMax(5.5);
        } else {
            renderer.setXAxisMax((double)this.xcount + 0.5);
        }
        renderer.setYAxisMin(0.0);
        renderer.setYAxisMax(this.maxValue);
        renderer.setDisplayChartValues(true);
        renderer.setShowGrid(true);
        renderer.setXLabels(0);
        renderer.setBarSpacing(1.0);
        renderer.setXLabels(0);
        int tempNum = 1;
        for (Information information : this.list) {
            renderer.addXTextLabel((double)tempNum, information.name);
            ++tempNum;
        }
    }

    private XYMultipleSeriesDataset buildDataset(String[] titles, List<double[]> xValues, List<double[]> yValues) {
        XYMultipleSeriesDataset dataset = new XYMultipleSeriesDataset();
        this.addXYSeries(dataset, titles, xValues, yValues, 0);
        return dataset;
    }

    private void addXYSeries(XYMultipleSeriesDataset dataset, String[] titles, List<double[]> xValues, List<double[]> yValues, int scale) {
        int length = titles.length;
        for (int i = 0; i < length; ++i) {
            XYSeries series = new XYSeries(titles[i] + " (" + this.list.get((int)0).unit + ")", scale);
            double[] xV = xValues.get(i);
            double[] yV = yValues.get(i);
            int seriesLength = xV.length;
            for (int k = 0; k < seriesLength; ++k) {
                series.add(xV[k], yV[k]);
            }
            dataset.addSeries(series);
        }
    }
}

