/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n49;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.android.Information;
import com.e4a.runtime.components.impl.android.ViewComponent;
import com.e4a.runtime.components.impl.android.n49.\u67f1\u72b6\u56fe;
import com.e4a.runtime.\u5e94\u7528\u64cd\u4f5c;
import java.util.ArrayList;
import org.achartengine.ChartFactory;
import org.achartengine.chart.BarChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class \u67f1\u72b6\u56feImpl
extends ViewComponent
implements \u67f1\u72b6\u56fe {
    private int itemcolor;
    private ArrayList<Information> list;
    private String title;
    private String xtitle;
    private String ytitle;
    private float textsize;
    private int xcount;
    private View view = null;
    private Context context;
    private LinearLayout layout;
    private double maxValue = 0.0;

    public \u67f1\u72b6\u56feImpl(ComponentContainer container) {
        super(container);
    }

    @Override
    protected View createView() {
        this.context = mainActivity.getContext();
        this.layout = new LinearLayout(this.context);
        this.layout.setOrientation(1);
        this.layout.setHorizontalGravity(1);
        return this.layout;
    }

    @Override
    public void \u521d\u59cb\u5316\u56fe\u8868(String chartTitle, String xTitle, String yTitle, float textSize, int backColor, int itemColor) {
        this.title = chartTitle;
        this.xtitle = xTitle;
        this.ytitle = yTitle;
        this.textsize = textSize;
        this.layout.setBackgroundColor(backColor);
        this.itemcolor = itemColor;
        this.xcount = 0;
        this.maxValue = 0.0;
        this.list = new ArrayList();
    }

    @Override
    public void \u6dfb\u52a0\u6570\u636e(String name, String data, String unit) {
        this.list.add(new Information(name, data, unit, 0));
        double value = Double.parseDouble(data);
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        ++this.xcount;
    }

    @Override
    public void \u6784\u5efa\u56fe\u8868() {
        if (this.view != null) {
            this.layout.removeView(this.view);
        }
        this.maxValue += this.maxValue / 8.0;
        this.view = ChartFactory.getBarChartView((Context)this.context, (XYMultipleSeriesDataset)this.getBarDataset(this.list), (XYMultipleSeriesRenderer)this.getBarRenderer(this.list), (BarChart.Type)BarChart.Type.STACKED);
        LinearLayout.LayoutParams param = new LinearLayout.LayoutParams(-1, -1);
        this.layout.addView(this.view, (ViewGroup.LayoutParams)param);
    }

    private XYMultipleSeriesRenderer getBarRenderer(ArrayList<Information> informations) {
        XYMultipleSeriesRenderer renderer = new XYMultipleSeriesRenderer();
        SimpleSeriesRenderer r = new SimpleSeriesRenderer();
        r.setColor(this.itemcolor);
        renderer.addSeriesRenderer(r);
        this.setChartSettings(renderer, informations);
        return renderer;
    }

    private void setChartSettings(XYMultipleSeriesRenderer renderer, ArrayList<Information> informations) {
        if (\u5e94\u7528\u64cd\u4f5c.\u662f\u5426\u81ea\u9002\u5e94()) {
            renderer.setAxisTitleTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setChartTitleTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setChartValuesTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setLabelsTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
            renderer.setLegendTextSize(\u5e94\u7528\u64cd\u4f5c.\u8f6c\u6362\u5b57\u4f53\u5927\u5c0f(this.textsize));
        } else {
            renderer.setAxisTitleTextSize(this.textsize);
            renderer.setChartTitleTextSize(this.textsize);
            renderer.setChartValuesTextSize(this.textsize);
            renderer.setLabelsTextSize(this.textsize);
            renderer.setLegendTextSize(this.textsize);
        }
        renderer.setChartTitle(this.title);
        renderer.setXTitle(this.xtitle);
        renderer.setYTitle(this.ytitle);
        renderer.setXAxisMin(0.5);
        if (this.xcount <= 5) {
            renderer.setXAxisMax(5.5);
        } else {
            renderer.setXAxisMax((double)this.xcount + 0.5);
        }
        renderer.setMargins(new int[]{this.\u53d6\u76f8\u5bf9\u50cf\u7d20(20), this.\u53d6\u76f8\u5bf9\u50cf\u7d20(30), this.\u53d6\u76f8\u5bf9\u50cf\u7d20(45), this.\u53d6\u76f8\u5bf9\u50cf\u7d20(20)});
        renderer.setYAxisMin(0.0);
        renderer.setYAxisMax(this.maxValue);
        renderer.setDisplayChartValues(true);
        renderer.setShowGrid(true);
        renderer.setXLabels(0);
        renderer.setBarSpacing(0.2);
        int count = 1;
        for (Information information : informations) {
            renderer.addXTextLabel((double)count, information.name);
            ++count;
        }
    }

    private int \u53d6\u76f8\u5bf9\u50cf\u7d20(int value) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)((float)value * scale + 0.5f);
    }

    private XYMultipleSeriesDataset getBarDataset(ArrayList<Information> informations) {
        XYMultipleSeriesDataset dataset = new XYMultipleSeriesDataset();
        CategorySeries series = new CategorySeries(this.title + " (\u5355\u4f4d\uff1a" + informations.get((int)0).unit + ")");
        for (Information information : informations) {
            series.add(Double.parseDouble(information.data));
        }
        dataset.addSeries(series.toXYSeries());
        return dataset;
    }
}

