/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n46.gifview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.e4a.runtime.components.impl.android.n46.gifview.GifAction;
import com.e4a.runtime.components.impl.android.n46.gifview.GifDecoder;
import com.e4a.runtime.components.impl.android.n46.gifview.GifFrame;
import java.io.InputStream;

public class GifView
extends View
implements GifAction {
    private GifDecoder gifDecoder = null;
    private Bitmap currentImage = null;
    private boolean isRun = true;
    private boolean pause = false;
    private int showWidth = -1;
    private int showHeight = -1;
    private Rect rect = null;
    private DrawThread drawThread = null;
    private GifImageType animationType = GifImageType.SYNC_DECODER;
    private Handler redrawHandler = new Handler(){

        public void handleMessage(Message msg) {
            GifView.this.invalidate();
        }
    };

    public GifView(Context context) {
        super(context);
    }

    public GifView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GifView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private void setGifDecoderImage(byte[] gif) {
        if (this.gifDecoder != null) {
            this.gifDecoder.free();
            this.gifDecoder = null;
        }
        this.gifDecoder = new GifDecoder(gif, (GifAction)this);
        this.gifDecoder.start();
    }

    private void setGifDecoderImage(InputStream is) {
        if (this.gifDecoder != null) {
            this.gifDecoder.free();
            this.gifDecoder = null;
        }
        this.gifDecoder = new GifDecoder(is, (GifAction)this);
        this.gifDecoder.start();
    }

    public void setGifImage(byte[] gif) {
        this.pause = true;
        this.isRun = false;
        this.drawThread = null;
        this.setGifDecoderImage(gif);
    }

    public void setGifImage(InputStream is) {
        this.pause = true;
        this.isRun = false;
        this.drawThread = null;
        this.setGifDecoderImage(is);
    }

    public void setGifImage(int resId) {
        this.pause = true;
        this.isRun = false;
        this.drawThread = null;
        Resources r = this.getResources();
        InputStream is = r.openRawResource(resId);
        this.setGifDecoderImage(is);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.gifDecoder == null) {
            return;
        }
        if (this.currentImage == null) {
            this.currentImage = this.gifDecoder.getImage();
        }
        if (this.currentImage == null) {
            return;
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        if (this.showWidth == -1) {
            canvas.drawBitmap(this.currentImage, 0.0f, 0.0f, null);
        } else {
            canvas.drawBitmap(this.currentImage, null, this.rect, null);
        }
        canvas.restoreToCount(saveCount);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int h;
        int w;
        int pleft = this.getPaddingLeft();
        int pright = this.getPaddingRight();
        int ptop = this.getPaddingTop();
        int pbottom = this.getPaddingBottom();
        if (this.gifDecoder == null) {
            w = 1;
            h = 1;
        } else {
            w = this.gifDecoder.width;
            h = this.gifDecoder.height;
        }
        w += pleft + pright;
        h += ptop + pbottom;
        w = Math.max(w, this.getSuggestedMinimumWidth());
        h = Math.max(h, this.getSuggestedMinimumHeight());
        int widthSize = GifView.resolveSize((int)w, (int)widthMeasureSpec);
        int heightSize = GifView.resolveSize((int)h, (int)heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public void showCover() {
        if (this.gifDecoder == null) {
            return;
        }
        this.pause = true;
        this.currentImage = this.gifDecoder.getImage();
        this.invalidate();
    }

    public void showAnimation() {
        if (this.pause) {
            this.pause = false;
        }
    }

    public void setGifImageType(GifImageType type) {
        if (this.gifDecoder == null) {
            this.animationType = type;
        }
    }

    public void setShowDimension(int width, int height) {
        if (width > 0 && height > 0) {
            this.showWidth = width;
            this.showHeight = height;
            this.rect = new Rect();
            this.rect.left = 0;
            this.rect.top = 0;
            this.rect.right = width;
            this.rect.bottom = height;
        }
    }

    public void parseOk(boolean parseStatus, int frameIndex) {
        if (parseStatus) {
            if (this.gifDecoder != null) {
                switch (this.animationType) {
                    case WAIT_FINISH: {
                        if (frameIndex != -1) break;
                        if (this.gifDecoder.getFrameCount() > 1) {
                            this.isRun = true;
                            this.pause = false;
                            DrawThread dt = new DrawThread();
                            dt.start();
                            break;
                        }
                        this.reDraw();
                        break;
                    }
                    case COVER: {
                        if (frameIndex == 1) {
                            this.currentImage = this.gifDecoder.getImage();
                            this.reDraw();
                            break;
                        }
                        if (frameIndex != -1) break;
                        if (this.gifDecoder.getFrameCount() > 1) {
                            if (this.drawThread != null) break;
                            this.isRun = true;
                            this.pause = false;
                            this.drawThread = new DrawThread();
                            this.drawThread.start();
                            break;
                        }
                        this.reDraw();
                        break;
                    }
                    case SYNC_DECODER: {
                        if (frameIndex == 1) {
                            this.currentImage = this.gifDecoder.getImage();
                            this.reDraw();
                            break;
                        }
                        if (frameIndex == -1) {
                            this.reDraw();
                            break;
                        }
                        if (this.drawThread != null) break;
                        this.isRun = true;
                        this.pause = false;
                        this.drawThread = new DrawThread();
                        this.drawThread.start();
                    }
                }
            } else {
                Log.e((String)"gif", (String)"parse error");
            }
        }
    }

    private void reDraw() {
        if (this.redrawHandler != null) {
            Message msg = this.redrawHandler.obtainMessage();
            this.redrawHandler.sendMessage(msg);
        }
    }

    private class DrawThread
    extends Thread {
        private DrawThread() {
        }

        public void run() {
            if (GifView.this.gifDecoder == null) {
                return;
            }
            while (GifView.this.isRun) {
                if (!GifView.this.pause) {
                    if (GifView.this.gifDecoder.parseOk()) {
                        GifFrame frame = GifView.this.gifDecoder.next();
                        GifView.this.currentImage = frame.image;
                        long sp = frame.delay;
                        if (GifView.this.redrawHandler == null) break;
                        Message msg = GifView.this.redrawHandler.obtainMessage();
                        GifView.this.redrawHandler.sendMessage(msg);
                        SystemClock.sleep((long)sp);
                        continue;
                    }
                    GifView.this.currentImage = GifView.this.gifDecoder.getImage();
                    break;
                }
                SystemClock.sleep((long)10L);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GifImageType {
        WAIT_FINISH(0),
        SYNC_DECODER(1),
        COVER(2);

        final int nativeInt;

        private GifImageType(int i) {
            this.nativeInt = i;
        }
    }
}

