/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n43;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

public class PermissionHelper {
    private static final int READ_PHONE_STATE_CODE = 101;
    private static final int WRITE_EXTERNAL_STORAGE_CODE = 102;
    private static final int REQUEST_OPEN_APPLICATION_SETTINGS_CODE = 12345;
    private PermissionModel[] mPermissionModels = new PermissionModel[]{new PermissionModel("\u7535\u8bdd", "android.permission.READ_PHONE_STATE", "\u6211\u4eec\u9700\u8981\u8bfb\u53d6\u624b\u673a\u4fe1\u606f\u7684\u6743\u9650\u6765\u6807\u8bc6\u60a8\u7684\u8eab\u4efd", 101), new PermissionModel("\u5b58\u50a8\u7a7a\u95f4", "android.permission.WRITE_EXTERNAL_STORAGE", "\u6211\u4eec\u9700\u8981\u60a8\u5141\u8bb8\u6211\u4eec\u8bfb\u5199\u4f60\u7684\u5b58\u50a8\u5361\uff0c\u4ee5\u65b9\u4fbf\u6211\u4eec\u4e34\u65f6\u4fdd\u5b58\u4e00\u4e9b\u6570\u636e", 102)};
    private Activity mActivity;
    private OnApplyPermissionListener mOnApplyPermissionListener;

    public PermissionHelper(Activity activity) {
        this.mActivity = activity;
    }

    public void setOnApplyPermissionListener(OnApplyPermissionListener onApplyPermissionListener) {
        this.mOnApplyPermissionListener = onApplyPermissionListener;
    }

    public void applyPermissions() {
        try {
            for (PermissionModel model : this.mPermissionModels) {
                if (0 == ContextCompat.checkSelfPermission((Context)this.mActivity, (String)model.permission)) continue;
                ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])new String[]{model.permission}, (int)model.requestCode);
                return;
            }
            if (this.mOnApplyPermissionListener != null) {
                this.mOnApplyPermissionListener.onAfterApplyAllPermission();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 101: 
            case 102: {
                if (0 != grantResults[0]) {
                    if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.mActivity, (String)permissions[0])) {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity).setTitle((CharSequence)"\u6743\u9650\u7533\u8bf7").setMessage((CharSequence)this.findPermissionExplain(permissions[0])).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                PermissionHelper.this.applyPermissions();
                            }
                        });
                        builder.setCancelable(false);
                        builder.show();
                    } else {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity).setTitle((CharSequence)"\u6743\u9650\u7533\u8bf7").setMessage((CharSequence)("\u8bf7\u5728\u6253\u5f00\u7684\u7a97\u53e3\u7684\u6743\u9650\u4e2d\u5f00\u542f" + this.findPermissionName(permissions[0]) + "\u6743\u9650\uff0c\u4ee5\u6b63\u5e38\u4f7f\u7528\u672c\u5e94\u7528")).setPositiveButton((CharSequence)"\u53bb\u8bbe\u7f6e", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                PermissionHelper.this.openApplicationSettings(12345);
                            }
                        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                PermissionHelper.this.mActivity.finish();
                            }
                        });
                        builder.setCancelable(false);
                        builder.show();
                    }
                    return;
                }
                if (this.isAllRequestedPermissionGranted()) {
                    if (this.mOnApplyPermissionListener == null) break;
                    this.mOnApplyPermissionListener.onAfterApplyAllPermission();
                    break;
                }
                this.applyPermissions();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 12345: {
                if (this.isAllRequestedPermissionGranted()) {
                    if (this.mOnApplyPermissionListener == null) break;
                    this.mOnApplyPermissionListener.onAfterApplyAllPermission();
                    break;
                }
                this.mActivity.finish();
            }
        }
    }

    public boolean isAllRequestedPermissionGranted() {
        for (PermissionModel model : this.mPermissionModels) {
            if (0 == ContextCompat.checkSelfPermission((Context)this.mActivity, (String)model.permission)) continue;
            return false;
        }
        return true;
    }

    private boolean openApplicationSettings(int requestCode) {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)("package:" + this.mActivity.getPackageName())));
            intent.addCategory("android.intent.category.DEFAULT");
            this.mActivity.startActivityForResult(intent, requestCode);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String findPermissionExplain(String permission) {
        if (this.mPermissionModels != null) {
            for (PermissionModel model : this.mPermissionModels) {
                if (model == null || model.permission == null || !model.permission.equals(permission)) continue;
                return model.explain;
            }
        }
        return null;
    }

    private String findPermissionName(String permission) {
        if (this.mPermissionModels != null) {
            for (PermissionModel model : this.mPermissionModels) {
                if (model == null || model.permission == null || !model.permission.equals(permission)) continue;
                return model.name;
            }
        }
        return null;
    }

    public static interface OnApplyPermissionListener {
        public void onAfterApplyAllPermission();
    }

    private static class PermissionModel {
        public String name;
        public String permission;
        public String explain;
        public int requestCode;

        public PermissionModel(String name, String permission, String explain, int requestCode) {
            this.name = name;
            this.permission = permission;
            this.explain = explain;
            this.requestCode = requestCode;
        }
    }
}

