/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n40;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.text.format.Formatter;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.n40.WIFI\u7ba1\u7406;
import com.e4a.runtime.components.impl.android.n40.WifiApAdmin;
import com.e4a.runtime.events.EventDispatcher;
import com.e4a.runtime.\u4e0a\u4e0b\u6587\u64cd\u4f5c;
import com.e4a.runtime.\u8f6c\u6362\u64cd\u4f5c;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class WIFI\u7ba1\u7406Impl
extends ComponentImpl
implements WIFI\u7ba1\u7406 {
    private final WifiManager wm = (WifiManager)\u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().getSystemService("wifi");
    private WifiApAdmin wifiAp;
    private boolean \u5df2\u626b\u63cf = false;
    private boolean \u9996\u6b21\u542f\u52a8a = true;
    private boolean \u9996\u6b21\u542f\u52a8b = true;
    private WifiManager.WifiLock mWifiLock;

    public WIFI\u7ba1\u7406Impl(ComponentContainer container) {
        super(container);
        this.\u6ce8\u518c\u5e7f\u64ad();
    }

    public int \u53d6\u5df2\u4fdd\u5b58\u7f51\u7edc(String SSID) {
        List existingConfigs = this.wm.getConfiguredNetworks();
        for (WifiConfiguration config : existingConfigs) {
            if (!config.SSID.equals("\"" + SSID + "\"")) continue;
            return config.networkId;
        }
        return -1;
    }

    public String[] \u53d6\u5df2\u4fdd\u5b58\u7f51\u7edc\u5217\u8868() {
        ArrayList<String> list = new ArrayList<String>();
        List existingConfigs = this.wm.getConfiguredNetworks();
        String str = "";
        for (WifiConfiguration config : existingConfigs) {
            str = this.\u5b50\u6587\u672c\u66ff\u6362(config.SSID, "\"", "");
            list.add(str + "|*|" + config.networkId);
        }
        int size = list.size();
        String[] array = new String[size];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (String)list.get(i);
        }
        return array;
    }

    public void \u6253\u5f00WIFI\u8bbe\u7f6e() {
        mainActivity.getContext().startActivity(new Intent("android.settings.WIFI_SETTINGS"));
    }

    public boolean \u7f6eWIFI\u72b6\u6001(boolean \u662f\u5426\u5f00\u542f) {
        return this.wm.setWifiEnabled(\u662f\u5426\u5f00\u542f);
    }

    public boolean \u662f\u5426\u5df2\u5f00\u542f() {
        return this.wm.isWifiEnabled();
    }

    public boolean \u7f6e\u6307\u5b9aWIFI\u72b6\u6001(int networkid, boolean \u662f\u5426\u8fde\u63a5) {
        return this.wm.enableNetwork(networkid, \u662f\u5426\u8fde\u63a5);
    }

    public int \u53d6\u8fde\u63a5\u72b6\u6001(int networkid) {
        if (networkid < 0) {
            return 1;
        }
        try {
            ArrayList list = new ArrayList();
            List existingConfigs = this.wm.getConfiguredNetworks();
            if (networkid > existingConfigs.size()) {
                return 1;
            }
            WifiConfiguration config = (WifiConfiguration)existingConfigs.get(networkid);
            if (config != null) {
                return config.status;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public boolean \u5f00\u59cb\u626b\u63cf() {
        if (!this.\u5df2\u626b\u63cf) {
            this.\u5df2\u626b\u63cf = true;
            return this.wm.startScan();
        }
        return false;
    }

    private void \u6ce8\u518c\u5e7f\u64ad() {
        BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                int errorCode;
                String str = arg1.getAction();
                if (str.equals("android.net.wifi.SCAN_RESULTS")) {
                    if (WIFI\u7ba1\u7406Impl.this.\u5df2\u626b\u63cf) {
                        WIFI\u7ba1\u7406Impl.this.\u5df2\u626b\u63cf = false;
                        WIFI\u7ba1\u7406Impl.this.\u626b\u63cf\u5b8c\u6bd5();
                    }
                } else if (str.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    if (!WIFI\u7ba1\u7406Impl.this.\u9996\u6b21\u542f\u52a8a) {
                        WIFI\u7ba1\u7406Impl.this.\u5f00\u542f\u72b6\u6001\u6539\u53d8(WIFI\u7ba1\u7406Impl.this.\u662f\u5426\u5df2\u5f00\u542f());
                    } else {
                        WIFI\u7ba1\u7406Impl.this.\u9996\u6b21\u542f\u52a8a = false;
                    }
                } else if (str.equals("android.net.wifi.STATE_CHANGE")) {
                    if (!WIFI\u7ba1\u7406Impl.this.\u9996\u6b21\u542f\u52a8b) {
                        NetworkInfo.State state = ((NetworkInfo)arg1.getParcelableExtra("networkInfo")).getState();
                        int temp = 1;
                        if (state == NetworkInfo.State.CONNECTED) {
                            temp = 1;
                        } else if (state == NetworkInfo.State.CONNECTING) {
                            temp = 2;
                        } else if (state == NetworkInfo.State.DISCONNECTED) {
                            temp = 3;
                        } else if (state == NetworkInfo.State.DISCONNECTING) {
                            temp = 4;
                        } else if (state == NetworkInfo.State.SUSPENDED) {
                            temp = 5;
                        } else if (state == NetworkInfo.State.UNKNOWN) {
                            temp = 6;
                        }
                        WIFI\u7ba1\u7406Impl.this.\u7f51\u7edc\u72b6\u6001\u6539\u53d8(temp);
                    } else {
                        WIFI\u7ba1\u7406Impl.this.\u9996\u6b21\u542f\u52a8b = false;
                    }
                } else if (str.equals("android.net.wifi.supplicant.STATE_CHANGE") && (errorCode = arg1.getIntExtra("supplicantError", -1)) == 1) {
                    WIFI\u7ba1\u7406Impl.this.\u5bc6\u7801\u9519\u8bef();
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.SCAN_RESULTS");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
        \u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587().registerReceiver(mReceiver, filter);
    }

    public void \u626b\u63cf\u5b8c\u6bd5() {
        EventDispatcher.dispatchEvent(this, "\u626b\u63cf\u5b8c\u6bd5", new Object[0]);
    }

    public void \u5f00\u542f\u72b6\u6001\u6539\u53d8(boolean \u72b6\u6001) {
        EventDispatcher.dispatchEvent(this, "\u5f00\u542f\u72b6\u6001\u6539\u53d8", \u72b6\u6001);
    }

    public void \u7f51\u7edc\u72b6\u6001\u6539\u53d8(int \u72b6\u6001) {
        EventDispatcher.dispatchEvent(this, "\u7f51\u7edc\u72b6\u6001\u6539\u53d8", \u72b6\u6001);
    }

    public void \u5bc6\u7801\u9519\u8bef() {
        EventDispatcher.dispatchEvent(this, "\u5bc6\u7801\u9519\u8bef", new Object[0]);
    }

    public String \u83b7\u53d6\u626b\u63cf\u7ed3\u679c() {
        String str = "";
        for (ScanResult localScanResult : this.wm.getScanResults()) {
            if (!str.equals("")) {
                str = str + "/" + localScanResult.SSID + "*" + localScanResult.BSSID + "*" + localScanResult.capabilities + "*" + \u8f6c\u6362\u64cd\u4f5c.\u6574\u6570\u5230\u6587\u672c(localScanResult.level) + "*" + \u8f6c\u6362\u64cd\u4f5c.\u6574\u6570\u5230\u6587\u672c(localScanResult.frequency);
                continue;
            }
            str = localScanResult.SSID + "*" + localScanResult.BSSID + "*" + localScanResult.capabilities + "*" + \u8f6c\u6362\u64cd\u4f5c.\u6574\u6570\u5230\u6587\u672c(localScanResult.level) + "*" + \u8f6c\u6362\u64cd\u4f5c.\u6574\u6570\u5230\u6587\u672c(localScanResult.frequency);
        }
        return str;
    }

    public int \u6dfb\u52a0\u7f51\u7edc(String SSID, String \u5bc6\u7801, int \u52a0\u5bc6\u65b9\u5f0f) {
        int networkid = this.\u53d6\u5df2\u4fdd\u5b58\u7f51\u7edc(SSID);
        if (networkid != -1) {
            return networkid;
        }
        WifiConfiguration config = this.CreateWifiInfo(SSID, \u5bc6\u7801, \u52a0\u5bc6\u65b9\u5f0f);
        return this.wm.addNetwork(config);
    }

    public boolean \u5220\u9664\u7f51\u7edc(int paramInt) {
        return this.wm.removeNetwork(paramInt);
    }

    public void \u9501\u5b9aWIFI() {
        if (this.mWifiLock == null) {
            this.mWifiLock = this.wm.createWifiLock("e4a");
        }
        if (!this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    public void \u89e3\u9501WIFI() {
        if (this.mWifiLock == null) {
            return;
        }
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
    }

    public void \u521b\u5efa\u70ed\u70b9(String SSID, String \u5bc6\u7801) {
        if (this.wifiAp == null) {
            this.wifiAp = new WifiApAdmin(\u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587());
        }
        this.wifiAp.startWifiAp(SSID, \u5bc6\u7801);
    }

    public void \u5173\u95ed\u70ed\u70b9() {
        if (this.wifiAp == null) {
            this.wifiAp = new WifiApAdmin(\u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587());
        }
        WifiApAdmin.closeWifiAp(\u4e0a\u4e0b\u6587\u64cd\u4f5c.\u53d6\u5168\u5c40\u4e0a\u4e0b\u6587());
    }

    public String \u53d6\u5f53\u524dBSSID() {
        return this.wm.getConnectionInfo().getBSSID();
    }

    private String \u5b50\u6587\u672c\u66ff\u6362(String str, String find, String replace) {
        if ("".equals(find) || "".equals(str)) {
            return "";
        }
        find = "\\Q" + find + "\\E";
        return str.replaceAll(find, replace);
    }

    public String \u53d6\u5f53\u524dSSID() {
        String str = this.wm.getConnectionInfo().getSSID();
        str = this.\u5b50\u6587\u672c\u66ff\u6362(str, "\"", "");
        return str;
    }

    public int \u53d6\u5f53\u524dnetworkid() {
        return this.wm.getConnectionInfo().getNetworkId();
    }

    public String \u53d6\u5185\u7f51IP() {
        int ipAddress = this.wm.getConnectionInfo().getIpAddress();
        String ipString = "";
        if (ipAddress != 0) {
            ipString = (ipAddress & 0xFF) + "." + (ipAddress >> 8 & 0xFF) + "." + (ipAddress >> 16 & 0xFF) + "." + (ipAddress >> 24 & 0xFF);
        }
        return ipString;
    }

    public String \u53d6MAC\u5730\u5740() {
        return this.wm.getConnectionInfo().getMacAddress();
    }

    public int \u53d6\u5f53\u524d\u4fe1\u53f7\u5f3a\u5ea6() {
        return WifiManager.calculateSignalLevel((int)this.wm.getConnectionInfo().getRssi(), (int)5);
    }

    public int \u53d6\u5f53\u524d\u8fde\u63a5\u901f\u5ea6() {
        return this.wm.getConnectionInfo().getLinkSpeed();
    }

    public String \u53d6\u7f51\u5173() {
        return Formatter.formatIpAddress((int)this.wm.getDhcpInfo().gateway);
    }

    public String \u53d6\u7f51\u7edc\u524d\u7f00() {
        return Formatter.formatIpAddress((int)this.wm.getDhcpInfo().netmask);
    }

    public String \u53d6DNS1() {
        return Formatter.formatIpAddress((int)this.wm.getDhcpInfo().dns1);
    }

    public String \u53d6DNS2() {
        return Formatter.formatIpAddress((int)this.wm.getDhcpInfo().dns2);
    }

    public WifiConfiguration CreateWifiInfo(String SSID, String Password, int Type2) {
        int networkId = this.\u53d6\u5df2\u4fdd\u5b58\u7f51\u7edc(SSID);
        if (networkId != -1) {
            this.wm.removeNetwork(networkId);
        }
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        if (Type2 == 1) {
            config.allowedKeyManagement.set(0);
        }
        if (Type2 == 2) {
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 3) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = true;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        return config;
    }

    public void \u7f6e\u9759\u6001IP(String SSID, String static_ip, String static_gateway, String static_dns) {
        WifiConfiguration tempConfig = this.IsExsits(SSID);
        if (tempConfig != null) {
            try {
                this.setIpAssignment("STATIC", tempConfig);
                this.setIpAddress(InetAddress.getByName(static_ip), 24, tempConfig);
                this.setGateway(InetAddress.getByName(static_gateway), tempConfig);
                this.setDNS(InetAddress.getByName(static_dns), tempConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.wm.updateNetwork(tempConfig);
        }
    }

    public WifiConfiguration IsExsits(String SSID) {
        List existingConfigs = this.wm.getConfiguredNetworks();
        for (WifiConfiguration existingConfig : existingConfigs) {
            if (!existingConfig.SSID.equals("\"" + SSID + "\"")) continue;
            return existingConfig;
        }
        return null;
    }

    public void setIpAssignment(String assign, WifiConfiguration wifiConf) throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        this.setEnumField(wifiConf, assign, "ipAssignment");
    }

    public void setIpAddress(InetAddress addr, int prefixLength, WifiConfiguration wifiConf) throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, InstantiationException, InvocationTargetException {
        Object linkProperties = this.getField(wifiConf, "linkProperties");
        if (linkProperties == null) {
            return;
        }
        Class<?> laClass = Class.forName("android.net.LinkAddress");
        Constructor<?> laConstructor = laClass.getConstructor(InetAddress.class, Integer.TYPE);
        Object linkAddress = laConstructor.newInstance(addr, prefixLength);
        ArrayList mLinkAddresses = (ArrayList)this.getDeclaredField(linkProperties, "mLinkAddresses");
        mLinkAddresses.clear();
        mLinkAddresses.add(linkAddress);
    }

    public void setGateway(InetAddress gateway, WifiConfiguration wifiConf) throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException {
        Object linkProperties = this.getField(wifiConf, "linkProperties");
        if (linkProperties == null) {
            return;
        }
        Class<?> routeInfoClass = Class.forName("android.net.RouteInfo");
        Constructor<?> routeInfoConstructor = routeInfoClass.getConstructor(InetAddress.class);
        Object routeInfo = routeInfoConstructor.newInstance(gateway);
        ArrayList mRoutes = (ArrayList)this.getDeclaredField(linkProperties, "mRoutes");
        mRoutes.clear();
        mRoutes.add(routeInfo);
    }

    public void setDNS(InetAddress dns, WifiConfiguration wifiConf) throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Object linkProperties = this.getField(wifiConf, "linkProperties");
        if (linkProperties == null) {
            return;
        }
        ArrayList mDnses = (ArrayList)this.getDeclaredField(linkProperties, "mDnses");
        mDnses.clear();
        mDnses.add(dns);
    }

    public Object getField(Object obj, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getField(name);
        Object out = f.get(obj);
        return out;
    }

    public Object getDeclaredField(Object obj, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getDeclaredField(name);
        f.setAccessible(true);
        Object out = f.get(obj);
        return out;
    }

    public void setEnumField(Object obj, String value, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getField(name);
        f.set(obj, Enum.valueOf(f.getType(), value));
    }
}

