/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n39;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.n39.zbar.scan.ScanCaptureAct;
import com.e4a.runtime.components.impl.android.n39.zxing.CaptureActivity;
import com.e4a.runtime.components.impl.android.n39.\u4e8c\u7ef4\u7801;
import com.e4a.runtime.events.EventDispatcher;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;
import net.sourceforge.zbar.SymbolSet;

public class \u4e8c\u7ef4\u7801Impl
extends ComponentImpl
implements \u4e8c\u7ef4\u7801 {
    private static final int QRCODE_RESULT = 444;
    private BroadcastReceiver mReceiver;
    private boolean \u5df2\u6ce8\u518c\u5e7f\u64ad = false;
    private static int style = 1;
    private static boolean beep = false;
    private static boolean continuous = false;
    private static boolean flashlight = false;
    private ImageScanner mImageScanner;

    public \u4e8c\u7ef4\u7801Impl(ComponentContainer container) {
        super(container);
    }

    public void \u7f6e\u626b\u63cf\u6846\u6837\u5f0f(int value) {
        style = value;
    }

    public void \u7f6e\u8fde\u7eed\u626b\u63cf(boolean value) {
        continuous = value;
    }

    public void \u7f6e\u95ea\u5149\u706f\u5f00\u542f(boolean value) {
        flashlight = value;
    }

    public void \u7f6e\u64ad\u653e\u97f3\u6548(boolean value) {
        beep = value;
    }

    public void \u505c\u6b62\u626b\u63cf() {
        Intent intent = new Intent();
        intent.setAction("QRCODESTOP");
        mainActivity.getContext().sendBroadcast(intent);
    }

    public void \u5f00\u59cb\u626b\u63cf() {
        Intent intent;
        if (this.\u5df2\u6ce8\u518c\u5e7f\u64ad) {
            this.\u6ce8\u9500\u5e7f\u64ad();
        }
        this.\u6ce8\u518c\u5e7f\u64ad();
        if (style == 2) {
            intent = new Intent((Context)mainActivity.getContext(), CaptureActivity.class);
            intent.putExtra("style", 2);
        } else {
            intent = new Intent((Context)mainActivity.getContext(), ScanCaptureAct.class);
        }
        intent.putExtra("beep", beep);
        intent.putExtra("continuous", continuous);
        intent.putExtra("flashlight", flashlight);
        mainActivity.getContext().startActivityForResult(intent, 444);
        this.\u5df2\u6ce8\u518c\u5e7f\u64ad = true;
    }

    private void \u6ce8\u518c\u5e7f\u64ad() {
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                String actionStr = arg1.getAction();
                if (actionStr.equals("QRCODE")) {
                    String str = arg1.getStringExtra("code");
                    \u4e8c\u7ef4\u7801Impl.this.\u626b\u63cf\u5b8c\u6bd5(str);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("QRCODE");
        mainActivity.getContext().registerReceiver(this.mReceiver, filter);
    }

    public void \u626b\u63cf\u5b8c\u6bd5(String result) {
        EventDispatcher.dispatchEvent(this, "\u626b\u63cf\u5b8c\u6bd5", result);
        if (!continuous) {
            this.\u6ce8\u9500\u5e7f\u64ad();
        }
    }

    private void \u6ce8\u9500\u5e7f\u64ad() {
        mainActivity.getContext().unregisterReceiver(this.mReceiver);
        this.\u5df2\u6ce8\u518c\u5e7f\u64ad = false;
    }

    public byte[] \u751f\u6210\u6761\u5f62\u7801(String contents, int desiredWidth, int desiredHeight) {
        if (contents == null || "".equals(contents) || contents.length() < 1) {
            return null;
        }
        int WHITE = -1;
        int BLACK = -16777216;
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix result = null;
        try {
            result = writer.encode(contents, BarcodeFormat.CODE_128, desiredWidth, desiredHeight, null);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        int width = result.getWidth();
        int height = result.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public byte[] \u751f\u6210\u4e8c\u7ef4\u7801(String url, int width, int height) {
        try {
            if (url == null || "".equals(url) || url.length() < 1) {
                return new byte[0];
            }
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            BitMatrix bitMatrix = new QRCodeWriter().encode(url, BarcodeFormat.QR_CODE, width, height, hints);
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (WriterException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public byte[] \u751f\u6210\u4e8c\u7ef4\u78012(String url, String logopath, int width, int height) {
        try {
            if (url == null || "".equals(url) || url.length() < 1) {
                return new byte[0];
            }
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            BitMatrix bitMatrix = new QRCodeWriter().encode(url, BarcodeFormat.QR_CODE, width, height, hints);
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            Bitmap bitmap2 = \u4e8c\u7ef4\u7801Impl.createBitmap(bitmap, \u4e8c\u7ef4\u7801Impl.zoomBitmap(\u4e8c\u7ef4\u7801Impl.convertToBitmap(logopath, 60, 60), 100, 100));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (WriterException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static Bitmap convertToBitmap(String path, int w, int h) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        opts.inPreferredConfig = Bitmap.Config.ARGB_8888;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        int width = opts.outWidth;
        int height = opts.outHeight;
        float scaleWidth = 0.0f;
        float scaleHeight = 0.0f;
        if (width > w || height > h) {
            scaleWidth = (float)width / (float)w;
            scaleHeight = (float)height / (float)h;
        }
        opts.inJustDecodeBounds = false;
        float scale = Math.max(scaleWidth, scaleHeight);
        opts.inSampleSize = (int)scale;
        WeakReference<Bitmap> weak = new WeakReference<Bitmap>(BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts));
        return Bitmap.createScaledBitmap((Bitmap)((Bitmap)weak.get()), (int)w, (int)h, (boolean)true);
    }

    private static Bitmap zoomBitmap(Bitmap src, int destWidth, int destHeigth) {
        String tag = "lessenBitmap";
        if (src == null) {
            return null;
        }
        int w = src.getWidth();
        int h = src.getHeight();
        float scaleWidth = (float)destWidth / (float)w;
        float scaleHeight = (float)destHeigth / (float)h;
        Matrix m = new Matrix();
        m.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)true);
        return resizedBitmap;
    }

    private static Bitmap createBitmap(Bitmap src, Bitmap watermark) {
        if (src == null) {
            return null;
        }
        int w = src.getWidth();
        int h = src.getHeight();
        int ww = watermark.getWidth();
        int wh = watermark.getHeight();
        Bitmap newb = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newb);
        cv.drawBitmap(src, 0.0f, 0.0f, null);
        cv.drawBitmap(watermark, (float)(w / 2 - ww / 2), (float)(h / 2 - wh / 2), null);
        cv.save();
        cv.restore();
        return newb;
    }

    public String \u8bc6\u522b\u4e8c\u7ef4\u7801(String imagePath) {
        Bitmap bmp = \u4e8c\u7ef4\u7801Impl.getCompressedBitmap(imagePath);
        int w = bmp.getWidth();
        int h = bmp.getHeight();
        int[] pixels = new int[w * h];
        bmp.getPixels(pixels, 0, w, 0, 0, w, h);
        String resultStr = null;
        if (this.mImageScanner == null) {
            this.mImageScanner = new ImageScanner();
            this.mImageScanner.setConfig(0, 256, 3);
            this.mImageScanner.setConfig(0, 257, 3);
        }
        Image barcode = new Image(w, h, "RGB4");
        barcode.setData(pixels);
        int result = this.mImageScanner.scanImage(barcode.convert("Y800"));
        if (result != 0) {
            SymbolSet syms = this.mImageScanner.getResults();
            for (Symbol sym : syms) {
                resultStr = sym.getData();
            }
        }
        if (resultStr == null) {
            return "";
        }
        return resultStr;
    }

    private static Bitmap getCompressedBitmap(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inSampleSize = \u4e8c\u7ef4\u7801Impl.calculateInSampleSize(options, 480, 800);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    static {
        System.loadLibrary("iconv");
    }
}

