/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n39.zxing.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import com.e4a.runtime.components.impl.android.n39.zxing.camera.CameraManager;
import com.google.zxing.ResultPoint;
import java.util.Collection;
import java.util.HashSet;

public final class ViewfinderView
extends View {
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private static final long ANIMATION_DELAY = 100L;
    private static final int OPAQUE = 255;
    private final Paint paint = new Paint();
    private Bitmap resultBitmap;
    private final int maskColor = 2131034135;
    private final int resultColor = -16776961;
    private final int frameColor = -16711936;
    private final int laserColor = -65536;
    private final int resultPointColor = -256;
    private int scannerAlpha = 0;
    private Collection<ResultPoint> possibleResultPoints = new HashSet<ResultPoint>(5);
    private Collection<ResultPoint> lastPossibleResultPoints;

    public ViewfinderView(Context context) {
        super(context);
    }

    public void onDraw(Canvas canvas) {
        Rect frame = CameraManager.get().getFramingRect();
        if (frame == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? -16776961 : 2131034135);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(255);
            canvas.drawBitmap(this.resultBitmap, (float)frame.left, (float)frame.top, this.paint);
        } else {
            this.paint.setColor(-16711936);
            canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.right + 1), (float)(frame.top + 2), this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.top + 2), (float)(frame.left + 2), (float)(frame.bottom - 1), this.paint);
            canvas.drawRect((float)(frame.right - 1), (float)frame.top, (float)(frame.right + 1), (float)(frame.bottom - 1), this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.bottom - 1), (float)(frame.right + 1), (float)(frame.bottom + 1), this.paint);
            this.paint.setColor(-65536);
            this.paint.setAlpha(SCANNER_ALPHA[this.scannerAlpha]);
            this.scannerAlpha = (this.scannerAlpha + 1) % SCANNER_ALPHA.length;
            int middle = frame.height() / 2 + frame.top;
            canvas.drawRect((float)(frame.left + frame.width() / 2 - 12), (float)(middle - 1), (float)(frame.left + frame.width() / 2 + 14), (float)(middle + 2), this.paint);
            int middle2 = frame.width() / 2 + frame.left;
            canvas.drawRect((float)(middle2 - 1), (float)(frame.top + frame.height() / 2 - 12), (float)(middle2 + 2), (float)(frame.bottom - frame.height() / 2 + 14), this.paint);
            Collection<ResultPoint> currentPossible = this.possibleResultPoints;
            Collection<ResultPoint> currentLast = this.lastPossibleResultPoints;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new HashSet<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(255);
                this.paint.setColor(-256);
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 6.0f, this.paint);
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(127);
                this.paint.setColor(-256);
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 3.0f, this.paint);
                }
            }
            this.postInvalidateDelayed(100L, frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    public void drawViewfinder() {
        this.resultBitmap = null;
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        this.possibleResultPoints.add(point);
    }
}

