/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n39.zxing;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.impl.android.n39.zxing.camera.CameraManager;
import com.e4a.runtime.components.impl.android.n39.zxing.decoding.CaptureActivityHandler;
import com.e4a.runtime.components.impl.android.n39.zxing.decoding.InactivityTimer;
import com.e4a.runtime.components.impl.android.n39.zxing.view.ViewfinderView;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private SurfaceView surfaceView;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet = "ISO-8859-1";
    private InactivityTimer inactivityTimer;
    private Intent intent;
    private int style = 1;
    private boolean continuous = false;
    private boolean flashlight = false;
    private boolean beep = false;
    private BroadcastReceiver mReceiver;
    private MediaPlayer player;
    private String \u6309\u94ae\u6807\u9898 = "\u5f00\u95ea\u5149\u706f";

    private int \u53d6\u8d44\u6e90\u7d22\u5f15(String \u8d44\u6e90\u540d\u79f0, String \u8d44\u6e90\u7c7b\u578b) {
        Resources res = this.getResources();
        return res.getIdentifier(\u8d44\u6e90\u540d\u79f0, \u8d44\u6e90\u7c7b\u578b, this.getPackageName());
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FrameLayout layout = new FrameLayout((Context)this);
        FrameLayout.LayoutParams param = new FrameLayout.LayoutParams(-1, -1);
        param.gravity = 48;
        this.surfaceView = new SurfaceView((Context)this);
        layout.addView((View)this.surfaceView, (ViewGroup.LayoutParams)param);
        this.viewfinderView = new ViewfinderView((Context)this);
        this.viewfinderView.setBackgroundColor(0);
        layout.addView((View)this.viewfinderView, (ViewGroup.LayoutParams)param);
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setOrientation(1);
        LinearLayout.LayoutParams param2 = new LinearLayout.LayoutParams(-1, -2);
        layout2.setHorizontalGravity(1);
        TextView text1 = new TextView((Context)this);
        text1.setTextSize(18.0f);
        text1.setGravity(17);
        text1.setTextColor(0);
        text1.setText((CharSequence)"  \n  ");
        layout2.addView((View)text1, (ViewGroup.LayoutParams)param2);
        LinearLayout layout4 = new LinearLayout((Context)this);
        layout4.setOrientation(0);
        final Button button1 = new Button((Context)this);
        Button button2 = new Button((Context)this);
        button1.setTextSize(18.0f);
        button2.setTextSize(18.0f);
        button1.setGravity(17);
        button2.setGravity(17);
        button1.setText((CharSequence)"\u5f00\u95ea\u5149\u706f");
        button2.setText((CharSequence)"\u53d6\u6d88\u626b\u63cf");
        LinearLayout.LayoutParams param3 = new LinearLayout.LayoutParams(-2, -2);
        layout4.addView((View)button1, (ViewGroup.LayoutParams)param3);
        layout4.addView((View)button2, (ViewGroup.LayoutParams)param3);
        layout2.addView((View)layout4, (ViewGroup.LayoutParams)param2);
        TextView text2 = new TextView((Context)this);
        text2.setTextSize(18.0f);
        text2.setGravity(17);
        text2.setTextColor(-16711936);
        text2.setText((CharSequence)"\u8bf7\u5c06\u56fe\u50cf\u7f6e\u4e8e\u65b9\u6846\u5185");
        layout2.addView((View)text2, (ViewGroup.LayoutParams)param2);
        FrameLayout.LayoutParams param4 = new FrameLayout.LayoutParams(-2, -2);
        param4.gravity = 1;
        layout.addView((View)layout2, (ViewGroup.LayoutParams)param4);
        this.setContentView((View)layout, (ViewGroup.LayoutParams)param);
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        this.style = bundle.getInt("style");
        this.beep = bundle.getBoolean("beep");
        this.continuous = bundle.getBoolean("continuous");
        this.flashlight = bundle.getBoolean("flashlight");
        if (this.beep) {
            this.player = MediaPlayer.create((Context)this, (int)this.\u53d6\u8d44\u6e90\u7d22\u5f15("beep", "raw"));
        }
        CameraManager.init((Context)this.getApplication(), this.style);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                String actionStr = arg1.getAction();
                if (actionStr.equals("QRCODESTOP")) {
                    CaptureActivity.this.stopscan();
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("QRCODESTOP");
        this.registerReceiver(this.mReceiver, filter);
        if (this.flashlight) {
            new Handler().postDelayed(new Runnable(){

                public void run() {
                    CameraManager.get().openFlash();
                    button1.setText((CharSequence)"\u5173\u95ea\u5149\u706f");
                    CaptureActivity.this.\u6309\u94ae\u6807\u9898 = "\u5173\u95ea\u5149\u706f";
                }
            }, 1000L);
        }
        button1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (button1.getText().toString() == "\u5f00\u95ea\u5149\u706f") {
                    CameraManager.get().openFlash();
                    button1.setText((CharSequence)"\u5173\u95ea\u5149\u706f");
                    CaptureActivity.this.\u6309\u94ae\u6807\u9898 = "\u5173\u95ea\u5149\u706f";
                } else {
                    CameraManager.get().closeFlash();
                    button1.setText((CharSequence)"\u5f00\u95ea\u5149\u706f");
                    CaptureActivity.this.\u6309\u94ae\u6807\u9898 = "\u5f00\u95ea\u5149\u706f";
                }
            }
        });
        button2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CaptureActivity.this.stopscan();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.decodeFormats = null;
        this.characterSet = "ISO-8859-1";
    }

    protected void onPause() {
        super.onPause();
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        CameraManager.get().closeDriver();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
        }
        catch (IOException ioe) {
            return;
        }
        catch (RuntimeException e) {
            return;
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.characterSet);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public void handleDecode(Result obj, Bitmap barcode) {
        this.inactivityTimer.onActivity();
        Intent intent3 = new Intent();
        intent3.setAction("QRCODE");
        intent3.putExtra("code", this.recode(obj.getText()));
        this.sendBroadcast(intent3);
        if (this.beep) {
            this.player.start();
        }
        if (!this.continuous) {
            this.unregisterReceiver(this.mReceiver);
            Intent intent2 = new Intent((Context)this, mainActivity.class);
            this.startActivity(intent2);
            this.finish();
        } else {
            if (this.handler != null) {
                this.handler.quitSynchronously();
                this.handler = null;
            }
            CameraManager.get().closeDriver();
            SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
            if (this.hasSurface) {
                this.initCamera(surfaceHolder);
            } else {
                surfaceHolder.addCallback((SurfaceHolder.Callback)this);
                surfaceHolder.setType(3);
            }
            this.decodeFormats = null;
            this.characterSet = "ISO-8859-1";
            if (this.\u6309\u94ae\u6807\u9898 == "\u5173\u95ea\u5149\u706f") {
                CameraManager.get().openFlash();
            }
        }
    }

    private String recode(String resultStr) {
        String UTF_Str = "";
        String GB_Str = "";
        boolean is_cN = false;
        try {
            UTF_Str = new String(resultStr.getBytes("ISO-8859-1"), "UTF-8");
            is_cN = this.isChineseCharacter(UTF_Str);
            boolean b = this.isSpecialCharacter(resultStr);
            if (b) {
                is_cN = true;
            }
            if (!is_cN) {
                GB_Str = new String(resultStr.getBytes("ISO-8859-1"), "GB2312");
                return GB_Str;
            }
            return UTF_Str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isChineseCharacter(String chineseStr) {
        char[] charArray = chineseStr.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] >= '\u0000' && charArray[i] < '\ufffd' || charArray[i] > '\ufffd' && charArray[i] < '\uffff') continue;
            return false;
        }
        return true;
    }

    public boolean isSpecialCharacter(String str) {
        return str.contains("???");
    }

    public void stopscan() {
        this.unregisterReceiver(this.mReceiver);
        Intent intent2 = new Intent((Context)this, mainActivity.class);
        this.startActivity(intent2);
        this.finish();
    }
}

