/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n39.zbar.scan;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.Camera;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.e4a.runtime.components.impl.android.n39.zbar.scan.CameraManager;
import com.e4a.runtime.components.impl.android.n39.zbar.scan.CameraPreview;
import java.io.IOException;
import java.lang.reflect.Field;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;
import net.sourceforge.zbar.SymbolSet;

public class ScanCaptureAct
extends Activity {
    private Camera mCamera;
    private CameraPreview mPreview;
    private Handler autoFocusHandler;
    private CameraManager mCameraManager;
    private TextView scanResult;
    private FrameLayout scanPreview;
    private Button scanFlash;
    private RelativeLayout scanContainer;
    private RelativeLayout scanCropView;
    private ImageView scanLine;
    private Rect mCropRect = null;
    private boolean barcodeScanned = false;
    private boolean previewing = true;
    private ImageScanner mImageScanner = null;
    private boolean flashState = false;
    private boolean continuous = false;
    private boolean beep = false;
    private BroadcastReceiver mReceiver;
    private MediaPlayer player;
    private Runnable doAutoFocus = new Runnable(){

        public void run() {
            if (ScanCaptureAct.this.previewing) {
                ScanCaptureAct.this.mCamera.autoFocus(ScanCaptureAct.this.autoFocusCB);
            }
        }
    };
    Camera.PreviewCallback previewCb = new Camera.PreviewCallback(){

        public void onPreviewFrame(byte[] data, Camera camera) {
            Camera.Size size = camera.getParameters().getPreviewSize();
            byte[] rotatedData = new byte[data.length];
            for (int y = 0; y < size.height; ++y) {
                for (int x = 0; x < size.width; ++x) {
                    rotatedData[x * size.height + size.height - y - 1] = data[x + y * size.width];
                }
            }
            int tmp = size.width;
            size.width = size.height;
            size.height = tmp;
            ScanCaptureAct.this.initCrop();
            Image barcode = new Image(size.width, size.height, "Y800");
            barcode.setData(rotatedData);
            barcode.setCrop(((ScanCaptureAct)ScanCaptureAct.this).mCropRect.left, ((ScanCaptureAct)ScanCaptureAct.this).mCropRect.top, ScanCaptureAct.this.mCropRect.width(), ScanCaptureAct.this.mCropRect.height());
            int result = ScanCaptureAct.this.mImageScanner.scanImage(barcode);
            String resultStr = null;
            if (result != 0) {
                SymbolSet syms = ScanCaptureAct.this.mImageScanner.getResults();
                for (Symbol sym : syms) {
                    resultStr = sym.getData();
                }
            }
            if (TextUtils.isEmpty(resultStr)) {
                return;
            }
            Intent intent3 = new Intent();
            intent3.setAction("QRCODE");
            intent3.putExtra("code", resultStr);
            ScanCaptureAct.this.sendBroadcast(intent3);
            if (ScanCaptureAct.this.beep) {
                ScanCaptureAct.this.player.start();
            }
            if (!ScanCaptureAct.this.continuous) {
                ScanCaptureAct.this.unregisterReceiver(ScanCaptureAct.this.mReceiver);
                ScanCaptureAct.this.previewing = false;
                ScanCaptureAct.this.mCamera.setPreviewCallback(null);
                ScanCaptureAct.this.mCamera.stopPreview();
                ScanCaptureAct.this.releaseCamera();
                ScanCaptureAct.this.finish();
            }
        }
    };
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            ScanCaptureAct.this.autoFocusHandler.postDelayed(ScanCaptureAct.this.doAutoFocus, 1000L);
        }
    };

    private int \u53d6\u8d44\u6e90\u7d22\u5f15(String \u8d44\u6e90\u540d\u79f0, String \u8d44\u6e90\u7c7b\u578b) {
        Resources res = this.getResources();
        return res.getIdentifier(\u8d44\u6e90\u540d\u79f0, \u8d44\u6e90\u7c7b\u578b, this.getPackageName());
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.\u53d6\u8d44\u6e90\u7d22\u5f15("widget_zbar_scan_capture", "layout"));
        this.setRequestedOrientation(1);
        this.setTitle("\u4e8c\u7ef4\u7801/\u6761\u7801 \u626b\u63cf");
        this.findViewById();
        this.addEvents();
        this.initViews();
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        this.beep = bundle.getBoolean("beep");
        this.continuous = bundle.getBoolean("continuous");
        this.flashState = bundle.getBoolean("flashlight");
        if (this.beep) {
            this.player = MediaPlayer.create((Context)this, (int)this.\u53d6\u8d44\u6e90\u7d22\u5f15("beep", "raw"));
        }
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context arg0, Intent arg1) {
                String actionStr = arg1.getAction();
                if (actionStr.equals("QRCODESTOP")) {
                    ScanCaptureAct.this.unregisterReceiver(ScanCaptureAct.this.mReceiver);
                    ScanCaptureAct.this.previewing = false;
                    ScanCaptureAct.this.mCamera.setPreviewCallback(null);
                    ScanCaptureAct.this.mCamera.stopPreview();
                    ScanCaptureAct.this.releaseCamera();
                    ScanCaptureAct.this.finish();
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("QRCODESTOP");
        this.registerReceiver(this.mReceiver, filter);
        if (this.flashState) {
            new Handler().postDelayed(new Runnable(){

                public void run() {
                    Camera.Parameters mParameters = ScanCaptureAct.this.mCamera.getParameters();
                    mParameters.setFlashMode("torch");
                    ScanCaptureAct.this.mCamera.setParameters(mParameters);
                    ScanCaptureAct.this.scanFlash.setBackgroundResource(ScanCaptureAct.this.\u53d6\u8d44\u6e90\u7d22\u5f15("qr_code_flash_close", "drawable"));
                }
            }, 1000L);
        }
    }

    private void findViewById() {
        this.scanPreview = (FrameLayout)this.findViewById(this.\u53d6\u8d44\u6e90\u7d22\u5f15("capture_preview", "id"));
        this.scanResult = (TextView)this.findViewById(this.\u53d6\u8d44\u6e90\u7d22\u5f15("capture_scan_result", "id"));
        this.scanFlash = (Button)this.findViewById(this.\u53d6\u8d44\u6e90\u7d22\u5f15("capture_btn_flash", "id"));
        this.scanContainer = (RelativeLayout)this.findViewById(this.\u53d6\u8d44\u6e90\u7d22\u5f15("capture_container", "id"));
        this.scanCropView = (RelativeLayout)this.findViewById(this.\u53d6\u8d44\u6e90\u7d22\u5f15("capture_crop_view", "id"));
        this.scanLine = (ImageView)this.findViewById(this.\u53d6\u8d44\u6e90\u7d22\u5f15("capture_scan_line", "id"));
    }

    private void addEvents() {
        this.scanFlash.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ScanCaptureAct.this.flashState) {
                    ScanCaptureAct.this.flashState = true;
                    Camera.Parameters mParameters = ScanCaptureAct.this.mCamera.getParameters();
                    mParameters.setFlashMode("torch");
                    ScanCaptureAct.this.mCamera.setParameters(mParameters);
                    ScanCaptureAct.this.scanFlash.setBackgroundResource(ScanCaptureAct.this.\u53d6\u8d44\u6e90\u7d22\u5f15("qr_code_flash_close", "drawable"));
                } else {
                    ScanCaptureAct.this.flashState = false;
                    Camera.Parameters mParameters = ScanCaptureAct.this.mCamera.getParameters();
                    mParameters.setFlashMode("off");
                    ScanCaptureAct.this.mCamera.setParameters(mParameters);
                    ScanCaptureAct.this.scanFlash.setBackgroundResource(ScanCaptureAct.this.\u53d6\u8d44\u6e90\u7d22\u5f15("qr_code_flash_open", "drawable"));
                }
            }
        });
    }

    private void initViews() {
        this.mImageScanner = new ImageScanner();
        this.mImageScanner.setConfig(0, 256, 3);
        this.mImageScanner.setConfig(0, 257, 3);
        this.autoFocusHandler = new Handler();
        this.mCameraManager = new CameraManager((Context)this);
        try {
            this.mCameraManager.openDriver();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Display display = this.getWindowManager().getDefaultDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        RelativeLayout.LayoutParams linearParams = (RelativeLayout.LayoutParams)this.scanCropView.getLayoutParams();
        linearParams.height = (int)((double)width * 0.8);
        linearParams.width = (int)((double)width * 0.8);
        this.scanCropView.setLayoutParams((ViewGroup.LayoutParams)linearParams);
        this.mCamera = this.mCameraManager.getCamera();
        this.mPreview = new CameraPreview((Context)this, this.mCamera, this.previewCb, this.autoFocusCB);
        this.scanPreview.addView((View)this.mPreview);
        TranslateAnimation animation = new TranslateAnimation(2, 0.0f, 2, 0.0f, 2, 0.0f, 2, 0.85f);
        animation.setDuration(5000L);
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        this.scanLine.startAnimation((Animation)animation);
    }

    public void onPause() {
        super.onPause();
        this.releaseCamera();
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.previewing = false;
            this.mCamera.setPreviewCallback(null);
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    private void initCrop() {
        int cameraWidth = this.mCameraManager.getCameraResolution().y;
        int cameraHeight = this.mCameraManager.getCameraResolution().x;
        int[] location = new int[2];
        this.scanCropView.getLocationInWindow(location);
        int cropLeft = location[0];
        int cropTop = location[1] - this.getStatusBarHeight();
        int cropWidth = this.scanCropView.getWidth();
        int cropHeight = this.scanCropView.getHeight();
        int containerWidth = this.scanContainer.getWidth();
        int containerHeight = this.scanContainer.getHeight();
        int x = cropLeft * cameraWidth / containerWidth;
        int y = cropTop * cameraHeight / containerHeight;
        int width = cropWidth * cameraWidth / containerWidth;
        int height = cropHeight * cameraHeight / containerHeight;
        this.mCropRect = new Rect(x, y, width + x, height + y);
    }

    private int getStatusBarHeight() {
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            return this.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    static {
        System.loadLibrary("iconv");
    }
}

