/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n39.zbar.scan;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.IOException;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private SurfaceHolder mHolder;
    private Camera mCamera;
    private Camera.PreviewCallback previewCallback;
    private Camera.AutoFocusCallback autoFocusCallback;

    public CameraPreview(Context context, Camera camera, Camera.PreviewCallback previewCb, Camera.AutoFocusCallback autoFocusCb) {
        super(context);
        this.mCamera = camera;
        this.previewCallback = previewCb;
        this.autoFocusCallback = autoFocusCb;
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        try {
            this.mCamera.setPreviewDisplay(holder);
        }
        catch (IOException e) {
            Log.d((String)"DBG", (String)("Error setting camera preview: " + e.getMessage()));
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mHolder.getSurface() == null) {
            return;
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mCamera.setDisplayOrientation(90);
            this.mCamera.setPreviewDisplay(this.mHolder);
            this.mCamera.setPreviewCallback(this.previewCallback);
            this.mCamera.startPreview();
            this.mCamera.autoFocus(this.autoFocusCallback);
        }
        catch (Exception e) {
            Log.d((String)"DBG", (String)("Error starting camera preview: " + e.getMessage()));
        }
    }
}

