/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.n39.zbar.scan;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class CameraConfigurationManager {
    private static final String TAG = "CameraConfiguration";
    private static final int MIN_PREVIEW_PIXELS = 153600;
    private static final double MAX_ASPECT_DISTORTION = 0.15;
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;

    public CameraConfigurationManager(Context context) {
        this.context = context;
    }

    public void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        Point theScreenResolution = new Point();
        this.screenResolution = theScreenResolution = this.getDisplaySize(display);
        Log.i((String)TAG, (String)("Screen resolution: " + this.screenResolution));
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = this.screenResolution.x;
        screenResolutionForCamera.y = this.screenResolution.y;
        if (this.screenResolution.x < this.screenResolution.y) {
            screenResolutionForCamera.x = this.screenResolution.y;
            screenResolutionForCamera.y = this.screenResolution.x;
        }
        this.cameraResolution = this.findBestPreviewSizeValue(parameters, screenResolutionForCamera);
        Log.i((String)TAG, (String)("Camera resolution x: " + this.cameraResolution.x));
        Log.i((String)TAG, (String)("Camera resolution y: " + this.cameraResolution.y));
    }

    @SuppressLint(value={"NewApi"})
    private Point getDisplaySize(Display display) {
        Point point = new Point();
        try {
            display.getSize(point);
        }
        catch (NoSuchMethodError ignore) {
            point.x = display.getWidth();
            point.y = display.getHeight();
        }
        return point;
    }

    public void setDesiredCameraParameters(Camera camera, boolean safeMode) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (safeMode) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        camera.setParameters(parameters);
        Camera.Parameters afterParameters = camera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.cameraResolution.x != afterSize.width || this.cameraResolution.y != afterSize.height)) {
            Log.w((String)TAG, (String)("Camera said it supported preview size " + this.cameraResolution.x + 'x' + this.cameraResolution.y + ", but after setting it, preview size is " + afterSize.width + 'x' + afterSize.height));
            this.cameraResolution.x = afterSize.width;
            this.cameraResolution.y = afterSize.height;
        }
        camera.setDisplayOrientation(90);
    }

    public Point getCameraResolution() {
        return this.cameraResolution;
    }

    public Point getScreenResolution() {
        return this.screenResolution;
    }

    private Point findBestPreviewSizeValue(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            Log.w((String)TAG, (String)"Device returned no supported preview sizes; using default");
            Camera.Size defaultSize = parameters.getPreviewSize();
            return new Point(defaultSize.width, defaultSize.height);
        }
        ArrayList supportedPreviewSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPreviewSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        if (Log.isLoggable((String)TAG, (int)4)) {
            StringBuilder previewSizesString = new StringBuilder();
            for (Camera.Size supportedPreviewSize : supportedPreviewSizes) {
                previewSizesString.append(supportedPreviewSize.width).append('x').append(supportedPreviewSize.height).append(' ');
            }
            Log.i((String)TAG, (String)("Supported preview sizes: " + previewSizesString));
        }
        double screenAspectRatio = (double)screenResolution.x / (double)screenResolution.y;
        Iterator it = supportedPreviewSizes.iterator();
        while (it.hasNext()) {
            int maybeFlippedHeight;
            Camera.Size supportedPreviewSize = (Camera.Size)it.next();
            int realWidth = supportedPreviewSize.width;
            int realHeight = supportedPreviewSize.height;
            if (realWidth * realHeight < 153600) {
                it.remove();
                continue;
            }
            boolean isCandidatePortrait = realWidth < realHeight;
            int maybeFlippedWidth = isCandidatePortrait ? realHeight : realWidth;
            double aspectRatio = (double)maybeFlippedWidth / (double)(maybeFlippedHeight = isCandidatePortrait ? realWidth : realHeight);
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            if (distortion > 0.15) {
                it.remove();
                continue;
            }
            if (maybeFlippedWidth != screenResolution.x || maybeFlippedHeight != screenResolution.y) continue;
            Point exactPoint = new Point(realWidth, realHeight);
            Log.i((String)TAG, (String)("Found preview size exactly matching screen size: " + exactPoint));
            return exactPoint;
        }
        if (!supportedPreviewSizes.isEmpty()) {
            Camera.Size largestPreview = (Camera.Size)supportedPreviewSizes.get(0);
            Point largestSize = new Point(largestPreview.width, largestPreview.height);
            Log.i((String)TAG, (String)("Using largest suitable preview size: " + largestSize));
            return largestSize;
        }
        Camera.Size defaultPreview = parameters.getPreviewSize();
        Point defaultSize = new Point(defaultPreview.width, defaultPreview.height);
        Log.i((String)TAG, (String)("No suitable preview sizes, using default: " + defaultSize));
        return defaultSize;
    }
}

